/* pkcrack - findkey.c
 *
 * (C) by Peter Conrad <conrad@unix-ag.uni-kl.de>
 *
 * $Id: findkey.c,v 1.4 1996/08/13 13:15:09 conrad Release1_2 $
 *
 * $Log: findkey.c,v $
 * Revision 1.4  1996/08/13 13:15:09  conrad
 * declared main as void to suppress warning
 *
 * Revision 1.3  1996/06/23 12:39:28  lucifer
 * Added char RCSID[]
 *
 * Revision 1.2  1996/06/23  10:34:30  lucifer
 * findkey now prints status information, which may be used to restart
 * the program at a later time.
 * key[012] values are now read from the command line instead of stdin.
 *
 * Revision 1.1  1996/06/10 17:41:53  conrad
 * Initial revision
 *
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include "pkcrack.h"
#include "stage3.h"
#include "crc.h"

static char RCSID[]="$Id: findkey.c,v 1.4 1996/08/13 13:15:09 conrad Release1_2 $";

static void usage( char *name )
{
    fprintf( stderr, "Usage: %s <key0> <key1> <key2> [<pwdlen> <initvalue>]\n", name );
    fprintf( stderr, "<key0>, <key1> and <key2> must be in hexadecimal.\n" );
    fprintf( stderr, "<pwd> and <initvalue> can be given to continue an interrupted search.\n" );
    fprintf( stderr, "<initvalue> must also be in hexadecimal.\n" );
    exit( 1 );
}

void main( int argc, char **argv )
{
uword	key0, key1, key2;
int	pwdLen=0;
uword	initBytes;

    if( argc != 4 && argc != 6 )
	usage( argv[0] );

    if( sscanf( argv[1], "%x", &key0 ) != 1 ||
	sscanf( argv[2], "%x", &key0 ) != 1 ||
	sscanf( argv[3], "%x", &key0 ) != 1 )
	usage( argv[0] );

    if( argc == 6 && (sscanf( argv[4], "%d", &pwdLen ) != 1 ||
		      sscanf( argv[5], "%x", &initBytes ) != 1) )
	usage( argv[0] );

    mkCrcTab( );
    initStage3Tab( );

    if( pwdLen > 0 )
	findLongPwd( key0, key1, key2, pwdLen, initBytes );
    else
	findPwd( key0, key1, key2 );
}

