/*
 * extract.c
 *
 * This file contains the main() function of a program for extracting
 * compressed data from a ZIP-archive. Gratefully received from a person who
 * wishes to remain anonymous.
 * Slightly modified by Peter Conrad, Aug '96
 *
 */
/******************************************************************************/
/*                                                                            */
/* FUNCTION       Extracts a file from a ZIP archive                          */
/*                                                                            */
/* INPUT          zipfilename                                                 */
/*                file to extract                                             */
/******************************************************************************/

/*
 * $Id: extract.c,v 1.3 1996/08/21 17:52:24 conrad Release1_2 $
 *
 * $Log: extract.c,v $
 * Revision 1.3  1996/08/21 17:52:24  conrad
 * Some more cleanups to suppress warnings
 *
 * Revision 1.2  1996/08/21 17:34:42  conrad
 * cleaned some things up...
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <malloc.h>
#include "headers.h"

static char RCSID[]="$Id: extract.c,v 1.3 1996/08/21 17:52:24 conrad Release1_2 $";

extern char *extract( char *, char * );
extern char *strupr(char*);

#ifndef O_BINARY
#define	O_BINARY	0
#endif

void main(int argc, char *argv[])
{
char	*ret;
char 	*decfile;
int	outfile, err=0;

  if(argc != 3)
  {
    printf("Usage: %s <zipfile> <file>\n",argv[0]);
    exit(1);
  }
  else;

  decfile = strupr(argv[2]);

  /****************************************************************************/
  /* search file and write it to disk                                         */
  /****************************************************************************/
  err = !(ret = extract(argv[1], decfile));

  free(decfile);

  if( !err )
  {
    outfile = open( argv[2], O_CREAT|O_WRONLY|O_BINARY, 0644 );
    if( outfile < 0 )
    {
	fprintf( stderr, "Couldn't open %s!\n", argv[2] );
	err = 1;
    }
    else
    {
	if( write( outfile, ret, lh.csize ) != lh.csize )
	{
	    fprintf( stderr, "Couldn't write to %s!\n", argv[2] );
	    err = 1;
	}
	close( outfile );
    }
    free( ret );
  }
  exit(err);
}
