#include <stdio.h>
#include "pu_defs.h"

extern int PU_Read();

void printonoff(char *str, int flag)
{
	printf("%s",str);
	if (flag)
		printf("On\n");
	else
		printf("Off\n");
}

void main(int argc, char *argv[])
{
	PICDEFN pic;

	if(argc!=2)
	{
		printf("\nUseage:\n%s <inputfile>\n",argv[0]);
		exit(1);
	}

	if (PU_Read(argv[1],&pic) == PU_FAIL)
		exit(1);

	printf(";-------------------------------\n\n");
	printf("Filename:       %s\n\n",argv[1]);
	printf("Chip type:      %d\n",pic.pictype);

	if (pic.pictype <1660)
	{
		printf("  Arch:		12 bit\n");
	}
	else
	{
		if (pic.pictype > 1699)
		{
			printf("  Arch:		16 bit\n");
		}
		else
		{
			printf("  Arch:		14 bit\n");
		}
	}
			
	printf("\nClock Freq:     %.4f MHz\n",pic.clock/1000000.0);
	switch(pic.osctype)
	{
		case 0:		printf("Oscillator:     LP\n\n");
				break;
		case 1:		printf("Oscillator:     XT\n\n");
				break;
		case 2:		printf("Oscillator:     HS\n\n");
				break;
		case 3:		printf("Oscillator:     RC\n\n");
				break;
		default:	printf("Oscillator:     Unknown\n\n");
				break;
	}

	printonoff("Code Protect:   ",!pic.cp_fuse);
	printonoff("Watchdog Timer: ",pic.wd_fuse);
	printonoff("Power Up:       ",pic.pu_fuse);

	printf("\nID words are:   %04x %04x %04x %04x\n\n",
		pic.picid[0],pic.picid[1],pic.picid[2],pic.picid[3]);

	printf(";-------------------------------\n");
}

/* ... The End ... */
