/*
 * Macros for calling kernel functions
 */

#ifndef KERNEL_H
#define KERNEL_H

#include "filesys.h"

/* kernel services */
extern struct kerinfo *kernel;

#define Cconws(s) (void)(*kernel->dos_tab[0x09])((const char*)s)
#define Dcntl(cmd,s,arg) (long)(*kernel->dos_tab[0x130])  \
                                   ((short)cmd,(const char*)s,(long)arg)
#define Frename(junk,old,new) (long)(*kernel->dos_tab[0x56])  \
                                 ((short)junk, (const char*)old, (const char*)new)
#define Tgettime() (long)(*kernel->dos_tab[0x2c])()
#define Tgetdate() (long)(*kernel->dos_tab[0x2a])()

#define Fopen(s,m) (long)(*kernel->dos_tab[0x3d])((const char*)s, (short)m)
#define Fclose(fh) (long)(*kernel->dos_tab[0x3e])((short)fh)
#define Fread(fh,cnt,buf) (long)(*kernel->dos_tab[0x3f])  \
                                     ((short)fh,(long)cnt,(char*)buf)
#define Fwrite(fh,cnt,buf) (long)(*kernel->dos_tab[0x40])  \
                                     ((short)fh,(long)cnt,(const char*)buf)
#define Fdelete(name)  (long)(*kernel->dos_tab[0x41])((char*)name)
#define Syield() (long)(*kernel->dos_tab[0xff])()
#define Fcntl(fh,arg,cmd) (long)(*kernel->dos_tab[0x104])  \
                                      ((short)fh,(long)arg,(short)cmd)
#define Pgetpid() (short)(*kernel->dos_tab[0x10b])()
#define Pgetuid() (short)(*kernel->dos_tab[0x10f])()
#define Pgetgid() (short)(*kernel->dos_tab[0x114])()
#define Pgeteuid() (short)(*kernel->dos_tab[0x138])()
#define Pgetegid() (short)(*kernel->dos_tab[0x139])()
#define Fselect(t,rp,wp,xp) (long)(*kernel->dos_tab[0x11d])  \
                                     ((unsigned short)t, (long*)rp,  \
                                               (long*)wp, (long*)xp)
#define Pdomain(dom)  (short)(*kernel->dos_tab[0x119])((short)dom)

#define Pgetgroups(l,g) (long)(*kernel->dos_tab[0x147])  \
                                  ((short)(l), (short*)(g))



#define Kmalloc(n) (void*)(*kernel->kmalloc)((long)n)
#define Kfree(p) (void)(*kernel->kfree)((void*)p)

#define Umalloc(n) (void*)(*kernel->umalloc)((long)n)
#define Ufree(p) (void)(*kernel->ufree)((void*)p)

#define Dostime(t) (*kernel->dostim)((long)t)
#define Unixtime(t,d) (*kernel->unixtim)  \
                            ((unsigned short)t, (unsigned short)d)



#ifndef NDEBUG
#define DEBUG(x)  (*kernel->debug) x
#define ALERT(x)  (*kernel->alert) x
#define TRACE(x)  (*kernel->trace) x
#define FATAL(x)  (*kernel->fatal) x
#else
#define DEBUG(x)
#define ALERT(x)
#define TRACE(x)
#define FATAL(x)
#endif

#define Stricmp(s1, s2) (short)(*kernel->stricmp)((char*)s1, (char*)s2)
#define Toupper	(char*)(*kernel->strupr)
#define Tolower(s) (char*)(*kernel->strlwr)((char*)s)


#ifndef TRUE
#define TRUE	1
#endif

#ifndef FALSE
#define FALSE	0
#endif

#endif
