/*
 * Copyright 1993, 1994 by Ulrich Khn. All rights reserved.
 *
 * THIS PROGRAM COMES WITH ABSOLUTELY NO WARRANTY, NOT
 * EVEN THE IMPLIED WARRANTIES OF MERCHANTIBILITY OR
 * FITNESS FOR A PARTICULAR PURPOSE. USE AT YOUR OWN
 * RISK.
 */

/*
 * File : fh.h
 *        definitions for the file handle maintainance
 */

#ifndef FH_H
#define FH_H

#include <unistd.h>
#include <dirent.h>
#include <types.h>
#include <stat.h>
#include "../xfs/nfs.h"
#include "mount.h"


#define MAX_CHAIN  10  /* max lenght of symlink chain */

#define MAX_INODE  ((FHSIZE-sizeof(short)-sizeof(long))/sizeof(u_char)-1)

typedef struct svc_fh
{
	short dev;        /* device number */
	long inode;       /* inode of that file */
	u_char n_ino;     /* number of inodes in the access path list */
	u_char ino[MAX_INODE];  /* mangled inodes of the access path */
} svc_fh;



struct nfsd_cache;


typedef struct file_descr
{
	struct nfsd_cache *f_holder;   /* current owner of this file descriptor */
	long flags;
#define DSCR_FILE  0x0001         /* is this associated with a file or dir ? */
#define DSCR_OPEN  0x8000         /* this handle is in use */

	union
	{
		int fh;
		long dirh;
	} handle;
	long position;
	int open_mode;
	long atime;            /* time stamp of last access to this file */
} FILE_DESCR;



typedef struct nfsd_cache
{
	struct nfsd_cache *next, *prev;
	struct nfsd_cache *accnext, *accprev;
	svc_fh fh;                     /* the nfs file handle for this */
	long flags;
#define EXPORT_ROOT     0x8000   /* this is an entry from the exports file */
#define IS_ON_TOSFS     0x4000   /* file is on tos fs: we have no inodes! */
#define INDEX_IS_FILE   0x0001   /* this is a regular file */

	exportlist *ex_index;   /* exported dir, which tree this one lies in. */
	struct file_descr *fd;
	long atime;         /* last access time */

	char *filename;     /* this points to a part of full_name; don't free!! */
	char *fullname;     /* full filename for opening the file or directory */
} NFSD_CACHE;




/* DO NOT increase the number of file handles before MiNT can open
 * more than 32 files at once for a process
 */
#define NFILEHANDLE   24   /* min. number of file handles */
#define NDIRHANDLE    32   /* min. number of directory handles */
#define NINDEX       256   /* min. number of file caches */


extern FILE_DESCR *file_handle;
extern FILE_DESCR *dir_handle;
extern NFSD_CACHE *file_index;


void fh_init();

long nfs_errno(long err_code);
void fh_update(NFSD_CACHE *index);
void fh_delete(NFSD_CACHE *index);
int fh_delete_by_name(NFSD_CACHE *dir, char *name);
NFSD_CACHE *fh_find(svc_fh *handle);
FILE_DESCR *index_to_fd(NFSD_CACHE *index, int o_mode);
FILE_DESCR *new_fd(NFSD_CACHE *index, int o_mode, int handle);
NFSD_CACHE *fh_new(NFSD_CACHE *dir, char *name, struct stat *st);
int fh_create(char *pathname, svc_fh *handle);


#endif
