# Generated automatically from Makefile.in by configure.
# Makefile for the Universal NFS Server.	-*- Indented-Text -*-
# Copyright (C) 1993 Rick Sladkey.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#### Start of system configuration section. ####

srcdir = .

CC = gcc
AR = ar
RANLIB = ranlib

INSTALL = /usr/bin/install -c
INSTALL_PROGRAM = ${INSTALL} -m 755
INSTALL_DATA = ${INSTALL} -m 644
MAKEINFO = makeinfo
TEXI2DVI = texi2dvi
RPCGEN = rpcgen -C

# General compile options and libs:
DEFS = -DHAVE_CONFIG_H $(NFSD_DEFS)
LIBS = libnfs.a 

# Compile options for nfsd:
# CALL_PROFILING
#	Profiles all NFS RPC calls in the server. Statistics can be dumped
#	to /tmp/nfsd.profile by sending a SIGIOT to the server.
# DOSHACKS
#	This is a hack that lets DOS boxes mount NFS volumes with all_squash
#	enabled and actually write to them, even though their uid/gid does
#	not match the anon_uid/anon_gid. Ugly, and not officially supported.
#	(Don't you call me a hypocrite:)
# SUPPORT_CDF
#	Experimental support for context-dependent files on LOOKUP.
#	Currently supported names are cdf:uid and cdf:hostaddr. When a
#	CDF component cannot be looked up, it will be replaced with
#	the catch-all name "default".
# DEBUG
#	General debugging enable flag
#NFSD_DEFS = -DCALL_PROFILING
NFSD_DEFS =

CFLAGS = -O
LDFLAGS = -s
WARNFLAGS = -Wall
RPC_WARNFLAGS = -Wno-unused -Wno-switch -Wno-uninitialized
TRANSPORTFLAGS = -I -s udp -s tcp

prefix	= $(install_prefix)/usr
exec_prefix = $(prefix)

bindir	= $(exec_prefix)/sbin
infodir = $(prefix)/info
man5dir = $(prefix)/man/man5
man5ext = .5
man8dir = $(prefix)/man/man8
man8ext = .8

# Prefix to be prepended to each installed RPC program, normally `rpc.'.
rpcprefix = rpc.
# Prefix to be prepended to each installed program, normally empty or `g'.
binprefix = 

#### End of system configuration section. ####

# include site-specific defintions generated by BUILD.
include site.mk

SHELL = /bin/sh

SRCS		= version.c logging.c fh.c auth_init.c auth_clnt.c auth.c \
		  nfsd.c nfs_dispatch.c getattr.c setattr.c \
		  mountd.c mount_dispatch.c \
		  ugid_clnt.c ugid_map.c ugid_xdr.c ugidd.c \
		  rquotad.c rquota_dispatch.c rquota_xdr.c \
		  rpcmisc.c rmtab.c showmount.c
LIBSRCS		= fileblocks.c fsusage.c realpath.c strerror.c \
		  utimes.c mkdir.c rename.c getopt.c getopt1.c \
		  alloca.c eaccess.c mountlist.c xmalloc.c \
		  xstrdup.c strdup.c strstr.c nfsmounted.c faccess.c
XDRFILES	= mount.x nfs_prot.x
GENFILES	= mount.h mount_xdr.c mount_svc.c nfs_prot.h nfs_prot_xdr.c \
		  ugid.h ugid_xdr.c ugid_clnt.c
HDRS		= system.h nfsd.h auth.h fh.h logging.h fakefsuid.h \
		  rpcmisc.h faccess.h rquotad.h rquota.h
LIBHDRS		= fsusage.h getopt.h mountlist.h
MANPAGES5	= exports
MANPAGES8	= mountd nfsd showmount $(UGIDD_MAN)
MANPAGES	= $(MANPAGES5) $(MANPAGES8)
LIBOBJS		= version.o getopt.o getopt1.o eaccess.o \
		  fsusage.o mountlist.o xmalloc.o xstrdup.o \
		  nfsmounted.o faccess.o  
OBJS		= logging.o fh.o auth_init.o auth_clnt.o auth.o
NFSD_OBJS	= nfsd.o rpcmisc.o nfs_dispatch.o getattr.o setattr.o \
		  nfs_prot_xdr.o ugid_clnt.o ugid_map.o ugid_xdr.o $(OBJS)
MOUNTD_OBJS	= mountd.o rpcmisc.o mount_dispatch.o mount_xdr.o rmtab.o \
		  $(OBJS)
SHOWMOUNT_OBJS	= showmount.o mount_xdr.o
UGIDD_OBJS	= ugidd.o ugid_xdr.o logging.o
RQUOTAD_OBJS	= rquotad.o rquota_xdr.o rquota_dispatch.o rpcmisc.o \
		  logging.o
DAEMONS		= $(rpcprefix)mountd $(rpcprefix)nfsd $(UGIDD_PROG) \
		  $(RQUOTAD_PROG)
CLIENTS		= showmount

DISTFILES	= $(SRCS) $(HDRS) $(MANPAGES) \
		  $(XDRFILES) $(LIBSRCS) $(LIBHDRS) \
		  ChangeLog README NEWS TODO INSTALL COPYING \
		  Makefile.in configure.in aclocal.m4 acconfig.h \
		  config.h.in configure mkinstalldirs

all: $(rpcprefix)mountd $(rpcprefix)nfsd showmount $(UGIDD_PROG)
.PHONY: all

.PHONY: info dvi
info: nfs-server.info
dvi: nfs-server.dvi

COMPILE = $(CC) -c $(CPPFLAGS) $(DEFS) -I. -I$(srcdir) $(CFLAGS) $(WARNFLAGS)

.c.o:
	$(COMPILE) $<

.PHONY: install installdirs
install: $(DAEMONS) $(CLIENTS) installdirs
	@for prog in $(DAEMONS) $(CLIENTS); do \
	    echo "installing $$prog in $(bindir)";	\
	    $(INSTALL_PROGRAM) $$prog $(bindir)/$$prog;	\
	done
	@for manp in $(MANPAGES5); do			\
	    echo "installing $$manp$(man5ext) in $(man5dir)";	\
	    $(INSTALL_DATA) $(srcdir)/$$manp.man	\
	        $(man5dir)/$$manp$(man5ext); \
	done
	@for manp in $(MANPAGES8); do			\
	    echo "installing $$manp$(man8ext) in $(man8dir)";	\
	    $(INSTALL_DATA) $(srcdir)/$$manp.man	\
	        $(man8dir)/$$manp$(man8ext); 		\
	    if [ 'x$(rpcprefix)' != 'x' ]; then \
	        rm -f $(man8dir)/$(rpcprefix)$$manp$(man8ext); \
	        ln $(man8dir)/$$manp$(man8ext) \
	            $(man8dir)/$(rpcprefix)$$manp$(man8ext); \
	    fi; \
	done

installdirs:
	${srcdir}/mkinstalldirs $(bindir) $(man5dir) $(man8dir)

$(rpcprefix)mountd: $(MOUNTD_OBJS) libnfs.a
	$(CC) $(LDFLAGS) -o $@ $(MOUNTD_OBJS) $(LIBS)

$(rpcprefix)nfsd: $(NFSD_OBJS) libnfs.a
	$(CC) $(LDFLAGS) -o $@ $(NFSD_OBJS) $(LIBS)

$(rpcprefix)ugidd: $(UGIDD_OBJS) libnfs.a
	$(CC) $(LDFLAGS) -o $@ $(UGIDD_OBJS) $(LIBS) \
		$(LIBWRAP_DIR) $(LIBWRAP_LIB)

$(rpcprefix)rquotad: $(RQUOTAD_OBJS) libnfs.a
	$(CC) $(LDFLAGS) -o $@ $(RQUOTAD_OBJS) $(LIBS)

showmount: $(SHOWMOUNT_OBJS) libnfs.a
	$(CC) $(LDFLAGS) -o $@ $(SHOWMOUNT_OBJS) $(LIBS)

version.c: .version
	VERSION=`cat .version`; \
	echo "char version[] = \"Universal NFS Server $$VERSION\";" > version.c

nfs_prot.h: nfs_prot.x
	rm -f $@
	$(RPCGEN) -h -o $@ $?
nfs_prot_xdr.c: nfs_prot.x
	rm -f $@
	$(RPCGEN) -c $? | \
		sed 's;^#include ".*/nfs_prot.h"$$;#include "nfs_prot.h";' >$@

mount.h: mount.x
	rm -f $@
	$(RPCGEN) -h -o $@ $?
mount_xdr.c: mount.x
	rm -f $@
	$(RPCGEN) -c $? | \
		  sed 's;^#include ".*/mount.h"$$;#include "mount.h";' >$@
mount_svc.c: mount.x
	rm -f $@
	$(RPCGEN) -m $? | \
		sed 's;^#include ".*/mount.h"$$;#include "mount.h";' >$@

ugid.h:	ugid.x
	rm -f $@
	$(RPCGEN) -h -o $@ $?
ugid_xdr.c: ugid.x
	rm -f $@
	$(RPCGEN) -c $? | \
		  sed 's;^#include ".*/ugid.h"$$;#include "ugid.h";' >$@
ugid_clnt.c: ugid.x
	rm -f $@
	$(RPCGEN) -l -o $@ $?

nfs_prot_xdr.o: nfs_prot_xdr.c
	$(COMPILE) $(RPC_WARNFLAGS) -c nfs_prot_xdr.c
mount_xdr.o: mount_xdr.c
	$(COMPILE) $(RPC_WARNFLAGS) -c mount_xdr.c
mount_svc.o: mount_svc.c
	$(COMPILE) $(RPC_WARNFLAGS) -c mount_svc.c
ugid_xdr.o: ugid_xdr.c
	$(COMPILE) $(RPC_WARNFLAGS) -c ugid_xdr.c
ugid_clnt.o: ugid_clnt.c
	$(COMPILE) $(RPC_WARNFLAGS) -c ugid_clnt.c

$(MOUNTD_OBJS): config.h nfs_prot.h mount.h
$(NFSD_OBJS): config.h nfs_prot.h mount.h
$(SHOWMOUNT_OBJS): config.h mount.h
ugid_map.o ugid_clnt.o: config.h ugid.h
$(UGIDD_OBJS): config.h ugid.h
ugidd.o: ugidd.c
	$(COMPILE) $(UGIDD_DEFS) -c ugidd.c

libnfs.a: $(LIBOBJS)
	rm -f $@
	$(AR) cr $@ $(LIBOBJS)
	-$(RANLIB) $@

nfs-server.info: nfs-server.texi
	$(MAKEINFO) -I$(srcdir) -o nfs-server.info $(srcdir)/nfs-server.texi
nfs-server.dvi: nfs-server.texi
	$(TEXI2DVI) $(srcdir)/nfs-server.texi

README: README.mm
	groff -mgm -Tascii README.mm | col -b > README

.PHONY: check
check: nfs-server
	@echo nothing to check

# this causes nothing but grief
#Makefile: Makefile.in config.h.in config.status
#	$(SHELL) config.status
#config.status: configure
#	$(SHELL) config.status --recheck
#configure: configure.in aclocal.m4
#	cd $(srcdir) && autoconf
#config.h.in: configure.in acconfig.h
#	cd $(srcdir) && autoheader

TAGS: $(SRCS)
	etags $(SRCS)

.PHONY: clean mostlyclean distclean realclean dist

clean mostlyclean distclean::
	rm -f $(rpcprefix)mountd $(rpcprefix)nfsd
	rm -f $(rpcprefix)ugidd $(rpcprefix)rquotad
	rm -f showmount 
	rm -f *.o libnfs.a core
	rm -f nfs-server.dvi nfs-server.?? nfs-server.??s
	rm -f LOG X Y Z
	rm -f $(GENFILES)

mostlyclean distclean::
	rm -f Makefile config.h config.status config.cache config.log
	rm -f TAGS nfs-server.info*

distclean::
	rm -f site.h site.mk

# Prevent GNU make v3 from overflowing arg limit on SysV.
.NOEXPORT:
