/*
 * interface to sound hardware drivers for /dev/audio.
 *
 * 11/03/95, Kay Roemer.
 *
 * 9802, John Blakeley - supporting F030's recording ability.
 */

#ifndef _DEVICE_H
#define _DEVICE_H

/*
 * sample buffer - 2 * 32K
 */
#define BUFSIZE (0x8000L - sizeof (long))

/*
 * sound hardware descriptor
 */
struct device {
	short	maxchans;		/* max. no. of channels supported */
	short	curchans;		/* 1 = mono, 2 = stereo, 4 = quad, etc */
	short	format_map;		/* bitmask of AFMT_???? */
	short	curformat;
	short	ssize;	/* 8 = 8bits, 16 = 16bits */
	short	status;			/* rec < 0 < playing */
	long	srate;
	void	(*reset) (void);
	void	*(*copyfn) (void *dst, const void *src, size_t len);
	long	(*copyin) (char *buf, long len);
	long	(*copyout) (char *buf, long len);
	long	(*ioctl) (short mode, void *arg);
	long	(*wspace) (void);
	long	(*rspace) (void);
	long	(*mix_ioctl) (short cmd, void *arg);
};

extern struct device thedev;

struct dmabuf {
	long used;
	unsigned char buf[BUFSIZE];
};

extern struct dmabuf dmab[2];

/*
 * index into dmab. points to buffer currently being filled
 * by write().
 */
extern volatile short bufidx;

/*
 * write selector.
 */
extern long audio_rsel;

/*
 * asm stuff
 */
extern void  new_timera_vector (void);
extern void  new_gpi7_vector (void);
extern void  psg_player (void);
extern void  (*timer_func) (void);

#endif
