/*
 * FIDO_MSG.H
 *
 * header-module for special messages for FIDO software;
 *
 * It's possible to send some fido programs messages, so they will
 * do certain things as soon as possible. Just send a message via 
 * appl_write():
 *
 * WORD message[8], id;
 *
 * id = appl_find( "SEMPER	" );		// or "AVALON  " or "OCTOPUS "
 *
 * if (id>=0)
 * {
 *	   message[0] = FIDO_MSG;			// MAGIC value
 *	   message[1] = ap_id;				// appl_init ID of the sender
 *	   message[2] = 0;					// just a 16 byte message
 *	   *((LONG *) &message[3]) = FROM;	// Sender verification
 *	   *((LONG *) &message[5]) = TODO;	// what's to be done
 *	   message[7] = 0;					// reserved
 *
 *	   appl_write( id, 16, message );
 * }
 *
 * Make sure that _all_ applications with the same name are getting
 * the needed information!! Within a multitasking environment check
 * for the appl_search() function and use this one instead of appl_find()!!
 *
 * Code to check this is available here if necessary.
 */

#ifndef __FIDO_MSG_H__
#define __FIDO_MSG_H__

/*--- includes				---*/

/*--- defines				---*/

/*
 * Magic value for recognizing incoming messages:
 */
#define 	FIDO_MSG		'FM'		/* Magic value for identifying			*/
#define		FIDO_HELLO		'=?-/'		/* For handshake purpose (if necessary)	*/
#define		FIDO_HELLO_ACK	'=:-)'		/* Handshake acknowledge				*/

/*
 * ID's for the 'FROM'-field:
 */
#define 	FM_SEMPER		'SEMP'		/* Semper			*/
#define 	FM_AVALON		'AVAL'		/* Avalon shell 	*/
#define 	FM_MSGREADER	'MSGR'		/* e.g. LED 		*/
#define 	FM_TOSSER		'TOSS'		/* e.g. JetMail 	*/
#define 	FM_REQCOMPILER	'REQC'		/* RequestCompiler	*/
#define 	FM_NLCOMPILER	'NLST'		/* NodelistCompiler */
#define 	FM_OCTOPUS		'OCTP'		/* Octopus BBS		*/

/*
 * Currently supported SEMPER-TODO values:
 */
#define 	SEMP_RESCAN 	(1UL << 0)	/* Rescan outbound				*/
#define 	SEMP_READ_NLIST (1UL << 1)	/* Reread nodelist				*/
#define 	SEMP_READ_RQST	(1UL << 2)	/* Reread request index 		*/
#define 	SEMP_EXPORTER	(1UL << 3)	/* Executes the Export program	*/

/*
 * Currently supported AVALON-TODO values:
 */
#define 	 AVAL_REQ		1UL 	  /* FileRequest				  */
#define 	 AVAL_HATCH 	2UL 	  /* FileHatch					  */
#define 	 AVAL_FIX		3UL 	  /* Areafix					  */
#define 	 AVAL_AREAS 	4UL 	  /* Edit areas 				  */

/*
 * Currently supported OCTOPUS-TODO values:
 */
#define OCTO_M_LOCAL	 0x0001UL  /* Begin a local logon						  */
#define OCTO_M_WATCH	 0x0002UL  /* Open a View window when a connection exist  */
#define OCTO_M_MAILER	 0x0004UL  /* End Octopus after a connection (not needed) */
#define OCTO_M_NOHANGUP  0x0008UL  /* Don't raise the DTR signal for hangup 	  */
#define OCTO_M_STATUS	 0x0010UL  /* Request of Octopus Status					  */

/*
 * Return values for Octopus->Semper:
 */

#define OCTO_M_OK		 0x0010UL  /* Ok, ACK handshake message 		*/
#define OCTO_M_BUSY 	 0x0020UL  /* Octopus is busy yet				*/
#define OCTO_M_READY	 0x0040UL  /* Octopus is waiting (ready) now... */
#define OCTO_M_HELLO	 0x0080UL  /* Say Hello to Semper... :-)		*/

/*--- types 				---*/

/*--- variables 			---*/

/*--- prototypes			---*/

/*--- End of fido_msg.h module	---*/
#endif
