/*

t-snprintf.c

Author: Tatu Ylonen <ylo@ssh.fi>

Copyright (c) 1996 SSH Communications Security, Finland
                   All rights reserved

Created: Thu Oct 24 22:38:16 1996 ylo
Last modified: Thu Oct 24 22:58:56 1996 ylo

*/

#include "sshincludes.h"
#include "stdarg.h"

void test(const char *expect, const char *fmt, ...)
{
  va_list va;
  char buf[1024];

  va_start(va, fmt);
  vsnprintf(buf, sizeof(buf), fmt, va);
  va_end(va);

  if (strcmp(expect, buf) != 0)
    {
      printf("snprintf test failed, format '%s', expected '%s', got '%s'\n",
             fmt, expect, buf);
      exit(1);
    }
}

Boolean testpad(unsigned char *buf)
{
  int i;
  for (i = 0; i < 10; i++)
    if (buf[i] != 10+i)
      return FALSE;
  return TRUE;  
}

int main(int ac, char **av)
{
  char buf[1024];
  unsigned char buf2[30];
  int pass, status = 0, i;

  for (pass = 0; pass < 100; pass++)
    {
      snprintf(buf, sizeof(buf), "a%dl", 7);
      if (strcmp(buf, "a7l") != 0)
        {
          printf("trivial snprintf test failed\n");
          exit(1);
        }
      
      test("-124", "%d", -124);
      test(" -124", "%5d", -124);
      test("-124 ", "%-5d", -124);
      test("00124", "%05d", 124);
      test("1234567", "%5ld", 1234567L);

      test("d", "%c", 100);
      test("64", "%x", 100);
      test("0A", "%02X", 10);
      test("0x64", "%#x", 100);
      test("0064", "%04x", 100);
      test("144", "%lo", 100L);

      test("ab", "%.2s", "abcdef");
      test("abcdef", "%2s", "abcdef");
      test("    abc", "%*.*s", 7, 3, "abcdef");
      test("   ab", "%5.2s", "abcdef");
      test("ab   ", "%-5.2s", "abcdef");

      test("1.1", "%g", 1.1);
      test("-7.4", "%lg", (double)-7.4);
    }

  for (i = 0; i < 10; i++)
    {
      buf2[i     ] = 10+i;
      buf2[20 + i] = 10+i;
    }

  snprintf((char *)(buf2+10), 10, "kukkuu%s", "RESET");
  if (strcmp((char *)(buf2+10), "kukkuuRESET") == 0 || 
      strlen((char *)(buf2+10)) != 9 || !testpad(buf2+0) || !testpad(buf2+20))
    {
      printf("buffer overrun detection failed 1\n"); 
      status++;
    }
  snprintf((char *)(buf2+10), 10, "kukkuu%07x", 10);
  if (strcmp((char *)(buf2+10), "kukkuu000000A") == 0 || 
      strlen((char *)(buf2+10)) != 9 || !testpad(buf2+0) || !testpad(buf2+20))
    {
      printf("buffer overrun detection failed 2\n"); 
      status++;
    }
  snprintf((char *)(buf2+10), 10, "kukkuu%7x", 10);
  if (strcmp((char *)(buf2+10), "kukkuu      A") == 0 || 
      strlen((char *)(buf2+10)) != 9 || !testpad(buf2+0) || !testpad(buf2+20))
    {
      printf("buffer overrun detection failed 3\n"); 
      status++;
    }
  snprintf((char *)(buf2+10), 10, "kukkuu%f", 3.141592);
  if (strcmp((char *)(buf2+10), "kukkuu3.141592") == 0 || 
      strlen((char *)(buf2+10)) != 9 || !testpad(buf2+0) || !testpad(buf2+20))
    {
      printf("buffer overrun detection failed 4\n"); 
      status++;
    }
  snprintf((char *)(buf2+10), 10, "kukkuu%g", 3.141592);
  if (strcmp((char *)(buf2+10), "kukkuu3.141592") == 0 || 
      strlen((char *)(buf2+10)) != 9 || !testpad(buf2+0) || !testpad(buf2+20))
    {
      printf("buffer overrun detection failed 5\n"); 
      status++;
    }
  snprintf((char *)(buf2+10), 10, "kukkuu%-7f", 3.141592);
  if (strcmp((char *)(buf2+10), "kukkuu3.141592") == 0 || 
      strlen((char *)(buf2+10)) != 9 || !testpad(buf2+0) || !testpad(buf2+20))
    {
      printf("buffer overrun detection failed 6\n"); 
      status++;
    }
  snprintf((char *)(buf2+10), 10, "kukkuu%-+7f", 3.141592);
  if (strcmp((char *)(buf2+10), "kukkuu+3.141592") == 0 || 
      strlen((char *)(buf2+10)) != 9 || !testpad(buf2+0) || !testpad(buf2+20))
    {
      printf("buffer overrun detection failed 7\n"); 
      status++;
    }
  snprintf((char *)(buf2+10), 10, "kuk%-+7f", -3.141592);
  if (strcmp((char *)(buf2+10), "kuk-3.141592") == 0 || 
      strlen((char *)(buf2+10)) != 9 || !testpad(buf2+0) || !testpad(buf2+20))
    {
      printf("buffer overrun detection failed 8\n"); 
      status++;
    }
  return status;
}



