/*

  ssheprintf.h

  Author: Antti Huima <huima@ssh.fi>

  Copyright (c) 1999-2000 SSH Communications Security, Finland
  All rights reserved.

  Created Wed Oct 13 15:11:40 1999.

  */

#ifndef SSH_EPRINTF_INCLUDED
#define SSH_EPRINTF_INCLUDED

#include "sshincludes.h"

/* Type of functions that implement formatting `external' data types.
   `buf' is the buf where something should be written, `buf_size' the
   maximum number of characters that can be written. `precision' is
   either -1 or a non-negative number supplied by the user; its
   interpretation is chosen by the rendering function. `datum' is the
   actual value to render.

   The functions must return the number of characters written.

   If the renderer would have liked to write more characters than
   there was room in `buf_size', the renderer should return the value
   `buf_size' + 1 (but have written only `buf_size' characters, of
   course).

   As a relaxation, the functions ARE allowed to write the NUL byte at
   buf[buf_size], i.e. at the `buf_size'+1th character. However, this
   is not necessary and doing or doing not has no effect whatsoever.  */

typedef int (* SshEPrintfRenderer)(char *buf, int buf_size, int precision,
                                   void *datum);

/* This is like snprintf, but accepts the %@ construct. */
int ssh_esnprintf(char *str, size_t size, const char *fmt, ...);

/* This is like vsnprintf, but accepts the %@ construct. */
int ssh_evsnprintf(char *str, size_t size, const char *fmt, va_list args);

#endif /* SSH_EPRINTF_INCLUDED */
