/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_crypt.C	1.20 96/01/16"

#include <sys/types.h>
#include <netinet/in.h>
#include <memory.h>
#include <stdio.h>
#include "Bigint.h"
#include "Bstream.h"
#include "SkipCert.h"

#include "my_types.h"
#include "skip_types.h"
#include "skip_proto.h"
#include "skip_conf.h"
#include "skip_keymgr.h"
#include "skip_log.h"
#include "skip_crypt.h"
#include "skip_enc_alg.h"
#include "malloc.h"

#define MAX_CRYPTORS    255

// Not a great solution, but fast...
// [two versions] by [kij and kp algs] by [alg numbers]
skip_cryptor_t *cryptors[2][2][MAX_CRYPTORS];

int random_encryptor;

void
skip_init_internal_cryptors(int keyfd)
{
	int i;
	for (i = 0; i < MAX_CRYPTORS; i++){
		cryptors[0][KIJALG][i]=NULL;
		cryptors[1][KIJALG][i]=NULL;
		cryptors[0][KPALG][i]=NULL;
		cryptors[1][KPALG][i]=NULL;
	}

#ifdef HAVE_SIMPLECRYPT
	cryptors[0][KIJALG][simplecrypt_module_v1.kij_algno]=&simplecrypt_module_v1;
	cryptors[0][KPALG][simplecrypt_module_v1.kp_algno]=&simplecrypt_module_v1;
	cryptors[1][KIJALG][simplecrypt_module.kij_algno]=&simplecrypt_module;
	cryptors[1][KPALG][simplecrypt_module.kp_algno]=&simplecrypt_module;
	random_encryptor=simplecrypt_module_v1.kij_algno;

	set_kij_alg(keyfd, SKIP_V1, simplecrypt_module_v1.kij_algno);
	set_kij_alg(keyfd, SKIP_V2, simplecrypt_module.kij_algno);
#endif
#ifdef HAVE_DES_CBC
	cryptors[0][KIJALG][des_cbc_nopad_module_v1.kij_algno]=&des_cbc_nopad_module_v1;
	cryptors[0][KPALG][des_cbc_module_v1.kp_algno]=&des_cbc_module_v1;

	cryptors[1][KIJALG][des_cbc_nopad_module.kij_algno]=&des_cbc_nopad_module;
	cryptors[1][KPALG][des_cbc_nopad_module.kp_algno]=&des_cbc_module;
	random_encryptor=des_cbc_nopad_module_v1.kij_algno;

	set_kij_alg(keyfd, SKIP_V1, des_cbc_nopad_module_v1.kij_algno);
	set_kij_alg(keyfd, SKIP_V2, des_cbc_nopad_module.kij_algno);
#endif

#ifdef HAVE_DES_EDE_K2
        cryptors[0][KIJALG][des_ede_k2_nopad_module_v1.kij_algno]=
				&des_ede_k2_nopad_module_v1;
        cryptors[0][KPALG][des_ede_k2_module_v1.kp_algno]=
				&des_ede_k2_module_v1;
	set_kij_alg(keyfd, SKIP_V1, des_ede_k2_nopad_module_v1.kij_algno);

	/* No 2 key DES3 transform for ESP mode */

#endif

#ifdef HAVE_DES_EDE_K3
        cryptors[0][KIJALG][des_ede_k3_nopad_module_v1.kij_algno]=
				&des_ede_k2_nopad_module_v1;
        cryptors[0][KPALG][des_ede_k3_module_v1.kp_algno]=
				&des_ede_k3_module_v1;

        cryptors[1][KIJALG][des_ede_k3_nopad_module.kij_algno]=
				&des_ede_k3_nopad_module;
        cryptors[1][KPALG][des_ede_k3_module.kp_algno]=
				&des_ede_k3_module;

	set_kij_alg(keyfd, SKIP_V1, des_ede_k3_nopad_module_v1.kij_algno);
	set_kij_alg(keyfd, SKIP_V2, des_ede_k3_nopad_module.kij_algno);

#endif

#ifdef HAVE_RC2_CBC
        cryptors[0][KIJALG][rc2_cbc_nopad_module_v1.kij_algno]=&des_rc2_k2_nopad_module_v1;
        cryptors[0][KPALG][rc2_cbc_module_v1.kp_algno]=&des_rc2_k2_module_v1;
        cryptors[1][KIJALG][rc2_cbc_nopad_module.kij_algno]=&des_rc2_k2_nopad_module;
        cryptors[1][KPALG][rc2_cbc_module.kp_algno]=&des_rc2_k2_module;
	set_kij_alg(keyfd, SKIP_V1, rc2_cbc_nopad_module_v1.kij_algno);
	set_kij_alg(keyfd, SKIP_V2, rc2_cbc_nopad_modulue_module.kij_algno);

#endif
#ifdef HAVE_RC4
        cryptors[0][KPALG][rc4_module_v1.kp_algno]=&rc4_module_v1;
	cryptors[1][KPALG][rc4_module.kp_algno]=&rc4_module;
#endif
}

int
cryptor_get_Ekeylen(int ver, int algtype, ENC_ALG_TYPE alg)
{
	if (alg > MAX_CRYPTORS || cryptors[ver-1][alg] == NULL) {
		skip_log(SKIP_ERROR,"Unknown keysize for algorithm %d\n",alg);
		return 0;
	}
	return cryptors[ver-1][algtype][alg]==NULL? 0 : 
			cryptors[ver-1][algtype][alg]->ekp_len;
}

int
cryptor_get_ivlen(int ver, int algtype, ENC_ALG_TYPE alg)
{
	if (alg > MAX_CRYPTORS || cryptors[ver-1][alg] == NULL) {
		skip_log(SKIP_ERROR,"Unknown iv size for algorithm %d\n",alg);
		return 0;
	}
	return cryptors[ver-1][algtype][alg]==NULL? 0 : 
			cryptors[ver-1][algtype][alg]->mid_len;
}

int
cryptor_get_keylen(int ver, int algtype, ENC_ALG_TYPE alg)
{
	if (alg > MAX_CRYPTORS || cryptors[ver-1][alg] == NULL) {
		skip_log(SKIP_ERROR,"Unknown keysize for algorithm %d\n",alg);
		return 0;
	}
	return cryptors[ver-1][algtype][alg]==NULL? 0 : 
			cryptors[ver-1][algtype][alg]->kp_len;
}

int cryptor_get_flags(int ver, int algtype, ENC_ALG_TYPE alg)
{
	if (alg > MAX_CRYPTORS || cryptors[ver-1][alg] == NULL) {
		skip_log(SKIP_ERROR,"Unknown iv size for algorithm %d\n",alg);
		return 0;
	}
	return cryptors[ver-1][algtype][alg]==NULL? 0 : 
			cryptors[ver-1][algtype][alg]->flags;
}

Bstream skip_encrypt(int ver, int algtype, ENC_ALG_TYPE alg, 
			const Bstream& key, const Bstream& input)
{
	Bstream result;
	u_char *p;
	void *cs;
	u_char iv[8];
	unsigned x;
	skip_cryptor_t *t;
	Bstream nullstr;
	unsigned char payload_type; /* XXX - value = ? */

	bzero(iv,8);

	if (alg > MAX_CRYPTORS)
		return nullstr;


	t=cryptors[ver-1][algtype][alg];

	if (t == NULL) {
		return nullstr;
	}

	if (t->flags & SKIP_KEYED_STREAM_CIPHER) {
		skip_log(SKIP_ERROR,"Error: Attempt to use Stream cipher for Kij Alg");
		return nullstr;
	}

	x=input.getlength();
	p=(u_char *)malloc(x);

	cs=(t->open)((char *)key.getdatap(), key.getlength(), (char *)iv, 8);
	/* XXX */
	(t->encrypt)(cs, (char *)input.getdatap(), &x, (char *)p, 
					(char *)iv, 8, &payload_type);
	(t->close)(cs);

	result=Bstream(x,(byte *)p);
	free((char *)p);

	if (result.getlength() == 0)
		skip_log(SKIP_ERROR,"Unable to Encrypt input");
	return result;
}

Bstream skip_decrypt(int ver, int algtype, ENC_ALG_TYPE alg, 
			const Bstream& key, const Bstream& input)
{
	u_char *p;
	void *cs;
	u_char iv[8];
	unsigned int x;
	Bstream result;
	Bstream nullstr;
	skip_cryptor_t *t;
	unsigned char payload_type; /* XXX - value = ? */

	if (alg > MAX_CRYPTORS)
		return nullstr;

	t=cryptors[ver-1][algtype][alg];

	if (t == NULL)
		return nullstr;

	if (t->flags & SKIP_STREAM_CIPHER) {
		skip_log(SKIP_ERROR,"Error: Attempt to use Stream cipher for Kij Alg");
		return nullstr;
	}

	bzero(iv,8);
	x=input.getlength();
	p=(u_char *)malloc(x);

	cs=(t->open)((char *)key.getdatap(), key.getlength(), (char *)iv, 8);
	/* XXX payload_type ? */
	(t->decrypt)(cs, (char *)input.getdatap(), &x, (char *)p,
					(char *)iv, 8, &payload_type);
	(t->close)(cs);
	
	result=Bstream(x, (byte *)p);
	free((char *)p);
#ifdef DEBUG
	printf("decrypting from:");
	input.print();
	printf("decrypted result:");
	final.print();
	printf("\n");
#endif
	if (result.getlength() == 0)
		skip_log(SKIP_ERROR,"Unable to dencrypt input");
	return result;
}

// Encrypt the random kp with "key".  Uses DES if present, otherwise
// simplecrypt.
Bstream
skip_random_encrypt(Bstream key, Bstream randstr) 
{
        int crypt_id;
        return skip_encrypt(1, KIJALG, random_encryptor, key, randstr);
}
