/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_add_cert.C	1.15 95/11/21"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include "Time.h"
#include "Bigint.h"
#include "Bstream.h"
#include "ObjId.h"
#include "Name.h"
#include "SkipCert.h"
#include "X509Cert.h"
#include "X509skip.h"
#include "HashCert.h"
#include "malloc.h"
#include "utils.h"
#include "Sig.h"

#include "my_types.h"
#include <ndbm.h>
#include "skip_certbase.h"
#include "skip_conf.h"
#include "skip_keymgr.h"

char *cert_error(enum VerifyResult result);

void
usage()
{
	fprintf(stderr, "skip_add_cert -n NSID -t certtype <cert_file>\n");
	exit(1);
}

Bstream cert_name(u_char certtype, Bstream certstr)
{
	switch(certtype) {
		case SKIP_CERT_X509: {
			X509SkipCert cert;
			cert.decode(certstr);
			return cert.skip_name();
		}
		case SKIP_DH_PUBLIC: {
			HashCert cert;
			cert.decode(certstr);
			return cert.skip_name();
		}
		default: {
			Bstream nullstr;
			return nullstr;
		}
	}
}

int
main(int argc, char **argv)
{
	int i,  c; 
	Bstream certstr;
	Bstream castr, nullstr;
	u_char nsid;
	u_char certtype;
	int count=0;
	extern int optind;
	extern char *optarg;

	nsid = certtype = 0;

	while ((c=getopt(argc,argv,"n:t:"))!= -1) {
		 switch (c) {
			case 'n':
				nsid = atoi(optarg);
				break;
			case 't':
				certtype = atoi(optarg);
				if (certtype ==0) 
					certtype=Certname_to_num(optarg);
				break;
			default:
				usage();
		}
	}
	if (optind >= argc) 
		usage();

	if (nsid == 0 || certtype == 0)
		usage();

	certstr=File_to_Bstr(argv[optind]);
	
	if (certstr.getlength()==0 )
		usage();
		
	if (skip_add_cert(certstr, nsid, certtype)) {
		printf(" certificate decode failure: %s\n", argv[optind]);
	} else { 
		String temp;
		Bstream tmpstr;
		tmpstr=cert_name(certtype, certstr);
		temp = tmpstr.gethexstr();
		printf("added %s to database\n", (const char *) temp);
	}
}
