/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_sysv.h	1.2 95/11/15 Sun Microsystems"

#ifdef  __cplusplus
extern "C" {
#endif

/*
 * Solaris 2.x system includes
 */
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/debug.h>
#include <sys/time.h>
#include <sys/user.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/systm.h>
#include <sys/strlog.h>
#include <sys/stropts.h>
#include <sys/cpu.h>
#include <sys/kmem.h>
#include <sys/mutex.h>
#include <sys/conf.h>
#include <sys/dlpi.h>
#include <net/if.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/ip_icmp.h>
#include <netinet/if_ether.h>


#ifdef _KERNEL
#include <sys/ddi.h>
#include <sys/sunddi.h>
#include <sys/cmn_err.h>
#include <sys/modctl.h>
#include <sys/ksynch.h>

#define	PANIC(s)		cmn_err(CE_PANIC, s)
/*
 * 5.x memory management macros
 */
#include <sys/kmem.h>
#define	MEM_ALLOC(m)		kmem_zalloc(m, KM_NOSLEEP)
#define	MEM_FREE(m, n)		kmem_free(m, n)
#define	BCOPY(s, d, n)		bcopy(s, d, n)
#define	BZERO(s,n)    		bzero(s,n)
#define	STATIC			static

/*
 * 5.x lock management macros
 */
#include <sys/ksynch.h>
#define	MUTEX_T			kmutex_t
#define	MUTEX_INIT(m, n)	mutex_init(m, n, MUTEX_DRIVER, NULL);
#define	MUTEX_DESTROY(m)	mutex_destroy(m);
#define	MUTEX_ENTER(m)		mutex_enter(m);
#define	MUTEX_EXIT(m)		mutex_exit(m);

/*
 * 5.x buffer management macros
 */
#define	SKIP_BUF_T		mblk_t
#define	BUFSTART(mp)		(mp)->b_rptr
#define	BUFEND(mp)		(mp)->b_wptr
#define	BUFLEN(mp)		(BUFEND(mp) - BUFSTART(mp))
#define	BUFGROW(mp, n)		(mp->b_wptr += n)
#define	BUFFREE(mp)		freemsg(mp)
#define ALIGNED(x)		(((unsigned int)(x)&(skip_alignment - 1)) == 0)

/*
 * Notifier interface
 */
#define	SKIP_NOTIFYQ_T		queue_t *
#define	SKIP_SET_NOTIFIER(n, q)	(n = RD(q))

/*
 * 5.x logging defines
 */
#define skip_log(s)		cmn_err(CE_WARN, s)
#define skip_log1(s, t)		cmn_err(CE_WARN, s, t)
#define skip_log2(s, t, q)	cmn_err(CE_WARN, s, t, q)


/*
 * 5.x debugging defines
 */
#define	SKIP_DEBUG(s)		if (skip_key_debug) cmn_err(CE_CONT, s)
#define	SKIP_DEBUG1(s, t)	if (skip_key_debug) cmn_err(CE_CONT, s, t)
#define	SKIP_DEBUG2(s, t, q)	if (skip_key_debug) cmn_err(CE_CONT, s, t, q)

/*
 * useful defines
 */
#define MBLKL(mp)		((mp)->b_wptr - (mp)->b_rptr)
#define MTYPE(mp)		(mp->b_datap->db_type)

#endif

#ifdef  __cplusplus
}
#endif
