/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_es.h	1.7 95/11/18 Sun Microsystems"

#ifdef  __cplusplus
extern "C" {
#endif


#define SKIP_ES_HASH_TABLESZ	(256)

/*
 * supported network interfaces
 */
#define SKIP_ETHER_HDRSZ	(14)
#define SKIP_FDDI_HDRSZ		(24)

/*
 * host access control information is held in a per-interface hash table
 */
typedef struct skip_es_hash_t {
	struct skip_es_hash_t	*next;	/* hash collision entries */
	struct skip_es_hash_t	*prev;	/* hash collision entries */
	skip_param_t		params;
} skip_es_hash_t;

/*
 * structure for kvm-like access
 */
#define SKIP_FMT_STD	0
#define SKIP_FMT_NET	1

typedef struct skip_sym {
	int	*p_value;
	int	v_fmt;
	char	*p_name;
} skip_sym_t;

/*
 * SKIP IP header size
 */
#define	IP_HDR_SZ	(20)

#define	SKIP_IPSP_HDR_SZ	(68) /* worst-case SKIP header size */
#define SKIP_IPSP_AH_SZ		(24) /* with 128 bits MD5 */
#define	SKIP_IPSP_ESP_SZ	(22) /* includes 8 bytes iv + 10 byte pad */

#define	SKIP_HDR_SZ	(IP_HDR_SZ + \
			SKIP_IPSP_HDR_SZ + \
			SKIP_IPSP_ESP_SZ )

#define	IP_MAX_HDR	64
#define IP_MIN_PAYLOAD	8
#define	SKIP_MIN_MTU	(IP_MAX_HDR + SKIP_HDR_SZ + IP_MIN_PAYLOAD)

#define	IP_OFFSET	(0x1fff)
#define	INADDRSZ	(4)
#define	SAME_ADDR(a, b)	!bcmp((caddr_t) (a), (caddr_t) (b), INADDRSZ)

/*
 * XXX
 */
#ifndef B_TRUE
#define B_TRUE		1
#define B_FALSE		0
#endif

/*
 * default size of buffer to allocate for encrypted packets (updated by mac)
 */
#define	ENCRYPTBUFSZ	2048

/*
 * function prototypes - exported functions
 */
boolean_t	skip_es_bypass(struct ip *, int);
#ifdef notdef
boolean_t	skip_es_ok(skip_es_t *,  struct in_addr *,
			struct ip *, int, skip_param_t *);
#endif

#ifdef  __cplusplus
}
#endif
