// Key.cpp
// David Aylesworth

#include "stdafx.h"
extern "C"
{
#include "OPIE/opie_cfg.h"
#include "OPIE/opie.h"
}
#include "Key.h"


BOOL KeyParseChallenge(CString challenge, int &algorithm, int &sequence, CString &seed)
{
    char *s = challenge.GetBuffer(0);
    if (s == NULL || *s == '\0')
        return FALSE;

    // parse algorithm      
    char *t = strtok(s, " ");
    if (t == NULL) {
        challenge.ReleaseBuffer();
        return FALSE;
    }
    if (!stricmp(t, "otp-md4") || !stricmp(t, "md4")) {
        algorithm = 4;
        t = strtok(NULL, " ");
    }
    else if (!stricmp(t, "otp-md5") || !stricmp(t, "md5")) {
        algorithm = 5;
        t = strtok(NULL, " ");
    }
    else
        algorithm = -1;

    // parse sequence number
    if (t == NULL) {
        challenge.ReleaseBuffer();
        return FALSE;
    }
    sequence = atoi(t);
    if (sequence < 1) {
        challenge.ReleaseBuffer();
        return FALSE;
    }
   
    // parse seed
    t = strtok(NULL, " ");
    if (t == NULL) {
        challenge.ReleaseBuffer();
        return FALSE;
    }
    seed = t;   

    challenge.ReleaseBuffer();   
    return TRUE;
}


BOOL KeyGenerateResponse(int algorithm, int keynum, CString &seed, CString &password, CString &response)
{
    /* Crunch seed and secret password into starting key normally */
    char key[8];   
    if (opiekeycrunch((unsigned)algorithm, key, (char *)(const char *)seed,
                      (char *)(const char *)password) != 0)
        return FALSE;

    while (keynum-- != 0)
        opiehash(key, algorithm);

    char buf[33];
    response = opiebtoe(buf, key);

    return TRUE;
}
