/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/user/RCS/refreshta.c,v $
 *
 *
 *  MODULE NAME:    refreshta.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/param.h>
#include "BigNum.h"
#include "BigRSA.h"
#include "cdc.h"
#include "cdc_db.h"
#include "random.h"
#include "spxapi_defs.h"

extern int optind, opterr;
extern char *optarg;

char   *progname, *rindex();

main(argc, argv)
    char   *argv[];
{
  register char *cp;
  int     c, errflg = 0, cflag=0;
  char    servername[ANAME_SZ], ca[ANAME_SZ], fullname[FULLNAME_SZ];
  VerifierCred  cred;
  char    str_notBefore[40], str_notAfter[40], *env;
  int     vflag = 0, status;
  TrustedCred        ta_cred_old;

  progname = (cp = rindex(*argv, '/')) ? cp + 1 : *argv;

  bzero(ca, sizeof(ca));
  bzero(servername, sizeof(servername));
  opterr = 0;
  while ((c=getopt(argc, argv, "vc:")) != EOF)
    switch(c) {
    case 'v' :
      vflag++;
      break;
    case 'c' :
      cflag++;
      strcpy(ca, optarg);
      break;
    case '?' :
      errflg++;
    }

  if (argv[optind] != NULL) strcpy(servername, argv[optind++]);
  if (optind != argc) errflg++;
  if (errflg) {
    printf("Usage: %s [-v] [servername]\n", progname);
    printf("\t-v      verbose mode\n");
    printf("\t-c      alternate CA RDN (default is 'OU=Servers')\n");
    exit(1);
  }

  if (!cflag) {
    if ((env = (char *) getenv("SPHINX_LOCAL_CA")) != NULL) strcpy(ca, env);
    else { strcpy(ca, "OU=Servers"); }
  }
  if (ca[2] != '=') {
    printf("illegal CA name - '%s' (need attribute type)\n", ca);
    printf("using default CA RDN - 'OU=Servers'\n");
    strcpy(ca, "OU=Servers");
  }

  if (strlen(servername)) {
    if (vflag)
      printf("Refresh server TA list for '%s'\n", servername);
  } else {
    printf("Refresh server TA list\n");
    printf("server's name : ");
    gets(servername);
    if (!*servername)
      exit(0);
  }

  /*  read claimant credentials from issuer's file  */

  if (vf_init(ver_string(servername, NULL), R_TKT_FIL) != ASUCCESS) {
    printf("verifier credential file doesn't exist\n");
    exit(-1);
  }

  vf_get_cred(servername, &cred, &ta_cred_old);

  if (vflag)
    printf("Verifier credentials are\n\t'%s/%s/CN=%s'\n", get_domain_name(NULL), ca, servername);
  vf_close();
  status = refresh_vfile(servername, ca, &cred);

}
