/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/server/RCS/cdb_load.c,v $
 *
 *
 *  MODULE NAME:    cdb_load.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <string.h>
#include "BigNum.h"
#include "BigRSA.h"
#include "cdc.h"
#include "cdc_db.h"

extern int optind, opterr;
extern char *optarg;

int     cdc_debug = 0;
char   *progname, *rindex();

main(argc, argv)
    char   *argv[];
{
  char    *cp;
  int  c, errflg = 0, more, i, len, type, j;
  char *database = NULL, *dump_file = NULL;
  char key[MAX_CDB_KEY_SZ];
  unsigned char contents[PRIVATE_KEY_SIZE];
  FILE *f;
  
  progname = (cp = rindex(*argv, '/')) ? cp + 1 : *argv;

  opterr = 0;
  while ((c=getopt(argc, argv, "f:d:")) != EOF)
    switch(c) {
      case 'd' :
	database = optarg;
	break;
      case 'f' :
	dump_file = optarg;
	break;
      case '?' :
	errflg++;
      }

  if (dump_file == NULL) errflg++;
  if (getuid() != 0)  {  printf("permission denied\n");  errflg++;  }

  if (errflg) {
    printf("Usage: %s [-d database_name] -f file_name\n", progname);
    printf("\t-d   database_name (default is %s)\n", DBM_FILE);
    printf("\t-f   input file used to load new database\n");
    exit(1);
  }

  if (database == NULL)
    database = DBM_FILE;

  if (cdc_db_set_name(database) == 0) {
    printf("%s couldn't create database '%s': it may already exist\n",argv[0], database);
    exit(1);
  }

  cdc_db_create(database);

  if ((f = fopen(dump_file, "r")) == NULL) {
    printf("unable to read '%s' file to load database\n", dump_file);
    exit(1);
  }
  bzero(contents, sizeof(contents));
  bzero(key, sizeof(key));
  while ((c=getc(f)) != EOF) {
    if (c != '{') while ((c=getc(f)) != '{');
    len = 0;
    while ((c=getc(f)) != '}')
      key[len++] = c;
    key[len] = '\0';

    if ((c=getc(f)) != ' ')
      printf("next char read is %d or '%c'\n", c, c);
    len = 0;
    while (fscanf(f, "%02x", &j)==1)  contents[len++] = (unsigned char) j;
    cdb_load_entry(key, contents, len);
/***
    printf("%s ", key);
    for (i=0; i<len; i++) {
      j = contents[i];
      printf("%02x", j);
    }
    printf("\n");
***/
    bzero(contents, sizeof(contents));
    bzero(key, sizeof(key));
  }
}
