/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/server/RCS/cdb_edit.c,v $
 *
 *
 *  MODULE NAME:    cdb_edit.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <pwd.h>
#include <string.h>
#include "BigNum.h"
#include "BigRSA.h"
#include "random.h"
#include "cdc.h"
#include "cdc_db.h"

int cdc_debug = 0;
char   *progname, *rindex();

int priv_user_ok = 0;
char cdc_domain[FULLNAME_SZ];

main(argc, argv)
    char   *argv[];
{
    char    *cp;
    char *database;
    char p_name[ANAME_SZ], ca_name[ANAME_SZ], domain_localname[2*ANAME_SZ];
    int  i, type, more, contentsize, certiflen, keylen;
    int  admin_rights;
    char  flag;
    static char answ[10];
    unsigned char enc_privkey[PRIVATE_KEY_SIZE];
    char ta_certif[CERTIF_SZ], p_certif[CERTIF_SZ];
    char admin[FULLNAME_SZ];
    struct passwd   *pwd;

    progname = (cp = rindex(*argv, '/')) ? cp + 1 : *argv;

    if (argc > 2) {
	fprintf(stderr, "Usage: %s [database-name]\n", argv[0]);
	exit(1);
    }
    if (argc == 2) {
	database = argv[1];
	--argc;
    } else
	database = DBM_FILE;

    strcpy(cdc_domain, get_domain_name(NULL));

    if (cdc_db_set_name(database) != 0) {
      printf("cdc database '%s' doesn't exist\n", database);
      exit(-1);
    }

    print_commands();
    printf("Mortal : ");
    gets(answ);
    while ((answ[0] != 'q') && (answ[0] != 'Q')) {
      switch (answ[0]) {

          case 'm' :  /*  become mortal  */
	    priv_user_ok = 0;
	    break;

	  case 'a' :  /*  become an administrator  */
	    if (priv_user_ok < 1) {
	      fprintf(stdout,"admin's relative name : ");
	      fflush(stdout);
	      gets(admin);
	      if ((admin_rights = check_admin_rights(admin)) == 0)
		printf("no privileges to become an administrator\n");
	      if (admin_rights >= 1) {
		if ((priv_user_ok = get_permission(admin)) == 0) {
		  printf("illegal password\n");
		} else print_commands();
	      }
	      admin_rights = 0;
	    }
	    break;

	  case '1' :   /*  modify password  */
	    fprintf(stdout,"principal's relative name : ");
	    fflush(stdout);
	    gets(domain_localname);
	    modify_password(domain_localname);
	    break;

          case '2' :  /*  list principal contents  */
	    fprintf(stdout,"principal's relative name : ");
	    fflush(stdout);
	    gets(domain_localname);

	    contentsize = 0;
            more = 0;
	    cdb_read_entry(domain_localname, ENC_PRIVKEY_ATTRIB, enc_privkey, &contentsize, &more);
	    if (contentsize > 0) {
	      printf("\t enc_privkey is ");
	      for (i=0; i< contentsize; i++)  printf("%02x",(unsigned char) enc_privkey[i]);
	      printf("\n");
	    }
	    more = 0;
	    contentsize = 0;
            cdb_read_entry(domain_localname, FLAG_ATTRIB, &flag, &contentsize, &more);
	    if (contentsize > 0) printf("\t flag is %c\n",flag);

	    more = 0;
	    bzero(ta_certif, sizeof(ta_certif));
	    type = TA_CERTIF_ATTRIB;
	    contentsize = 0;
	    cdb_read_entry(domain_localname, type, ta_certif, &contentsize, &more);
	    if (contentsize > 0) {
	      printf("\t TA certif is ");
	      for (i=0; i<contentsize; i++)  printf("%02x",(unsigned char) ta_certif[i]);
	      printf("\n");
	    }
	    while (more != 0) {
	      bzero(ta_certif, sizeof(ta_certif));
	      contentsize = 0;
	      cdb_read_entry(domain_localname, type, ta_certif, &contentsize, &more);
	      if (contentsize > 0) {
		printf("\t TA certif is ");
		for (i=0; i<contentsize; i++)  printf("%02x",(unsigned char) ta_certif[i]);
		printf("\n");
	      }
	    }

	    more = 0;
	    bzero(p_certif, sizeof(p_certif));
	    type = CERTIF_ATTRIB;
	    contentsize = 0;
	    cdb_read_entry(domain_localname, type, p_certif, &contentsize, &more);
	    if (contentsize > 0) {
	      printf("\t    certif is ");
	      for (i=0; i<contentsize; i++)  printf("%02x",(unsigned char) p_certif[i]);
	      printf("\n");
	    }
	    while (more != 0) {
	      bzero(p_certif, sizeof(p_certif));
	      contentsize = 0;
	      cdb_read_entry(domain_localname, type, p_certif, &contentsize, &more);
	      if (contentsize > 0) {
		printf("\t    certif is ");
		for (i=0; i<contentsize; i++)  printf("%02x",(unsigned char) p_certif[i]);
		printf("\n");
	      }
	    }
	    break;

          case '3' :  /*  add principal  */
	    if (priv_user_ok >= 1) {
	      fprintf(stdout,"principal's file name prefix [ ??_privkey ] : ");
	      fflush(stdout);
	      gets(p_name);
	      fprintf(stdout,"CA's file name prefix : ");
	      fflush(stdout);
	      gets(ca_name);
	      fprintf(stdout, "will read ...\n");
	      fprintf(stdout, "   %s_privkey, %s_certif_%s, %s_certif_%s\n", p_name, p_name, ca_name, ca_name, p_name);
	      if (add_princ(p_name, ca_name, FALSE) < 0)
		printf("  ERROR: unable to add principal to database\n");
	    }
	    break;

          case '4' :  /*  add ca  */
	    if (priv_user_ok >= 1) {
	      fprintf(stdout,"CA's file name prefix : ");
	      fflush(stdout);
	      gets(p_name);
	      fprintf(stdout,"parent's file name prefix : ");
	      fflush(stdout);
	      gets(ca_name);
	      fprintf(stdout, "will read ...\n");
	      fprintf(stdout, "   %s_certif_%s, %s_certif_%s\n", p_name, ca_name, ca_name, p_name);
	      if (add_ca(p_name, ca_name) < 0)
		printf("  ERROR: unable to add CA to database\n");
	    }
	    break;

          case '5' :  /*  add enc_privkey  */
	    fprintf(stdout,"principal's relative name : ");
	    fflush(stdout);
	    gets(domain_localname);
	    if ((priv_user_ok >= 1) || get_permission(domain_localname)) {
	      char name_ava[40], uid[16], hashkey[16];
              int  uidlen;

	      fprintf(stdout,"principal's file name prefix [ ??_privkey ] : ");
	      fflush(stdout);
	      gets(p_name);
	      bzero(enc_privkey, sizeof(enc_privkey));
	      if (read_key(p_name, 0, name_ava, uid, &uidlen, hashkey, enc_privkey, &keylen) < 0) {
		printf("unable to read %s_privkey file\n", p_name);
	      } else {
		type = ENC_PRIVKEY_ATTRIB;
		printf("adding enc_privkey for %s\n", domain_localname);
		if (cdb_add_entry(domain_localname, type, enc_privkey, keylen) < 0)
		  printf("  ERROR: unable to add enc_privkey\n");
	      }
	      bzero(enc_privkey, sizeof(enc_privkey));
	    }
	    break;

          case '6' :  /*  add ta certif  */
	    fprintf(stdout,"principal's relative name : ");
	    fflush(stdout);
	    gets(domain_localname);
	    if ((priv_user_ok >= 1) || get_permission(domain_localname)) {
	      fprintf(stdout,"principal's file name prefix : ");
	      fflush(stdout);
	      gets(p_name);
	      fprintf(stdout,"CA's file name prefix : ");
	      fflush(stdout);
	      gets(ca_name);
	      bzero(ta_certif, sizeof(ta_certif));
	      if (read_certif(p_name, ca_name, ta_certif, &certiflen) < 0) {
		printf("unable to read %s_certif_%s file\n", p_name, ca_name);
	      } else {
		type = TA_CERTIF_ATTRIB;
		printf("adding ta_certif for %s\n", domain_localname);
		if (cdb_add_entry(domain_localname, type, ta_certif, certiflen) < 0)
		  printf("  ERROR: unable to add ta_certif\n");
	      }
	    }
	    break;

          case '7' :  /*  add p certif  */
	    fprintf(stdout,"principal's relative name : ");
	    fflush(stdout);
	    gets(domain_localname);
	    if ((priv_user_ok >= 1) || get_permission(domain_localname)) {
	      fprintf(stdout,"principal name for certif : ");
	      fflush(stdout);
	      gets(p_name);
	      fprintf(stdout,"principal's CA name for certif : ");
	      fflush(stdout);
	      gets(ca_name);
	      bzero(p_certif, sizeof(p_certif));
	      if (read_certif(ca_name, p_name, p_certif, &certiflen) < 0) {
		printf("unable to read %s_certif_%s file\n", ca_name, p_name);
	      } else {
		type = CERTIF_ATTRIB;
		printf("adding certif for %s\n", domain_localname);
		if (cdb_add_entry(domain_localname, type, p_certif, certiflen) < 0)
		  printf("  ERROR: unable to add certif\n");
	      }
	    }
	    break;

          case '8' :  /*  replace principal  */
	    if (priv_user_ok >= 1) {
	      fprintf(stdout,"principal's file name prefix [ ??_privkey ] : ");
	      fflush(stdout);
	      gets(p_name);
	      fprintf(stdout,"CA's file name prefix : ");
	      fflush(stdout);
	      gets(ca_name);
	      fprintf(stdout, "will read ...\n");
	      fprintf(stdout, "   %s_privkey, %s_certif_%s, %s_certif_%s\n", p_name, p_name, ca_name, ca_name, p_name);
	      if (replace_princ(p_name, ca_name, FALSE, 0) < 0)
		printf("  ERROR: unable to replace principal to database\n");
	    }
	    break;

	  case '9' :  /*  delete principal from CDC database  */
	    if (priv_user_ok >= 1) {
	      fprintf(stdout, "enter principal's relative name\n");
	      fprintf(stdout, "   (e.g.,     ou=users/cn=john user\n");
	      fprintf(stdout, "              ou=servers/cn=hostx )\n");
	      fprintf(stdout, " please enter name carefully              : ");
	      fflush(stdout);
	      gets(domain_localname);
	      cdb_delete_entry(domain_localname);
	    }
	    break;

          case 'h' :  /*  help  */
          case '?' :  /*  help  */
	    print_commands();
	    break;

          default :
	    break;
      }

      if (priv_user_ok == 1)  printf("Admin (%s) : ",admin);
      else if (priv_user_ok == 0) printf("Mortal : ");

      gets(answ);
    }
}

print_commands()
{
    printf("CDC utility program for '%s' domain\n", cdc_domain);
    printf("\tm - mortal\n");
    printf("\ta - administator\n");
    printf("\t1 - modify password\n");
    printf("\t2 - list principal contents\n");
    if (priv_user_ok) {
      printf("\t3 - add principal     (enc_privkey, ta certif, p certif)\n");
      printf("\t4 - add ca            (ta certif, p certif)\n");
      printf("\t5 - add enc_privkey\n");
      printf("\t6 - add ta certif\n");
      printf("\t7 - add p certif\n");
      printf("\t8 - replace principal (enc_privkey, ta certif p certif\n");
      printf("\t9 - delete principal from CDC database\n");
    }
    printf("\t? - help\n");
    printf("\tq - quit\n");
}


get_permission(name)
char *name;
{
  int contentsize, more;
  char enc_privkey[PRIVATE_KEY_SIZE];
  RSAKeyStorage keybuf;
  DESblock       key;

  contentsize = 0;
  more = 0;
  if (cdb_read_entry(name, ENC_PRIVKEY_ATTRIB, enc_privkey, &contentsize, &more) < 1)
    return(0);
  DES_read_password(&key, "password : ", 0);
  if (recover_private (&key, enc_privkey, contentsize, &keybuf)) {
    bzero(key.bytes, sizeof(key.bytes));
    bzero(&keybuf, sizeof(keybuf));
    return(1);
  }
  bzero(keybuf, sizeof(keybuf));
  return(0);
}


modify_password(name)
char *name;
{
  int contentsize, more, c_length, illegal_password = 1;
  char enc_privkey[PRIVATE_KEY_SIZE], prompt[80], *new_privkeybuf;
  RSAKeyStorage keybuf;
  DESblock       oldkey, newkey, v_key;

  contentsize = 0;
  more = 0;
  bzero(oldkey.bytes, sizeof(oldkey.bytes));
  if (cdb_read_entry(name, ENC_PRIVKEY_ATTRIB, enc_privkey, &contentsize, &more) < 1) {
    printf("  unable to read %s's enc_privkey from CDC\n", name);
    return(0);
  }
  DES_read_password(&oldkey, "old password : ", 0);
  if (recover_private (&oldkey, enc_privkey, contentsize, &keybuf))
    illegal_password = 0;

  sprintf(prompt, "new password : ", name);
  if (!DES_read_password(&newkey, prompt, 1)) {
    printf("Verification failed, password unchanged.\n");
    bzero(oldkey.bytes, sizeof(oldkey.bytes));
    bzero(newkey.bytes, sizeof(newkey.bytes));
    bzero(&keybuf, sizeof(RSAKeyStorage));
    return(0);
  }
  if (bcmp(oldkey.bytes, newkey.bytes, 8) == 0) {
    printf("password unchanged\n");
    bzero(oldkey.bytes, sizeof(oldkey.bytes));
    bzero(newkey.bytes, sizeof(newkey.bytes));
    bzero(&keybuf, sizeof(RSAKeyStorage));
    return(0);
  }
  if (illegal_password) {
    printf("illegal password\n");
    bzero(oldkey.bytes, sizeof(oldkey.bytes));
    bzero(newkey.bytes, sizeof(newkey.bytes));
    bzero(&keybuf, sizeof(RSAKeyStorage));
    return(0);
  } else {
    hide_private( &newkey, &new_privkeybuf, &c_length, &keybuf);
    bzero(oldkey.bytes, sizeof(oldkey.bytes));
    bzero(newkey.bytes, sizeof(newkey.bytes));
    bzero(&keybuf, sizeof(RSAKeyStorage));
    if (cdb_add_entry(name, ENC_PRIVKEY_ATTRIB, new_privkeybuf, c_length) < 0)
      printf("  ERROR: unable to modify enc_privkey\n");
    free(new_privkeybuf);
    return(1);
  }
}


check_admin_rights(name)
char *name;
{
  int contentsize, more;
  char  flag;

  more = 0;
  contentsize = 0;
  if (cdb_read_entry(name, FLAG_ATTRIB, &flag, &contentsize, &more) < 1)
    return(0);

  if (flag == '2')  return(1);
  if (flag == '4')  return(2);
  return(0);
}
