/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cfile/RCS/dest_claimant.c,v $
 *
 *
 *  MODULE NAME:    dest_claimant.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <errno.h>
#include <pwd.h>
#include "cdc.h"

/*
 * dest_claimant() is used to destroy the claimant credentials upon
 * logout.
 * If the claimant file does not exist, dest_tkt() returns RET_TKFIL.
 * Otherwise the function returns RET_OK on success, AFAILURE on
 * failure.
 *
 */

int dest_claimant(echo)
int echo;
{
    char *file;
    int i,fd, len;
    extern int errno;
    struct stat statb;
    char buf[BUFSIZ], prefix[80], filename[128];
    struct passwd  *pwd;
    DIR    *dirp;
    struct direct *dp;

    pwd = getpwuid(getuid());
    file = (char *) spx_tkt_string(pwd->pw_name, NULL);

    errno = 0;
    if (lstat(file,&statb) < 0) {
      if (echo)
	printf("SPX claimant credentials don't exist for %s\n", pwd->pw_name);
      goto out;
    }
    if (!(statb.st_mode & S_IFREG)
#ifdef notdef
	|| statb.st_mode & 077
#endif
	)
	goto out;
    if ((fd = open(file, O_RDWR, 0)) < 0)
	goto out;

    bzero(buf, BUFSIZ);
    for (i = 0; i < statb.st_size; i += BUFSIZ)
	if (write(fd, buf, BUFSIZ) != BUFSIZ) {
	    (void) fsync(fd);
	    (void) close(fd);
	    goto out;
	}

    (void) fsync(fd);
    (void) close(fd);
    (void) unlink(file);

    strcpy(prefix, &file[5]);
    strcat(prefix, "_ctx_");
    len = strlen(prefix);
    dirp = opendir("/tmp");
    for (dp = readdir(dirp); dp != NULL; dp = readdir(dirp)) {
      if (!strncmp(dp->d_name, prefix, len)) {
	strcpy(filename,"/tmp/");
	strcat(filename, dp->d_name);
	unlink(filename);
      }
    }
    if (echo)
      printf("SPX claimant credentials destroyed for %s\n", pwd->pw_name);
    closedir(dirp);

out:
    if (errno == ENOENT) return AFAILURE;
    else if (errno != 0) return AFAILURE;
    return(ASUCCESS);
}
