/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/parse_certif.c,v $
 *
 *
 *  MODULE NAME:    parse_certif.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *      J. Tardo
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include "SPHINX-types.h"
#include "BigZ.h"
#include "BigRSA.h"
#include "cdc.h"
#include "objid.h"

#define BIGBUFFER_SIZE  1000
#define KEY_LINE 64

/*  
 * Define for more verbose debugging.
#define DEBUG2
*/

/*  
 * Define for "old style" name printout
#define DUMPRDN
*/

extern int ps_len_strategy;
struct type_SPHINX_Certificate *decode_certif_aux();
int encode_SPHINX_CertifInfo();

/*
 * parse_certif         Reads and displays a certificate.  Will
 *                      also attempt to verify by reading issuer
 *                      public key from calling directory if indicated.
 */

int parse_certif(issuer, subject, verify, digest, getkey)
char *issuer;
char *subject;
int verify, digest, getkey;
{
  time_t now;
  FILE   *f;

  struct type_SPHINX_Certificate *internalcertif;

  static char asn1_certif[BIGBUFFER_SIZE], issuer_name[FULLNAME_SZ];
  char issu_uid[UID_SZ], subj_uid[UID_SZ];
  char  *ca_sig;
  int i, j, c, l=MAX_NAME_BUF-strlen(subject)-5;
  int  asn1_certif_len, issu_uidlen, subj_uidlen, ca_sig_size ;

  RSAKeyStorage subject_Key;
  BigNumDigit   tn[2*DigitLim];
  
  if (read_certif(issuer, subject, asn1_certif, &asn1_certif_len) < 0) {
    printf("\n%s: Failure reading certificate.\n",__FILE__);
    return(0);
  }
#ifdef DEBUG2
  printf("certif is \n");
  hexdump (asn1_certif, asn1_certif_len);
  printf("\n");
#endif

  if((internalcertif=decode_certif_aux(asn1_certif, asn1_certif_len)) == NULL) {
    printf("\n%s: Decode certificate error\n",__FILE__);
    return(0);
  }

  time(&now);
  printf("\nDisplay certificate contents on %s", ctime(&now));
  printf("Version:        ");
  if (internalcertif->cinfo->version == NULL)
    printf("v1988 (DEFAULT)\n");
    else {
      int i = internalcertif->cinfo->version->parm;
      switch (i) {
        case 0: printf("v1988 (0)\n");
                break;
        case 1: printf("v1992 (1)\n");
                break;
        default: printf("unrecognized (%d)\n", i);
      }
    }
  printf("Serial Number:  %d\n", internalcertif->cinfo->serialNumber->parm);
  printf("Signature Algorithm: ");
  display_alg_id(internalcertif->cinfo->signature);
  printf("Issuer:  %s\n", rdn_to_str(internalcertif->cinfo->issuer));

#ifdef DUMPRDN
  print_rdn(internalcertif->cinfo->issuer);
  printf("\n");
#endif

  printf("Subject: %s\n", rdn_to_str(internalcertif->cinfo->subject));

#ifdef DUMPRDN
  print_rdn(internalcertif->cinfo->subject);
  printf("\n");
#endif
  validate_expired(internalcertif->cinfo->valid,1);

  printf("Subject Key Algorithm Identifier: ");
  display_alg_id(internalcertif->cinfo->subjectPublicKey->algorithm);

  if (key_from_certif(internalcertif->cinfo,&subject_Key)) {
     printf("Subject Public Key:");
     PrintPubKey(&subject_Key);
  }
  else {
        printf("\nError Extracting Subject Public Key.\n");
        return(0);
  }

  if(uid_from_certif(internalcertif->cinfo,issu_uid,&issu_uidlen,subj_uid,&subj_uidlen)) {
    printf("Issuer  UID:    ");
    hexdump(issu_uid, issu_uidlen);
    printf("Subject UID:    ");
    hexdump(subj_uid, subj_uidlen);
  }
  else {
        subj_uid [0] = 0;
        subj_uidlen = 1;
  }

  if(getkey) write_pubkey(&subject_Key, subject,
        last_rdn_to_str(internalcertif->cinfo->subject), subj_uid, subj_uidlen, 1);

  printf("Signature Algorithm Identifier: ");
  display_alg_id(internalcertif->algorithm);

  printf("Signature:");
  ca_sig = prim2str(internalcertif->signature, &ca_sig_size );
  memset(tn,0,sizeof(tn));
  memcpy(tn,ca_sig+1,ca_sig_size-1);
  free(ca_sig);
  PrintBigNum(tn,BnnNumDigits(tn,2*DigitLim),16);
  printf("\n");

  if(digest) dumpCertificateMD2(internalcertif);

  if (verify) {
      char nameBuf[50], uidBuf[50], domain[FULLNAME_SZ];
      int uid_len, i;
      static RSAKeyStorage vkey;

      if (strcmp(issuer, ".") == 0) {
	strcpy(domain, get_domain_name(NULL));
	i = strlen(domain);
	while (domain[--i] != '=');
	strcpy(issuer, &domain[++i]);
      }
      if (read_pubkey_verbose(issuer,nameBuf,uidBuf,&uid_len,&vkey) == 0) {
        printf("\nCouldn't read public key for %s\n", issuer);
        return(FALSE);
      }
       
      if((i=verify_certif_aux(internalcertif, &vkey))==1)
        printf("\nVerifies.\n");
      else {
        printf("\nVerification Failed - ");
        if (i==0)  printf("signature error\n");
        else printf("validity interval error\n");
      }
  }
  return(TRUE);
}


dumpCertificateMD2(internalcertif)
struct type_SPHINX_Certificate *internalcertif;
{
        BigNumDigit MD2_digest [4];
	char *asn1_new_cert;
	int new_len;

        ber_encode(internalcertif->cinfo,encode_SPHINX_CertifInfo,PS_LEN_LONG,
                                        &asn1_new_cert, &new_len);
	RSA_MD2(asn1_new_cert,new_len,MD2_digest);
        printf("\nMD2 computed on new buffer: ");
   	PrintBigNum(MD2_digest,BnnNumDigits(MD2_digest,4),16);
        printf("\n");
        free(asn1_new_cert);
}

display_alg_id (a)
struct type_SPHINX_AlgorithmIdentifier *a;
{
        char *x = sprintoid(a->algorithm);

        printf("%s ",x);
        if (strcmp(x,RSA_OID)==0) printf(" (ISO 9594-8: RSA)");
        if (strcmp(x,OIW_MD2_WITH_RSA_OID)==0)
                printf(" (OSI Implementors Workshop: RSA with MD2)");
        if (strcmp(x,DEC_DEA_MAC_OID)==0)
		printf(" (Digital: DEA X9.9 MAC)");
        if (a->parameter)
           switch (a->parameter->offset) {
           case choice_SPHINX_0_keySize :    
                printf("\n    INTEGER parameter type (value = %d)\n", a->parameter->un.keySize);
                break;
           case choice_SPHINX_0_null :
                printf("\n    NULL parameter type ");
                if (a->parameter->un.null)
                    printf("(illegal value: %d)\n", a->parameter->un.null);
                else printf("\n");
                break;                    
           default :
                printf("\n   Unrecognized optional parameter type.\n");
           }
        else printf("\n  No optional parameter.\n");
}
