/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/get_domain_name.c,v $
 *
 *
 *  MODULE NAME:    get_domain_name.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <strings.h>
#include <stdio.h>
#include <ctype.h>
#include <syslog.h>
#include <netdb.h>
#include <pwd.h>
#include "cdc.h"

extern char *index();
static char domain_fn[FULLNAME_SZ];

char *get_domain_name(inet_host)
char *inet_host;
{
  int c, i, offset, len, single_quoted = 0, double_quoted = 0; 
  FILE  *f;
  struct passwd     *pwd;
  char   cdc_filename[80], linebuf[200], inet_host_entry[80], *env;
  char   inet_fullhost[80], *cp1, *cp2;
  char   def_domain_fn[FULLNAME_SZ], *domain_fn_ptr;

  domain_fn[0] = '\0';
  if ((env = (char *) getenv("HOME")) != NULL) strcpy(cdc_filename, env);
  else {
    pwd = getpwuid(getuid());
    strcpy(cdc_filename, pwd->pw_dir);
  }
  strcat(cdc_filename, "/");
  strcat(cdc_filename, CDC_CONF);
  if ((f = fopen(cdc_filename, "r")) == NULL) {
    strcpy(cdc_filename, "/etc/");
    strcat(cdc_filename, CDC_CONF);
    if ((f = fopen(cdc_filename, "r")) == NULL) {
      bzero(domain_fn, sizeof(domain_fn));
      strcpy(domain_fn, CDC_DOMAIN);
      return(domain_fn);
    }
  }

  bzero(domain_fn, sizeof(domain_fn));
  get_domain_line(f, linebuf);
  strcpy(domain_fn, linebuf);
  domain_fn_ptr = &domain_fn[0];
  if ((domain_fn[0] == '"') || (domain_fn[0] == '\'')) {
    domain_fn_ptr = &domain_fn[1];
    domain_fn[strlen(domain_fn)-1] = '\0';
  }
  if (inet_host == NULL) {
    fclose(f);
    return(domain_fn_ptr);
  } else {
    strcpy(def_domain_fn, domain_fn_ptr);
    strcpy(inet_fullhost, inet_host);

    while(get_domain_line(f, linebuf)) {
      sscanf(linebuf, "%s", inet_host_entry);
      offset = strlen(inet_host_entry);
      if (inet_host_entry[0] == '*') {
        cp1 = &inet_host_entry[1];
        cp2 = &inet_fullhost[strlen(inet_fullhost)-offset+1];
      } else {
        cp1 = inet_host_entry;
        cp2 = inet_fullhost;
      }

      if (strcmp(cp1, cp2) == 0) {
        while (linebuf[offset] == ' ') offset++;
	if (sscanf(&linebuf[offset], "%s", domain_fn) == -1) {
	  domain_fn[0] = '\0';
	}
        len = strlen(domain_fn);
        domain_fn_ptr = &domain_fn[0];
        if (domain_fn[0] == '"')  double_quoted = 1;
        if (domain_fn[0] == '\'')  single_quoted = 1;
        if (double_quoted || single_quoted) {
          if (single_quoted) {
            if (domain_fn[len-1] != '\'') {
              while ((linebuf[offset+len]!='\0') && (linebuf[offset+len]!='\'')) {
                domain_fn[len] = linebuf[offset + len];
                len++;
              }
            } else domain_fn[len-1] = '\0';
          }
          if (double_quoted) {
            if (domain_fn[len-1] != '"') {
              while ((linebuf[offset+len]!='\0') && (linebuf[offset+len]!='"')) {
                domain_fn[len] = linebuf[offset + len];
                len++;
              }
            } else domain_fn[len-1] = '\0';
          }

          domain_fn[len] = '\0';
          domain_fn_ptr = &domain_fn[1];
        } else domain_fn_ptr = &domain_fn[0];
	break;
      }
    }
    if (domain_fn[0] == '\0') {
      strcpy(domain_fn, def_domain_fn);
      domain_fn_ptr = &domain_fn[0];
    }
    fclose(f);
    return(domain_fn_ptr);
  }
}

int get_domain_line(f, linebuf)
FILE *f;
char *linebuf;
{
  int c, i = 0;

  c = getc(f);
  while ((c != '\n') && (c != EOF)) {
    linebuf[i++] = c;
    c = getc(f);
  }
  linebuf[i] = '\0';
  if ((c == EOF) && (i == 0))  return(0);
  return(1);
}
