/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/api/RCS/acquire_cred.c,v $
 *
 *
 *  MODULE NAME:    acquire_cred.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */

 
/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <pwd.h>
#include <sys/types.h>
#include <syslog.h>
#include "cdc.h"
#include "cdc_db.h"
#include "SPHINX-types.h"
#include "BigNum.h"
#include "BigRSA.h"
#include "random.h"
#include "spxapi_defs.h"

#define CLOCKS_SKEW  5*60
extern char *rindex();

int Sphinx_Acquire_cred(desiredname, mech_type, cred_usage, cred_handle, 
                        ta_cred_handle, debugflag)
char  *desiredname;
int   mech_type, cred_usage;
char  **cred_handle;
char  **ta_cred_handle;
int   debugflag;
{
  char *localname=NULL, *cp, myname[ANAME_SZ];
  TrustedCred          *ta_cred;
  int  i, time_now;
  struct passwd        *pwd;

  if (desiredname != NULL) {
    localname = (cp = rindex(desiredname, '=')) ? cp+1 : desiredname;
  } 

  ta_cred = (TrustedCred *) malloc(sizeof(TrustedCred));
  time_now = time(0);
  if (cred_usage == 1) {  /*  claimant credentials  */
    ClaimantCred  *claimant_cred;

    claimant_cred = (ClaimantCred *) malloc(sizeof(ClaimantCred));

    if (localname == NULL) {
      pwd = getpwuid(getuid());
      strcpy(myname, pwd->pw_name);
      localname = &myname[0];
    }
    if ((i = spx_tf_init(spx_tkt_string(localname, NULL), R_TKT_FIL)) != ASUCCESS) {
/*
      if (i==TKT_FIL_ACC)
	syslog(LOG_INFO, "cannot access claimant credential file");
      if (i==NO_TKT_FIL)
	syslog(LOG_INFO, "claimant credential file doesn't exist");
      if (i==TKT_FIL_LCK)
	syslog(LOG_INFO, "unable to lock claimant credential file");
*/
      return(SPX_S_UNABLE_TO_ACCESS_CLAIM_CRED);
    }
    if (spx_tf_get_cred(localname, claimant_cred, ta_cred) < 0) {
      return(SPX_S_CLAIM_CRED_CORRUPT);
    }
    *cred_handle = (char *) claimant_cred;
    spx_tf_close();
    if (claimant_cred->after == 0)  return(SPX_S_CLAIM_CRED_CORRUPT);
    if (time_now < claimant_cred->before-CLOCKS_SKEW)
      return(SPX_S_CLAIM_CRED_NOT_VALID_YET);
    if (time_now > claimant_cred->after+CLOCKS_SKEW)
      return(SPX_S_CLAIM_CRED_EXPIRED);
  } else {                /*  verifier credentials  */
    VerifierCred  *verifier_cred;

    verifier_cred = (VerifierCred *) malloc(sizeof(VerifierCred));

    if ((i=vf_init(ver_string(localname, NULL), R_TKT_FIL)) != ASUCCESS) {
      syslog(LOG_INFO, "localname is '%s' ; ver_string is '%s'", localname, ver_string(localname, NULL));
      if (i==TKT_FIL_ACC)
	syslog(LOG_INFO, "cannot access verifier credential file\n");
      if (i==NO_TKT_FIL)
	syslog(LOG_INFO, "verifier credential file doesn't exist\n");
      if (i==TKT_FIL_LCK)
	syslog(LOG_INFO, "unable to lock verifier credential file\n");
      return(SPX_S_UNABLE_TO_ACCESS_VERIF_CRED);
    }
    if (vf_get_cred(localname, verifier_cred, ta_cred) < 0) {
      return(SPX_S_VERIF_CRED_CORRUPT);
    }
    if (debugflag) {
        display_verifier_cred (verifier_cred,0);
        display_ta_cred(ta_cred,0);
    }    
    *cred_handle = (char *) verifier_cred;
    vf_close();
    if (verifier_cred->after == 0)  return(SPX_S_VERIF_CRED_CORRUPT);
    if (time_now < verifier_cred->before)
      return(SPX_S_VERIF_CRED_NOT_VALID_YET);
    if (time_now > verifier_cred->after)
      return(SPX_S_VERIF_CRED_EXPIRED);
  }
  *ta_cred_handle = (char *) ta_cred;
  return(SPX_S_ACQUIRE_SUCCESS);
}

