import { HttpLibArgs } from "./http-common.js";
import {
  HttpRequestLibrary,
  HttpRequestOptions,
  HttpResponse,
} from "./http.js";
/**
 * Implementation of the HTTP request library interface for node.
 */
export declare class HttpLibImpl implements HttpRequestLibrary {
  private throttle;
  private throttlingEnabled;
  constructor(args?: HttpLibArgs);
  /**
   * Set whether requests should be throttled.
   */
  setThrottling(enabled: boolean): void;
  fetch(url: string, opt?: HttpRequestOptions): Promise<HttpResponse>;
  get(url: string, opt?: HttpRequestOptions): Promise<HttpResponse>;
  postJson(
    url: string,
    body: any,
    opt?: HttpRequestOptions,
  ): Promise<HttpResponse>;
}
