/*
   This file is part of TALER
   Copyright (C) 2024 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_update_donau_instance_receipts_amount.c
 * @brief Implementation of the update_donau_instance_receipts_amount
 *        function for Postgres
 * @author Bohdan Potuzhnyi
 * @author Vlada Svirsh
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_update_donau_instance_receipts_amount.h"
#include "pg_helper.h"

enum GNUNET_DB_QueryStatus
TMH_PG_update_donau_instance_receipts_amount (
  void *cls,
  uint64_t *donau_instances_serial,
  const struct TALER_Amount *new_amount)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_uint64 (donau_instances_serial),
    TALER_PQ_query_param_amount_with_currency (pg->conn,
                                               new_amount),
    GNUNET_PQ_query_param_end
  };

  check_connection (pg);

  PREPARE (pg,
           "update_donau_instance_receipts",
           "UPDATE merchant_donau_instances "
           "SET charity_receipts_to_date = $2 "
           "WHERE donau_instances_serial = $1;");

  return GNUNET_PQ_eval_prepared_non_select (pg->conn,
                                             "update_donau_instance_receipts",
                                             params);
}
