/*  GNU Moe - My Own Editor
    Copyright (C) 2005, 2006, 2007, 2008 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace Window_vector {

int init() throw();
int load( int new_size = 0 ) throw();

void bufhandle_menu( const int abort_key ) throw();
void load_file( const int abort_key ) throw();
void split_window() throw();
void save_file( const int abort_key ) throw();
int close( bool abort, const bool quiet = false ) throw();
int close_and_exit( const bool abort ) throw();

Window & curwin() throw();
void next() throw();
void prev() throw();
Window & window( int i ) throw();
int windows() throw();

void add_char( unsigned char ch, const bool force = false ) throw();
void delete_char( const bool back = false ) throw();
void delete_line() throw();
void copy_block() throw();
void delete_block() throw();
void move_block() throw();
void read_block() throw();
void write_block() throw();
void indent_block() throw();
void unindent_block() throw();
void undo() throw();
void redo() throw();

void center_line() throw();
void reformat() throw();
void change_case( const bool to_caps ) throw();
void encode_base64() throw();
void decode_base64() throw();
void decode_quoted_printable_utf8( const bool mode_q ) throw();
void encode_rot1347( const bool mode13 ) throw();
void remove_duplicate_lines( const bool back = false ) throw();

void copyright_update() throw();
void search_word( const int abort_key ) throw();
void search( const int abort_key, const bool again = false,
             const std::string & s_ini = "" ) throw();

} // end namespace Window_vector
