/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util;

public class Strings {
    private static final String encTable = "0123456789ABCDEFGHIJKLMNOPQRSTUV";

    public static String dataToString(byte[] data) {
        StringBuilder sb = new StringBuilder();
        long rpos = 0L;
        long bits = 0L;
        long size = data.length;
        for (long vbit = 0L; rpos < size || vbit > 0L; vbit -= 5L) {
            if (rpos < size && vbit < 5L) {
                int b;
                int s = (b = data[(int)rpos++]) >= 0 ? b : 256 + b;
                bits = bits << 8 | (long)s;
                vbit += 8L;
            }
            if (vbit < 5L) {
                bits <<= (int)(5L - vbit);
                vbit = 5L;
            }
            sb.append(encTable.charAt((int)(bits >>> (int)(vbit - 5L)) & 0x1F));
        }
        if (sb.length() != Strings.getEncodedStringLength(data.length)) {
            throw new AssertionError();
        }
        return sb.toString();
    }

    public static boolean stringToData(String string, byte[] outData) {
        long bits;
        long ret;
        long shift;
        long vbit;
        int enclen = string.length();
        int encodedLen = outData.length * 8;
        if (0 == enclen) {
            return 0 == outData.length;
        }
        long wpos = outData.length;
        long rpos = enclen;
        if (encodedLen % 5 > 0) {
            vbit = encodedLen % 5;
            shift = 5L - vbit;
            ret = Strings.getValue(string.charAt((int)(--rpos)));
            bits = ret >>> 5 - encodedLen % 5;
        } else {
            vbit = 5L;
            shift = 0L;
            bits = ret = (long)Strings.getValue(string.charAt((int)(--rpos)));
        }
        if (((long)encodedLen + shift) / 5L != (long)enclen) {
            return false;
        }
        if (-1L == ret) {
            return false;
        }
        while (wpos > 0L) {
            if (0L == rpos) {
                throw new AssertionError((Object)("rpos=0, but wpos " + wpos));
            }
            ret = Strings.getValue(string.charAt((int)(--rpos)));
            bits = ret << (int)vbit | bits;
            if (-1L == ret) {
                return false;
            }
            if ((vbit += 5L) < 8L) continue;
            outData[(int)(--wpos)] = (byte)bits;
            bits >>>= 8;
            vbit -= 8L;
        }
        return rpos == 0L && vbit == 0L;
    }

    public static byte[] stringToData(String string, int outSize) {
        byte[] outData = new byte[outSize];
        if (Strings.stringToData(string, outData)) {
            return outData;
        }
        return null;
    }

    public static int getEncodedStringLength(int dataSize) {
        return (dataSize * 8 + 4) / 5;
    }

    public static int getDecodedDataLength(int stringSize) {
        return stringSize * 5 / 8;
    }

    private static int getValue(char a) {
        if (a >= '0' && a <= '9') {
            return a - 48;
        }
        if (a >= 'A' && a <= 'V') {
            return a - 65 + 10;
        }
        return -1;
    }

    public static byte[] stringToData(String s) {
        return Strings.stringToData(s, Strings.getDecodedDataLength(s.length()));
    }
}

