/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.mq;

import java.util.LinkedList;
import org.gnunet.mq.Envelope;
import org.gnunet.util.GnunetMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageQueue {
    private static final Logger logger = LoggerFactory.getLogger(MessageQueue.class);
    private LinkedList<Envelope> queuedEnvelopes = new LinkedList();
    private LinkedList<Envelope> preferredQueuedEnvelopes = new LinkedList();
    protected Envelope currentEnvelope;
    private boolean readyForSubmit;

    protected abstract void submit(Envelope var1);

    protected abstract void retract();

    public void send(GnunetMessage.Body body) {
        this.send(new Envelope(body));
    }

    public void sendPreferred(GnunetMessage.Body body) {
        this.sendPreferred(new Envelope(body));
    }

    public void send(Envelope ev) {
        logger.debug("message queue {}: queueing message", (Object)this.getClass().getName());
        this.queuedEnvelopes.addLast(ev);
        this.trySubmitNext();
    }

    public void sendPreferred(Envelope ev) {
        logger.debug("message queue {}: queueing preferred message", (Object)this.getClass().getName());
        this.preferredQueuedEnvelopes.addLast(ev);
        this.trySubmitNext();
    }

    private Envelope pollNextEnvelope() {
        if (!this.preferredQueuedEnvelopes.isEmpty()) {
            return this.preferredQueuedEnvelopes.removeFirst();
        }
        if (!this.queuedEnvelopes.isEmpty()) {
            return this.queuedEnvelopes.removeFirst();
        }
        return null;
    }

    protected void trySubmitNext() {
        if (this.currentEnvelope != null || !this.readyForSubmit) {
            logger.debug("message queue {}: not submitting (not ready)", (Object)this.getClass().getName());
            return;
        }
        Envelope ev = this.pollNextEnvelope();
        if (ev == null) {
            logger.debug("message queue {}: not submitting (nothing to send)", (Object)this.getClass().getName());
            return;
        }
        this.currentEnvelope = ev;
        this.readyForSubmit = false;
        this.submit(this.currentEnvelope);
    }

    protected void reportReadyForSubmit() {
        if (this.readyForSubmit) {
            throw new AssertionError((Object)"message queue reported 'ready for submit' twice");
        }
        logger.debug("message queue {} ready for submit", (Object)this.getClass().getName());
        this.readyForSubmit = true;
        this.trySubmitNext();
    }

    protected void reportMessageSent() {
        if (null == this.currentEnvelope) {
            throw new AssertionError();
        }
        this.currentEnvelope.invokeSentNotification();
        this.currentEnvelope = null;
        this.trySubmitNext();
    }

    void cancelEnvelope(Envelope ev) {
        if (ev == this.currentEnvelope) {
            this.retract();
            this.trySubmitNext();
        } else {
            this.queuedEnvelopes.remove(ev);
            this.preferredQueuedEnvelopes.remove(ev);
        }
    }
}

