/*
 * This program is an implementation of the ISAKMP Internet Standard.
 * Copyright (C) 1997 Angelos D. Keromytis.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * This code was written while the author was in Greece, in May/June
 * 1997.
 *
 * You may contact the author by:
 *   e-mail: angelos@dsl.cis.upenn.edu
 *  US-mail: Angelos D. Keromytis
 *           Distributed Systems Lab
 *           Computer and Information Science Department
 *           University of Pennsylvania
 *           Moore Building
 *           200 South 33rd Street
 *           Philadelphia, PA 19104	   
 */

/*
 * This file defines the state and the event objects
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <time.h>

struct event
{
    time_t          ev_time;
    u_int32_t       ev_type;        /* Event type */
    void           *ev_ptr;         /* Pointer to event specific structure */
    u_int32_t       ev_ptr_len;     /* Length of ptr, where applicable */
    struct event   *ev_next;        /* Pointer to next event */
};

struct state
{
    u_int32_t          st_doi;
    u_int32_t          st_mysituation;          
    u_int32_t          st_peersituation;       /* Situations proposed */
    u_int32_t          st_goal;                /* What am i trying to get */
    u_int32_t          st_flags;
    u_char             st_icookie[COOKIE_SIZE];
    u_char             st_rcookie[COOKIE_SIZE];/* I/R cookies */
    struct sockaddr    st_peer;                /* Peer's address */
    u_int32_t          st_state;               /* State of exchange */
    u_char            *st_packet;              /* Transmitted packet */
    u_int32_t          st_packet_len;          /* Size of transmitted packet */
    u_int32_t          st_retransmit;          /* Number of retransmitts */
    struct event      *st_event;               /* Pointer to some event */
    struct state      *st_next;                /* Next in list */
    struct state      *st_prev;		       /* Previous in list */
};
