/* p12_pbe.c */
/* Copyright (C) 1997-8 Dr S N Henson (shenson@bigfoot.com) 
 * All Rights Reserved.
 * Any software using this code must include the following message in its
 * startup code or documentation and in any advertising material:
 * "This Product includes cryptographic software written by Dr S N Henson
 *  (shenson@bigfoot.com)"
 */
#include <stdio.h>
#include <stdlib.h>
#include <asn1_mac.h>
#include <err.h>
#include "pkcs12.h"

/*
 *PKCS12err(PKCS12_F_PBEPARAM_NEW,PKCS12_R_DEOCDE_ERROR)
 *PKCS12err(PKCS12_F_D2I_PBEPARAM,PKCS12_R_DEOCDE_ERROR)
 */

int i2d_PBEPARAM(a, pp)
PBEPARAM *a;
unsigned char **pp;
{
	M_ASN1_I2D_vars(a);
	M_ASN1_I2D_len (a->salt, i2d_ASN1_OCTET_STRING);
	M_ASN1_I2D_len (a->iter, i2d_ASN1_INTEGER);

	M_ASN1_I2D_seq_total ();

	M_ASN1_I2D_put (a->salt, i2d_ASN1_OCTET_STRING);
	M_ASN1_I2D_put (a->iter, i2d_ASN1_INTEGER);
	M_ASN1_I2D_finish();
}

PBEPARAM *PBEPARAM_new()
{
	PBEPARAM *ret=NULL;
	M_ASN1_New_Malloc(ret, PBEPARAM);
	M_ASN1_New(ret->iter,ASN1_INTEGER_new);
	M_ASN1_New(ret->salt,ASN1_OCTET_STRING_new);
	return (ret);
	M_ASN1_New_Error(PKCS12_F_PBEPARAM_NEW);
}

PBEPARAM *d2i_PBEPARAM(a,pp,length)
PBEPARAM **a;
unsigned char **pp;
long length;
{
	M_ASN1_D2I_vars(a,PBEPARAM *,PBEPARAM_new);
	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();
	M_ASN1_D2I_get (ret->salt, d2i_ASN1_OCTET_STRING);
	M_ASN1_D2I_get (ret->iter, d2i_ASN1_INTEGER);
	M_ASN1_D2I_Finish(a, PBEPARAM_free, PKCS12_F_D2I_PBEPARAM);
}

void PBEPARAM_free (a)
PBEPARAM *a;
{
	if(a==NULL) return;
	ASN1_OCTET_STRING_free (a->salt);
	ASN1_INTEGER_free (a->iter);
	Free ((char *)a);
}
