/* p12_mac.c */
/* Copyright (C) 1997-8 Dr S N Henson (shenson@bigfoot.com) 
 * All Rights Reserved.
 * Any software using this code must include the following message in its
 * startup code or documentation and in any advertising material:
 * "This Product includes cryptographic software written by Dr S N Henson
 *  (shenson@bigfoot.com)"
 */
#include <stdio.h>
#include <stdlib.h>
#include <asn1_mac.h>
#include <err.h>
#include "pkcs12.h"
/*
 *PKCS12err(PKCS12_F_PKCS12_MAC_DATA_NEW,PKCS12_R_DECODE_ERROR)
 *PKCS12err(PKCS12_F_D2I_PKCS12_MAC_DATA,PKCS12_R_DECODE_ERROR)
 */

int i2d_PKCS12_MAC_DATA(a,pp)
PKCS12_MAC_DATA *a;
unsigned char **pp;
{
	M_ASN1_I2D_vars(a);
	M_ASN1_I2D_len (a->dinfo, i2d_X509_SIG);
	M_ASN1_I2D_len (a->salt, i2d_ASN1_OCTET_STRING);
	M_ASN1_I2D_len (a->iter, i2d_ASN1_INTEGER);

	M_ASN1_I2D_seq_total();

	M_ASN1_I2D_put (a->dinfo, i2d_X509_SIG);
	M_ASN1_I2D_put (a->salt, i2d_ASN1_OCTET_STRING);
	M_ASN1_I2D_put (a->iter, i2d_ASN1_INTEGER);
	M_ASN1_I2D_finish();
}

PKCS12_MAC_DATA *PKCS12_MAC_DATA_new()
{
	PKCS12_MAC_DATA *ret=NULL;
	M_ASN1_New_Malloc(ret, PKCS12_MAC_DATA);
	ret->dinfo = X509_SIG_new();
	ret->salt = ASN1_OCTET_STRING_new();
	ret->iter = NULL;
	return (ret);
	M_ASN1_New_Error(PKCS12_F_PKCS12_MAC_DATA_NEW);
}

PKCS12_MAC_DATA *d2i_PKCS12_MAC_DATA(a,pp,length)
PKCS12_MAC_DATA **a;
unsigned char **pp;
long length;
{
	M_ASN1_D2I_vars(a,PKCS12_MAC_DATA *,PKCS12_MAC_DATA_new);
	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();
	M_ASN1_D2I_get (ret->dinfo, d2i_X509_SIG);
	M_ASN1_D2I_get (ret->salt, d2i_ASN1_OCTET_STRING);
	M_ASN1_D2I_get_opt (ret->iter, d2i_ASN1_INTEGER, V_ASN1_INTEGER);
	M_ASN1_D2I_Finish(a, PKCS12_MAC_DATA_free, PKCS12_F_D2I_PKCS12_MAC_DATA);
}

void PKCS12_MAC_DATA_free (a)
PKCS12_MAC_DATA *a;
{
	if (a == NULL) return;
	X509_SIG_free (a->dinfo);
	ASN1_OCTET_STRING_free (a->salt);
	ASN1_INTEGER_free (a->iter);
	Free ((char *)a);
}
