/* p12_crpt.c */
/* Copyright (C) 1997-8 Dr S N Henson (shenson@bigfoot.com) 
 * All Rights Reserved.
 * Any software using this code must include the following message in its
 * startup code or documentation and in any advertising material:
 * "This Product includes cryptographic software written by Dr S N Henson
 *  (shenson@bigfoot.com)"
 */
#include <stdio.h>
#include <stdlib.h>
#include <err.h>
#include "pkcs12.h"

/* PKCS#12 specific PBE functions */

void PKCS12_PBE_add()
{
	int obj_off;
	obj_off = PKCS12_obj_offset();
EVP_PBE_alg_add(NID_pbe_WithSHA1And128BitRC4  + obj_off, EVP_rc4(), EVP_sha1(),
							 PKCS12_PBE_keyivgen);
EVP_PBE_alg_add(NID_pbe_WithSHA1And40BitRC4 + obj_off, EVP_rc4_40(), EVP_sha1(),
							 PKCS12_PBE_keyivgen);
EVP_PBE_alg_add(NID_pbe_WithSHA1And3_Key_TripleDES_CBC + obj_off,
		 	EVP_des_ede3_cbc(), EVP_sha1(), PKCS12_PBE_keyivgen);
EVP_PBE_alg_add(NID_pbe_WithSHA1And2_Key_TripleDES_CBC + obj_off, 
			EVP_des_ede_cbc(), EVP_sha1(), PKCS12_PBE_keyivgen);
EVP_PBE_alg_add(NID_pbe_WithSHA1And128BitRC2_CBC + obj_off, EVP_rc2_cbc(),
					EVP_sha1(), PKCS12_PBE_keyivgen);
EVP_PBE_alg_add(NID_pbe_WithSHA1And40BitRC2_CBC + obj_off, EVP_rc2_40_cbc(),
					EVP_sha1(), PKCS12_PBE_keyivgen);
}

int PKCS12_PBE_keyivgen (pass, passlen, salt, saltlen, iter, cipher,
								 md, key, iv)
unsigned char *pass;
int passlen;
unsigned char *salt;
int saltlen;
int iter;
EVP_CIPHER *cipher;
EVP_MD *md;
unsigned char *key, *iv;
{
	if (!PKCS12_key_gen (pass, passlen, salt, saltlen, PKCS12_KEY_ID,
 				iter, EVP_CIPHER_key_length(cipher), key, md)) {
		PKCS12err(PKCS12_F_PKCS12_PBE_KEYIVGEN,PKCS12_R_KEY_GEN_ERROR);
		return 0;
	}
	if (!PKCS12_key_gen (pass, passlen, salt, saltlen, PKCS12_IV_ID,
				iter, EVP_CIPHER_iv_length(cipher), iv, md)) {
		PKCS12err(PKCS12_F_PKCS12_PBE_KEYIVGEN,PKCS12_R_IV_GEN_ERROR);
		return 0;
	}
	return 1;
}
