/* p12_add.c */
/* Copyright (C) 1997-8 Dr S N Henson (shenson@bigfoot.com) 
 * All Rights Reserved.
 * Any software using this code must include the following message in its
 * startup code or documentation and in any advertising material:
 * "This Product includes cryptographic software written by Dr S N Henson
 *  (shenson@bigfoot.com)"
 */
#include <stdio.h>
#include <stdlib.h>
#include <err.h>
#include "pkcs12.h"

/* Pack an object into an OCTET STRING and turn into a safebag */

PKCS12_SAFEBAG *PKCS12_pack_safebag (obj, i2d, nid1, nid2)
char *obj;
int (*i2d)();
int nid1;
int nid2;

{
	PKCS12_BAGS *bag;
	PKCS12_SAFEBAG *safebag;
	if (!(bag = PKCS12_BAGS_new ())) {
		PKCS12err(PKCS12_F_PKCS12_PACK_SAFEBAG, ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	M_ASN1_OBJECT_set(bag->type, nid1 + PKCS12_obj_offset());
	if (!PKCS12_pack_octet (obj, i2d, &bag->value.octet)) {
		PKCS12err(PKCS12_F_PKCS12_PACK_SAFEBAG, ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	if (!(safebag = PKCS12_SAFEBAG_new ())) {
		PKCS12err(PKCS12_F_PKCS12_PACK_SAFEBAG, ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	safebag->value.bag = bag;
	M_ASN1_OBJECT_set(safebag->type, nid2 + PKCS12_obj_offset());
	return safebag;
}

/* Turn PKCS8 object into a keybag */

PKCS12_SAFEBAG *PKCS12_MAKE_KEYBAG (p8)
PKCS8_PRIV_KEY_INFO *p8;
{
	PKCS12_SAFEBAG *bag;
	if (!(bag = PKCS12_SAFEBAG_new())) {
		PKCS12err(PKCS12_F_PKCS12_MAKE_SAFEBAG, ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	M_ASN1_OBJECT_set(bag->type, NID_keyBag + PKCS12_obj_offset());
	bag->value.keybag = p8;
	return bag;
}

/* Turn PKCS8 object into a shrouded keybag */

PKCS12_SAFEBAG
	 *PKCS12_MAKE_SHKEYBAG (pbe_nid, pass, passlen, salt, saltlen, iter, p8)int pbe_nid;
unsigned char *pass;
int passlen;
unsigned char *salt;
int saltlen;
int iter;
PKCS8_PRIV_KEY_INFO *p8;
{
	PKCS12_SAFEBAG *bag;

	/* Set up the safe bag */
	if (!(bag = PKCS12_SAFEBAG_new ())) {
		PKCS12err(PKCS12_F_PKCS12_MAKE_SHKEYBAG, ERR_R_MALLOC_FAILURE);
		return NULL;
	}

	M_ASN1_OBJECT_set(bag->type, NID_pkcs8ShroudedKeyBag +
							 PKCS12_obj_offset());
	if (!(bag->value.shkeybag = 
	  PKCS8_encrypt (pbe_nid + PKCS12_obj_offset(), pass, passlen,
						 salt, saltlen, iter, p8))) {
		PKCS12err(PKCS12_F_PKCS12_MAKE_SHKEYBAG, ERR_R_MALLOC_FAILURE);
		return NULL;
	}

	return bag;
}

/* Turn a stack of SAFEBAGS into a PKCS#7 data Contentinfo */
PKCS7 *PKCS12_pack_p7data (sk)
STACK *sk;
{
	PKCS7 *p7;
	if (!(p7 = PKCS7_new())) {
		PKCS12err(PKCS12_F_PKCS12_PACK_P7_DATA, ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	M_ASN1_OBJECT_set(p7->type, NID_pkcs7_data);
	if (!(p7->d.data = ASN1_OCTET_STRING_new())) {
		PKCS12err(PKCS12_F_PKCS12_PACK_P7_DATA, ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	
	if (!PKCS12_struct_pack (sk, i2d_PKCS12_SAFEBAG, &p7->d.data->data,
					&p7->d.data->length)) {
		PKCS12err(PKCS12_F_PKCS12_PACK_P7DATA, PKCS12_R_CANT_PACK_STRUCTURE);
		return NULL;
	}
	return p7;
}

/* Turn a stack of SAFEBAGS into a PKCS#7 encrypted data ContentInfo */

PKCS7 *PKCS12_pack_p7encdata (pbe_nid, pass, passlen, salt, saltlen, iter,
									 bags)
int pbe_nid;
unsigned char *pass;
int passlen;
unsigned char *salt;
int saltlen;
int iter;
STACK *bags;
{
	PKCS7 *p7;
	X509_ALGOR *pbe;
	if (!(p7 = PKCS7_new())) {
		PKCS12err(PKCS12_F_PKCS12_PACK_P7ENCDATA, ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	/* The next bit may end up in PKCS7_set_type eventually */
	M_ASN1_OBJECT_set(p7->type, NID_pkcs7_encrypted);
	if (!(p7->d.encrypted = PKCS7_ENCRYPT_new ())) {
		PKCS12err(PKCS12_F_PKCS12_PACK_P7ENCDATA, ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	ASN1_INTEGER_set (p7->d.encrypted->version, 0);
	M_ASN1_OBJECT_set(p7->d.encrypted->enc_data->content_type,
								NID_pkcs7_data);
	if (!(pbe = PKCS12_pbe_set (pbe_nid + PKCS12_obj_offset(), iter,
							 salt, saltlen))) {
		PKCS12err(PKCS12_F_PKCS12_PACK_P7ENCDATA, ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	X509_ALGOR_free(p7->d.encrypted->enc_data->algorithm);
	p7->d.encrypted->enc_data->algorithm = pbe;
	ASN1_OCTET_STRING_free(p7->d.encrypted->enc_data->enc_data);
	if (!(p7->d.encrypted->enc_data->enc_data =
	PKCS12_i2d_encrypt (pbe, i2d_PKCS12_SAFEBAG, pass, passlen,
				 (char *)bags, 1))) {
		PKCS12err(PKCS12_F_PKCS12_PACK_P7ENCDATA, PKCS12_R_ENCRYPT_ERROR);
		return NULL;
	}

	return p7;
}

X509_SIG *PKCS8_encrypt (pbe_nid, pass, passlen, salt, saltlen, iter, p8inf)
int pbe_nid;
unsigned char *pass;
int passlen;
unsigned char *salt;
int saltlen;
int iter;
PKCS8_PRIV_KEY_INFO *p8inf;
{
	X509_SIG *p8;
	X509_ALGOR *pbe;

	if (!(p8 = X509_SIG_new())) {
		PKCS12err(PKCS12_F_PKCS8_ENCRYPT, ERR_R_MALLOC_FAILURE);
		return NULL;
	}

	if (!(pbe = PKCS12_pbe_set (pbe_nid, iter, salt, saltlen))) {
		PKCS12err(PKCS12_F_PKCS8_ENCRYPT, ERR_R_MALLOC_FAILURE);
		return NULL;
	}
	X509_ALGOR_free(p8->algor);
	p8->algor = pbe;
	ASN1_OCTET_STRING_free(p8->digest);
	if (!(p8->digest = 
	PKCS12_i2d_encrypt (pbe, i2d_PKCS8_PRIV_KEY_INFO, pass, passlen,
						 (char *)p8inf, 0))) {
		PKCS12err(PKCS12_F_PKCS8_ENCRYPT, PKCS12_R_ENCRYPT_ERROR);
		return NULL;
	}

	return p8;
}
