#include <m68k/m68k.h>

/* Get generic NetBSD definitions.  */

#include <netbsd.h>


/* See m68k.h.  7 means 68020 with 68881.  */

#define TARGET_DEFAULT 7

/* Define __HAVE_68881__ in preprocessor, unless -msoft-float is specified.
   This will control the use of inline 68881 insns in certain macros.  */

#undef CPP_SPEC
#define CPP_SPEC "%{!msoft-float:-D__HAVE_68881__ -D__HAVE_FPU__} %{posix:-D_POSIX_SOURCE}"

/* Names to predefine in the preprocessor for this target machine.  */

#define CPP_PREDEFINES "-Dunix -Dm68k -Dmc68000 -Dmc68020 -D__NetBSD__ -Asystem(unix) -Asystem(NetBSD) -Acpu(m68k) -Amachine(m68k)"

#define ASM_SPEC "%{fpic:-k} %{fPIC:-k}"

/* Support -static, -symbolic and -shared options (at least minimally).
   Also use -dp when doing dynamic linking.  Don't include a startup
   file when linking a shared library. */

#define LINK_SPEC     \
  "%{static:-Bstatic} %{shared:-Bshareable} %{symbolic:-Bsymbolic} \
   %{!static:%{!shared:-dp}}"

#define STARTFILE_SPEC  \
  "%{!shared:%{pg:gcrt0.o%s}%{!pg:%{p:mcrt0.o%s}%{!p:crt0.o%s}}}"

/* No more libg.a; no libraries if making shared object */

#define LIB_SPEC "%{!shared:%{!p:%{!pg:-lc}}%{p:-lc_p}%{pg:-lc_p}}"
/* Make gcc agree with <machine/ansi.h> */

#undef SIZE_TYPE
#define SIZE_TYPE "unsigned int"

#undef PTRDIFF_TYPE
#define PTRDIFF_TYPE "int"

#undef WCHAR_TYPE
#define WCHAR_TYPE "short unsigned int"

#define WCHAR_UNSIGNED 1

#undef WCHAR_TYPE_SIZE
#define WCHAR_TYPE_SIZE 16

/* Every structure or union's size must be a multiple of 2 bytes.  */

#define STRUCTURE_SIZE_BOUNDARY 16

/* This is BSD, so it wants DBX format.  */

#define DBX_DEBUGGING_INFO

/* Do not break .stabs pseudos into continuations.  */

#define DBX_CONTIN_LENGTH 0

/* This is the char to use for continuation (in case we need to turn
   continuation back on).  */

#define DBX_CONTIN_CHAR '?'

/* Don't use the `xsfoo;' construct in DBX output; this system
   doesn't support it.  */

#define DBX_NO_XREFS

/* Don't default to pcc-struct-return, because gcc is the only compiler, and
   we want to retain compatibility with older gcc versions.  */
#define DEFAULT_PCC_STRUCT_RETURN 0


/* For PIC, function CSE is undesirable since it causes all function
   calls to go via the GOT rather than the PLT. */
#undef SUBTARGET_OVERRIDE_OPTIONS
#define SUBTARGET_OVERRIDE_OPTIONS    \
{                                     \
  if (flag_pic)                               \
    flag_no_function_cse = 1;         \
}

/* not used by netbsd pic-generation (?!) */
/*#undef FINALIZE_PIC*/

/* In m68k netbsd, a symbol_ref rtx can be a valid PIC operand if it is an
   operand of a function call. */
#undef LEGITIMATE_PIC_OPERAND_P
#define LEGITIMATE_PIC_OPERAND_P(X)   \
  (! symbolic_operand (X, VOIDmode)   \
   || ((GET_CODE(X) == SYMBOL_REF) && SYMBOL_REF_FLAG(X)))

/* netbsd shared libraries know about PLTs */
#define PIC_USES_PLT
