/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/


#include "cppArgs.h"

#include "misTransferFunc.h"


void ReloadVolume(VRState *state, int v)
{
  VRVolumeData *vd = state->volumeData[v];

  int t=0;
  while (t < vd->tRes) {

    int b=0;
    while (b < vd->nBricks) {

      vd->brick[BRICK8BITS][t][b]->forceDownload = TRUE;
      if (state->world->define4BitBricks)
	vd->brick[BRICK4BITS][t][b]->forceDownload = TRUE;

      b++;
    }

    t++;
  }
}


void RedefVolume(VRState *state, int v)
{
  VRVolumeData *vd = state->volumeData[v];

  int t=0;
  while (t < vd->tRes) {

    int b=0;
    while (b < vd->nBricks) {

      vd->brick[BRICK8BITS][t][b]->forceRedef = TRUE;
      if (state->world->define4BitBricks)
	vd->brick[BRICK4BITS][t][b]->forceRedef = TRUE;

      b++;
    }

    t++;
  }
}


static float GetAlpha(VRState *state, float t)
{
  if (state->tableData->opaquify)
    return( (t<0.5) ? 0.0 : 1.0 );
  else
    return( t );
}


void UpdateTable(VRState *state, int v)
{
#ifdef VR_TLUTS

  if (!state->world->doTextures)
    return;

  VRVolumeData *vd = state->volumeData[v];
  VRTableData  *td = state->tableData;
  TransferFunc *func = &td->func[vd->curFunc];
  TransferFunc *cafunc = &td->cafunc;

  if (state->view->debug == 9)
    printf("Updating table #%d\n", v);

  // If the transfer function parameters are invalid reset them from the function defaults
  if (!vd->parmValid) {
    memcpy(vd->parm, func->parm, 4*sizeof(float));
    vd->parmValid = True;
  }

  // If the colormap parameters are invalid reset them from the function defaults
  if (!vd->cmapValid) {
    vd->caparm[0] = cafunc->parm[0];
    vd->caparm[1] = cafunc->parm[1];
    vd->cmapValid = True;
  }

  // If the alphamap parameters are invalid reset them from the function defaults
  if (!vd->amapValid) {
    vd->caparm[2] = cafunc->parm[2];
    vd->caparm[3] = cafunc->parm[3];
    vd->amapValid = True;
  }

  if (func->useMap) {

    // Call the function to generate the transfer function
    func->func(vd->parm, vd->tfunc);

    // Generate the lookup table from the transfer function, colormap, alphamap, and c/amap params
    for (int i=0; i<256; i++) {

      // Generate color and alpha indices
      int cdex = ((int) (i + 256 * vd->caparm[0])) % 256;
      int adex = ((int) (i + 256 * vd->caparm[2])) % 256;

      vd->camap[i*4+0] = vd->caparm[1] * td->cmap[vd->curCmap][cdex*3+0];
      vd->camap[i*4+1] = vd->caparm[1] * td->cmap[vd->curCmap][cdex*3+1];
      vd->camap[i*4+2] = vd->caparm[1] * td->cmap[vd->curCmap][cdex*3+2];
      vd->camap[i*4+3] = vd->caparm[3] * td->amap[vd->curAmap][adex*1+0];

      // Clamp the transfer function
      vd->tfunc[i] = CLAMP(vd->tfunc[i], 0.0, 1.0);

      // Only multiply by the transfer function if user has turned on modulation
      float ct = vd->modCmap ? vd->tfunc[i] : 1.0;
      float at = vd->modAmap ? vd->tfunc[i] : 1.0;

      vd->tlut[i*4+0] = vd->camap[i*4+0] * ct;
      vd->tlut[i*4+1] = vd->camap[i*4+1] * ct;
      vd->tlut[i*4+2] = vd->camap[i*4+2] * ct;
      vd->tlut[i*4+3] = vd->camap[i*4+3] * at;

      // Clamp the colormap / alphamap
      vd->camap[i*4+0] = CLAMP(vd->camap[i*4+0], 0.0, 1.0);
      vd->camap[i*4+1] = CLAMP(vd->camap[i*4+1], 0.0, 1.0);
      vd->camap[i*4+2] = CLAMP(vd->camap[i*4+2], 0.0, 1.0);
      vd->camap[i*4+3] = CLAMP(vd->camap[i*4+3], 0.0, 1.0);
    }

  } else {

    func->func(vd->parm, vd->tlut);

  }

  for (int i=0; i<256*4; i++)
    vd->tlut[i] = CLAMP(vd->tlut[i], 0.0, 1.0);

  if (!vd->drawColor)
    for (i=0; i<256; i++) {
      float avg = (vd->tlut[i*4+0] + vd->tlut[i*4+1] + vd->tlut[i*4+2]) / 3.0;
      vd->tlut[i*4+0] = avg;
      vd->tlut[i*4+1] = avg;
      vd->tlut[i*4+2] = avg;
    }
#endif
}


void UpdateTables( VRState *state )
{
  for (int v=0; v<state->world->nVols; v++)
    UpdateTable(state, v);
}


void InstallTable( VRState *state, int v)
{
#ifdef VR_TLUTS

  VRVolumeData *vd = state->volumeData[v];

#ifdef VR_IRISGL
  static float    tlutOptions[] = {TL_NULL};
#endif

#ifdef VR_OPENGL
  if (state->view->tlutBase == -1)
    state->view->tlutBase = glGenLists(state->world->nVols);
#endif

  if (state->view->debug == 9)
    printf("Installing table #%d\n", v);

#if (defined(VR_KONA) || defined(VR_VENICE))
  unsigned char rgbamap[256][4];

  for (int i=0; i<256; i++) {

#ifdef VR_IRISGL
    rgbamap[i][0] = GetAlpha(state, vd->tlut[i*4+3]) * 255;
    rgbamap[i][1] = vd->tlut[i*4+2] * 255;
    rgbamap[i][2] = vd->tlut[i*4+1] * 255;
    rgbamap[i][3] = vd->tlut[i*4+0] * 255;
#endif

#ifdef VR_OPENGL
    rgbamap[i][0] = vd->tlut[i*4+0] * 255;
    rgbamap[i][1] = vd->tlut[i*4+1] * 255;
    rgbamap[i][2] = vd->tlut[i*4+2] * 255;
    rgbamap[i][3] = GetAlpha(state, vd->tlut[i*4+3]) * 255;
#endif
  }

#ifdef VR_IRISGL
  tlutdef(vol+1, 4, 256, (unsigned long*) rgbamap, 0, tlutOptions);
#endif

#ifdef VR_OPENGL
  glNewList(state->view->tlutBase + v, GL_COMPILE);
  glColorTableSGI(GL_TEXTURE_COLOR_TABLE_SGI, GL_RGBA8_EXT, 256,
		  GL_RGBA, GL_UNSIGNED_BYTE, rgbamap);
  glEndList();
#endif
#endif

#ifdef VR_IMPACT
#ifdef VR_OPENGL
  float ramp[256], rgbmap[256][3], lamap[256][2], amap[256];

  for (int i=0; i<256; i++) {
    ramp[i] = i / 255.0;
    rgbmap[i][0] = vd->tlut[i*4+0];
    rgbmap[i][1] = vd->tlut[i*4+1];
    rgbmap[i][2] = vd->tlut[i*4+2];
    lamap[i][0] = vd->tlut[i*4+0]; // just use the red channel, it contains the avg.
    lamap[i][1] = amap[i] = GetAlpha(state, vd->tlut[i*4+3]);
  }

  glNewList(state->view->tlutBase + v, GL_COMPILE);

  if (vd->drawColor)
    glColorTableSGI(GL_TEXTURE_COLOR_TABLE_SGI, GL_RGB8_EXT, 256,
		    GL_RGB, GL_FLOAT, rgbmap);
  else
    glColorTableSGI(GL_TEXTURE_COLOR_TABLE_SGI, GL_LUMINANCE_ALPHA, 256,
		    GL_LUMINANCE_ALPHA, GL_FLOAT, lamap);

  glPixelMapfv(GL_PIXEL_MAP_I_TO_R, 256, ramp);
  glPixelMapfv(GL_PIXEL_MAP_I_TO_G, 256, ramp);
  glPixelMapfv(GL_PIXEL_MAP_I_TO_B, 256, ramp);

  if (vd->drawColor)
    glPixelMapfv(GL_PIXEL_MAP_I_TO_A, 256, amap);
  else
    glPixelMapfv(GL_PIXEL_MAP_I_TO_A, 256, ramp);

  glEndList();
#endif
#endif

#ifdef VR_IMPACT
  // Mark the volumes to be reloaded
  ReloadVolume(state, v);
#endif
#endif
}


void InstallTables(VRState *state)
{
  if ( state->tableData->tableRedef ) {

    UpdateTables(state);

    for (int v=0; v<state->world->nVols; v++)
      InstallTable(state, v);

    state->tableData->tableRedef = FALSE;
  }
}


void LoadTlut(VRState *state, int table)
{
#ifdef VR_TLUTS
  if (!state->world->doTextures)
    return;

#if (defined(VR_KONA) || defined(VR_VENICE))
#ifdef VR_IRISGL
  /* Bind the correct texture lookup table for this volume */
  tlutbind( 0, table+1 );
#endif

#ifdef VR_OPENGL
  /* Bind the correct texture lookup table for this volume */
  glCallList(state->view->tlutBase + table);
  glEnable(GL_TEXTURE_COLOR_TABLE_SGI);
#endif
#endif

#ifdef VR_IMPACT
  /* Bind the correct pixelmap and texture lookup table for this volume */
  glCallList(state->view->tlutBase + table);
  glPixelTransferf(GL_MAP_COLOR, 1.0);
  glEnable(GL_TEXTURE_COLOR_TABLE_SGI);
#endif
#endif
}


void UnloadTlut(VRState *state)
{
#ifdef VR_TLUTS
  if (!state->world->doTextures)
    return;

#if (defined(VR_KONA) || defined(VR_VENICE))
#ifdef VR_IRISGL
  /* Unbind any texture left bound from the volume rendering */
  texbind(0, 0);
  tlutbind(0, 0);
#endif

#ifdef VR_OPENGL
  /* Unbind any texture left bound from the volume rendering */
  glDisable(GL_TEXTURE_3D_EXT);
  glDisable(GL_TEXTURE_COLOR_TABLE_SGI);
#endif
#endif

#ifdef VR_IMPACT
  /* Unbind any texture left bound from the volume rendering */
  glDisable(GL_TEXTURE_3D_EXT);
  glPixelTransferf(GL_MAP_COLOR, 0.0);
  glDisable(GL_TEXTURE_COLOR_TABLE_SGI);
#endif
#endif
}


void WinLevFunc(float *parm, float *out)
{
  for (int i=0; i<256; i++) {
    float x = i/255.0 - parm[1];
    *out++ = parm[2] + x * tan(parm[0]);
  }
}


void TriangFunc(float *parm, float *out)
{
  for (int i=0; i<256; i++) {
    float x = fabs(i/255.0 - parm[0]);
    *out++ = parm[2] * (1.0 - x * tan(parm[1]));
  }
}


void InvTriFunc(float *parm, float *out)
{
  for (int i=0; i<256; i++) {
    float x = fabs(i/255.0 - parm[0]);
    *out++ = 1.0 - parm[2] * (1.0 - x * tan(parm[1]));
  }
}


void DblTriFunc(float *parm, float *out)
{
  for (int i=0; i<256; i++) {
    float x1 = fabs(i/255.0-parm[0]-parm[3]);
    float x2 = fabs(i/255.0-parm[0]+parm[3]);
    float f1 = parm[2] * (1.0 - x1 * tan(parm[1]));
    float f2 = parm[2] * (1.0 - x2 * tan(parm[1]));
    *out++ = (f1 > f2) ? f1 : f2;
  }
}


void DrebinFunc(float *parm, float *out)
{
  float a, x, y1, y2;

  /*
   * Note: This special transfer function comes from Bob Drebin
   * See Siggraph '88 paper (page 68)
   */
  for (int i=0; i<256; i++) {

    x = i / 255.0 * 2048;

    if ( (0<=x) && (x<=484) ) {			/* Air */

      out[4*i+0] = 0.6;
      out[4*i+1] = 0.6;
      out[4*i+2] = 0.8;

      out[4*i+3] = 0.1 * parm[0];

    } else if ( (484<x) && (x<=545) ) {         /* Air and Fat */

      a  = (x - 484.0)/(545.0 - 484.0);
      y1 = (1.0 - a) * parm[0];
      y2 =        a  * parm[1];

      out[4*i+0] = (0.6*y1  + 0.8    *y2);         
      out[4*i+1] = (0.6*y1  + 0.7    *y2);      
      out[4*i+2] = (0.8*y1  + 0.0    *y2);         
      out[4*i+3] = (0.1*y1  + 0.03125*y2);

    } else if ( (545<x) && (x<=726) ) {		/* Fat */

      out[4*i+0] = 0.8;
      out[4*i+1] = 0.7;
      out[4*i+2] = 0.0;

      out[4*i+3] = 0.03125 * parm[1];

    } else if ( (726<x) && (x<=819) )	{	/* Fat and Tissue */

      a  = (x - 726.0)/(819.0 - 726.0);
      y1 = (1.0 - a) * parm[1];
      y2 =        a  * parm[2];

      out[4*i+0] = (0.8    *y1 +  0.2   *y2);
      out[4*i+1] = (0.7    *y1 +  0.0   *y2);
      out[4*i+2] = (0.0    *y1 +  0.0   *y2);
      out[4*i+3] = (0.03125*y1 +  0.1875*y2);

    } else if ( (819<x) && (x<=883) ) {		/* Tissue */

      out[4*i+0] = 0.2;
      out[4*i+1] = 0.0;
      out[4*i+2] = 0.0;

      out[4*i+3] = 0.1875 * parm[2];

    } else if ( (883<x) && (x<=1535) ) {	/* Tissue and Bone */

      a  = (x - 883.0)/(1535.0 - 883.0);
      y1 = (1.0 - a) * parm[2];
      y2 =        a  * parm[3];

      out[4*i+0] = (0.2   *y1 + 1.0 *y2);
      out[4*i+1] = (0.0   *y1 + 1.0 *y2);
      out[4*i+2] = (0.0   *y1 + 0.9 *y2);
      out[4*i+3] = (0.1875*y1 + 0.75*y2);

    } else if ( 1535 < x ) {			/* Bone */

      out[4*i+0] = 1.0;
      out[4*i+1] = 1.0;
      out[4*i+2] = 0.9;

      out[4*i+3] = 0.75 * parm[3];
    }
  }
}
