/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/


#include <stdio.h>

#include "misMatrix.h";


matrix IdentityMatrix =
{ {1.0, 0.0, 0.0, 0.0},
  {0.0, 1.0, 0.0, 0.0},
  {0.0, 0.0, 1.0, 0.0},
  {0.0, 0.0, 0.0, 1.0}
};


void matrix_invert4( matrix m1, matrix m2 )
{
  float det;
  float a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p;

  a = m1[0][0]; b = m1[1][0]; c = m1[2][0]; d = m1[3][0];
  e = m1[0][1]; f = m1[1][1]; g = m1[2][1]; h = m1[3][1];
  i = m1[0][2]; j = m1[1][2]; k = m1[2][2]; l = m1[3][2];
  m = m1[0][3]; n = m1[1][3]; o = m1[2][3]; p = m1[3][3];

  det = d*g*j*m - c*h*j*m - d*f*k*m + b*h*k*m + c*f*l*m -
        b*g*l*m - d*g*i*n + c*h*i*n + d*e*k*n - a*h*k*n -
	c*e*l*n + a*g*l*n + d*f*i*o - b*h*i*o - d*e*j*o +
	a*h*j*o + b*e*l*o - a*f*l*o - c*f*i*p + b*g*i*p +
	c*e*j*p - a*g*j*p - b*e*k*p + a*f*k*p;
  
  if (det == 0) {
    fprintf( stderr, "Cannot invert matrix!\n" );
    matrix_copy( IdentityMatrix, 4, m2 );
    return;
  }

  m2[0][0] = (-(h*k*n) + g*l*n + h*j*o - f*l*o - g*j*p + f*k*p) / det;
  m2[1][0] = (d*k*n - c*l*n - d*j*o + b*l*o + c*j*p - b*k*p) / det;
  m2[2][0] = (-(d*g*n) + c*h*n + d*f*o - b*h*o - c*f*p + b*g*p) / det;
  m2[3][0] = (d*g*j - c*h*j - d*f*k + b*h*k + c*f*l - b*g*l) / det;
  m2[0][1] = (h*k*m - g*l*m - h*i*o + e*l*o + g*i*p - e*k*p) / det;
  m2[1][1] = (-(d*k*m) + c*l*m + d*i*o - a*l*o - c*i*p + a*k*p) / det;
  m2[2][1] = (d*g*m - c*h*m - d*e*o + a*h*o + c*e*p - a*g*p) / det;
  m2[3][1] = (-(d*g*i) + c*h*i + d*e*k - a*h*k - c*e*l + a*g*l) / det;
  m2[0][2] = (-(h*j*m) + f*l*m + h*i*n - e*l*n - f*i*p + e*j*p) / det;
  m2[1][2] = (d*j*m - b*l*m - d*i*n + a*l*n + b*i*p - a*j*p) / det;
  m2[2][2] = (-(d*f*m) + b*h*m + d*e*n - a*h*n - b*e*p + a*f*p) / det;
  m2[3][2] = (d*f*i - b*h*i - d*e*j + a*h*j + b*e*l - a*f*l) / det;
  m2[0][3] = (g*j*m - f*k*m - g*i*n + e*k*n + f*i*o - e*j*o) / det;
  m2[1][3] = (-(c*j*m) + b*k*m + c*i*n - a*k*n - b*i*o + a*j*o) / det;
  m2[2][3] = (c*f*m - b*g*m - c*e*n + a*g*n + b*e*o - a*f*o) / det;
  m2[3][3] = (-(c*f*i) + b*g*i + c*e*j - a*g*j - b*e*k + a*f*k) / det;
}
