/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/

//
// Code to generate the least squares plane for a collection of points
//


#include "misLeastSquaresPlane.H"
#include "misCoord.h"
#include "misGaussPivot.H"


/*

   We want to minize the least squares (l2) approximation of a plane
   from a collection of points.

                    m
                  -----
		   \
   phi(a,b,c,d) =   >  (ax(k)+by(k)+cz(k)-1)^2
                   /
		  -----
                  k = 1

   Goal: minimize phi.

   Solve: Mp = e.
*/

void LeastSquaresPlanarFit( VRPointData *pd, coord *r )
{
  int i, j;
  int n=3;

  double **M = new double*[n];
  for (i=0; i<n; i++)
    M[i] = new double[n];
  double *e = new double[n];
  double *p = new double[n];

  for (i=0; i<n; i++) {
    for (j=0; j<n; j++)
      M[i][j] = 0.0;
    e[i] = 0.0;
  }

  for (i=0; i<pd->nPoints; i++) {

    M[0][0] += pd->point[i].x * pd->point[i].x;
    M[0][1] += pd->point[i].x * pd->point[i].y;
    M[0][2] += pd->point[i].x * pd->point[i].z;

    M[1][0] += pd->point[i].x * pd->point[i].y;
    M[1][1] += pd->point[i].y * pd->point[i].y;
    M[1][2] += pd->point[i].y * pd->point[i].z;

    M[2][0] += pd->point[i].x * pd->point[i].z;
    M[2][1] += pd->point[i].y * pd->point[i].z;
    M[2][2] += pd->point[i].z * pd->point[i].z;

    e[0] += pd->point[i].x;
    e[1] += pd->point[i].y;
    e[2] += pd->point[i].z;
  }

  GaussPivotSolve(M, p, e, n);

  r->x = p[0];
  r->y = p[1];
  r->z = p[2];
  coord_normalize(*r, *r);

  for (i=0; i<n; i++)
    delete[] M[i];
  delete[] M;
  delete[] e;
  delete[] p;
}
