/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/

//
// The main window of the volume renderer
//


#include "cppArgs.h"

#include <math.h>

#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/Frame.h>
#include <Xm/Scale.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/Text.h>
#include <Sgm/SpringBox.h>

#include <Vk/VkApp.h>
#include <Vk/VkMenu.h>
#include <Vk/VkMenuBar.h>
#include <Vk/VkRadioSubMenu.h>
#include <Vk/VkMenuItem.h>

#include "hciMainWindow.H"
#include "hciUpdateScreen.h"
#include "genSetup.H"
#include "genWindowMaint.h"
#include "misTransferFunc.h"

#include "volInit.h"
#include "volGeomUtils.h"


String MainWindow::defaultResources[] = {
  // General window resources
  "*windowTitle:                        Volume Renderer",
  "*iconTitle:                          Volume Renderer",
  "*foreground:                         black",
  "*XmToggleButton.indicatorSize:       10",
  "*XmToggleButtonGadget.indicatorSize: 10",

  "*accelerators:                       <Key>: HandleKeyPress()",
  "*traversalOn:                        false",
  "*useOverlayMenus:                    true",

  "-.volren*menuBar*fontList:            -*-helvetica-bold-o-*-14-*",
  "-.volren*XmLabel*fontList:            -*-helvetica-bold-r-*-10-*",
  "-.volren*XmText*fontList:             -*-helvetica-bold-r-*-10-*",
  "-.volren*buttonForm*XmLabel*fontList: -*-helvetica-medium-r-*-12-*",
  "-.volren*XmPushButton*fontList:       -*-helvetica-medium-r-*-8-*",
  "-.volren*slideForm*XmLabel*fontList:  -*-helvetica-medium-r-*-8-*",

  // All scales
  "*XmScale.minimum:                    0",
  "*XmScale.maximum:                    800",
  "*XmScale.scaleMultiple:              10",

  // All springbox children
  "*SgSpringBox*topSpring:              0",
  "*SgSpringBox*bottomSpring:           0",
  "*SgSpringBox*rightSpring:            0",
  "*SgSpringBox*leftSpring:             0",

  // Menu resources
  "*fileresetbut.labelString:           Reset State",
  "*fileresetbut.acceleratorText:       ?",
  "*filerereadbut.labelString:          Reread Data",
  "*filerereadbut.acceleratorText:      r",
  "*filesnapbut.labelString:            Snap Image",
  "*filesnapbut.acceleratorText:        *",
  "*winTiedMenu.labelString:            New Tied Window",
  "*winUntiedMenu.labelString:          New Untied Window",
  "*winTiedItem.labelString:            New Tied Window",
  "*winUntiedItem.labelString:          New Untied Window",
  "*optionmenu.labelString:             Option",
  "*renderoptionmenu.labelString:       Rendering",
  "*renderresbut.labelString:           High Resolution",
  "*renderresbut.acceleratorText:       h",
  "*rendersterbut.labelString:          Stereo",
  "*rendersterbut.acceleratorText:      :",
  "*renderperspbut.labelString:         Perspective",
  "*renderperspbut.acceleratorText:     p",
  "*blendoptionmenu.labelString:        Blending",
  "*blendoverbut.labelString:           Over",
  "*blendoverbut.acceleratorText:       b",
  "*blendmipbut.labelString:            MIP",
  "*blendmipbut.acceleratorText:        b",
  "*volumeoptionmenu.labelString:       Volume",
  "*volcolorbut.labelString:            Colored",
  "*volcolorbut.acceleratorText:        O",
  "*volinterpbut.labelString:           Interpolated",
  "*volinterpbut.acceleratorText:       I",
  "*volcmapbut.labelString:             Modulate Colormap",
  "*volcmapbut.acceleratorText:         C",
  "*volamapbut.labelString:             Modulate Alphamap",
  "*volamapbut.acceleratorText:         A",
  "*surfaceoptionmenu.labelString:      Surface",
  "*surfgenbut.labelString:             Generate",
  "*surfgenbut.acceleratorText:         g",
  "*surflightbut.labelString:           Lighted",
  "*surflightbut.acceleratorText:       L",
  "*surfmeshbut.labelString:            Meshed",
  "*surfmeshbut.acceleratorText:        M",
  "*surftexbut.labelString:             Textured",
  "*surftexbut.acceleratorText:         X",
  "*miscoptionmenu.labelString:         Misc.",
  "*miscpntbut.labelString:             Interactive Points",
  "*miscpntbut.acceleratorText:         N",
  "*miscsliderbut.labelString:          Interactive Sliders",
  "*miscsliderbut.acceleratorText:      S",
  "*misc4bitbut.labelString:            Use 4-bit Data",
  "*misc4bitbut.acceleratorText:        D",
  "*miscclipbut.labelString:            Clip Geometry",
  "*miscclipbut.acceleratorText:        G",
  "*miscloopbut.labelString:            Clip Plane Looping",
  "*miscloopbut.acceleratorText:        l",
  "*miscdbbut.labelString:              Double Buffering",
  "*miscdbbut.acceleratorText:          d",
  "*enablemenu.labelString:             Enable",
  "*objenablemenu.labelString:          Enable Objects",
  "*objvolbut.labelString:              Volumes",
  "*objvolbut.acceleratorText:          v",
  "*objelevbut.labelString:             Elevations",
  "*objelevbut.acceleratorText:         e",
  "*objsurfbut.labelString:             Surfaces",
  "*objsurfbut.acceleratorText:         s",
  "*objpntbut.labelString:              Points",
  "*objpntbut.acceleratorText:          n",
  "*objclipbut.labelString:             Clip Planes",
  "*objclipbut.acceleratorText:         c",
  "*objtextbut.labelString:             Text",
  "*objtextbut.acceleratorText:         t",
  "*objvecbut.labelString:              Arrows",
  "*objvecbut.acceleratorText:          a",
  "*objframebut.labelString:            Frames",
  "*objframebut.acceleratorText:        f",
  "*volenablemenu.labelString:          Enable Volumes",
  "*surfenablemenu.labelString:         Enable Surfaces",
  "*clipenablemenu.labelString:         Enable Clip Planes",
  "*selectmenu.labelString:             Select",
  "*volselectmenu.labelString:          Select Volume",
  "*surfselectmenu.labelString:         Select Surface",
  "*clipselectmenu.labelString:         Select Clip Plane",
  "*rendermenu.labelString:             Render",
  "*funcmenu.labelString:               Transfer",
  "*cmapmenu.labelString:               Colormap",
  "*amapmenu.labelString:               Alphamap",

  // Main form layout resources
  "*mainForm.orientation:               XmVERTICAL",
  "*mainForm.horizontalSpacing:         5",
  "*mainForm.verticalSpacing:           5",
  "*mainForm.marginWidth:               5",
  "*mainForm.marginHeight:              5",
  "*mainForm*XmFrame.shadowType:        XmSHADOW_IN",

  // Top form layout resources
  "*topForm.orientation:                XmHORIZONTAL",
  "*topForm.horizontalSpring:           1",
  "*topForm.verticalSpring:             1",
  "*topForm.horizontalSpacing:          5",
  "*topForm.verticalSpacing:            5",
  "*topForm.marginWidth:                0",
  "*topForm.marginHeight:               0",

  // Render window resources
  "*winFrame.horizontalSpring:          1",
  "*winFrame.verticalSpring:            1",
  "*renderWindow.traversalOn:           true",

  // Tlut form resources
  "*tlutForm.orientation:               XmVERTICAL",
  "*tlutForm.horizontalSpring:          0",
  "*tlutForm.verticalSpring:            1",
  "*tlutForm.horizontalSpacing:         5",
  "*tlutForm.verticalSpacing:           5",
  "*tlutForm.marginWidth:               0",
  "*tlutForm.marginHeight:              0",

  // Tlut window resources
  "*tlutFrame.horizontalSpring:         1",

  // Button layout resources
  "*buttonFrame.horizontalSpring:       1",
  "*buttonForm.marginWidth:             2",
  "*buttonForm.marginHeight:            2",
  "*buttonForm.XmPushButton.horizontalSpring: 1",
  "*buttonForm.XmPushButton.alignment:  XmALIGNMENT_CENTER",
  "*addLabel.labelString:               *",
  "*equalLabel.labelString:             =",
  "*camapButton.labelString:            Color / Alpha",
  "*tfuncButton.labelString:            Transfer",
  "*lookupButton.labelString:           Lookup",

  // Slider layout resources
  "*slideFrame.horizontalSpring:        1",
  "*slideFrame.verticalSpring:          1",
  "*slideForm.orientation:              XmVERTICAL",
  "*slideForm.marginWidth:              2",
  "*slideForm.marginHeight:             2",
  "*sliderForm.orientation:             XmHORIZONTAL",
  "*sliderForm.horizontalSpring:        1",
  "*sliderForm.verticalSpring:          1",
  "*labelForm.orientation:              XmHORIZONTAL",
  "*labelForm.packing:                  XmPACK_COLUMN",
  "*labelForm.adjustLast:               false",
  "*labelForm.isAligned:                true",
  "*labelForm.entryAlignment:           XmALIGNMENT_CENTER",
  "*labelForm.spacing:                  0",
  "*labelForm.marginWidth:              0",
  "*labelForm.marginHeight:             0",

  // Label and slider form layout resources
  "*sliderForm.XmScale.verticalSpring:  1",
  "*sliderForm.XmScale.scaleWidth:      28",
  "*labelForm.XmLabel.recomputeSize:    false",
  "*labelForm.XmLabel.width:            49",
  "*s1Label.labelString:                Window",
  "*s2Label.labelString:                Level",
  "*s3Label.labelString:                Center",
  "*s4Label.labelString:                ",

  // Parameter resources
  "*parFrame.horizontalSpring:          1",
  "*parForm.orientation:                XmVERTICAL",
  "*parForm.marginWidth:                5",
  "*parForm.marginHeight:               5",

  // Volume delay parameter resources
  "*delayForm.horizontalSpring:         1",
  "*delayForm.XmLabel.labelString:      Volume Animation Delay:",
  "*delayForm*XmScale.orientation:      XmHORIZONTAL",
  "*delayForm*XmScale.horizontalSpring: 1",

  // Render parameter resources
  "*renderForm.SgSpringBox.horizontalSpring: 1",
  "*renderForm*XmScale.orientation:     XmHORIZONTAL",
  "*renderForm*XmScale.horizontalSpring: 1",
  "*sepLabel.labelString:               Stereo Separation:",
  "*fovLabel.labelString:               Field of View:",

  // Status parameter resources
  "*statusForm.orientation:             XmHORIZONTAL",
  "*statusForm*XmText.marginHeight:     2",
  "*statusText.autoShowCursorPosition:  False",
  "*statusText.editable:                False",
  "*statusText.cursorPositionVisible:   False",
  "*statusText.traversalOn:             False",
  "*statusText.horizontalSpring:        1",
  "*sliceText.columns:                  5",
  "*sliceLabel.labelString:             Slices:",

  NULL
};


VkMenuDesc MainWindow::menuPaneDesc[] = {
  { SUBMENU, "File", NULL, MainWindow::fileMenuDesc },
  { END }
};

VkMenuDesc MainWindow::fileMenuDesc[] = {
  { ACTION,  "Close", &MainWindow::CloseWindowCallback },
  { ACTION,  "Exit", &MainWindow::ExitCallback },
  { END }
};


MainWindow::MainWindow(const char *name, VRState *_state)
  : VkWindow(name), state(_state)
{
  // Set the default resources for the window
  setDefaultResources(mainWindowWidget(), defaultResources);

  // Create the main vertical springbox
  mainForm = XtCreateWidget("mainForm", sgSpringBoxWidgetClass, mainWindowWidget(),
			    NULL, 0);

  // Create the top horizontal springbox
  topForm = XtCreateManagedWidget("topForm", sgSpringBoxWidgetClass, mainForm,
				  NULL, 0);

    // Create the window frame
    winFrame = XtCreateManagedWidget("winFrame", xmFrameWidgetClass, topForm, NULL, 0);

        // Create the render window component, in RGB/Double mode
        if (state->world->allowStereoMode)
	  renderWindow = new RenderWindow("renderwindow", winFrame,
					  GLXWindow::StereoRGBDouble, this, state);
        else
	  renderWindow = new RenderWindow("renderwindow", winFrame,
					  GLXWindow::MonoRGBDouble, this, state);
        renderWindow->show();
  
    // Create the side form
    tlutForm = XtCreateManagedWidget("tlutForm", sgSpringBoxWidgetClass, topForm, NULL, 0);

      tlutFrame = XtCreateManagedWidget("tlutFrame", xmFrameWidgetClass, tlutForm,
					NULL, 0);

        tlutWindow = new TlutWindow("tlutwindow", tlutFrame, GLXWindow::MonoRGBDouble,
				    this, state);
        tlutWindow->show();

      // Create the button frame
      buttonFrame = XtCreateManagedWidget("buttonFrame", xmFrameWidgetClass, tlutForm,
					  NULL, 0);

        // Create the button form
        buttonForm = XtCreateManagedWidget("buttonForm", sgSpringBoxWidgetClass, buttonFrame,
					   NULL, 0);

          // Create the transfer function button
          tfuncButton = XtCreateManagedWidget("tfuncButton", xmPushButtonWidgetClass, buttonForm,
					      NULL, 0);

          // Create the add label
          addLabel = XtCreateManagedWidget("addLabel", xmLabelWidgetClass, buttonForm,
					   NULL, 0);

          // Create the color/alphamap button
          camapButton = XtCreateManagedWidget("camapButton", xmPushButtonWidgetClass, buttonForm,
					      NULL, 0);

          // Create the equal label
          equalLabel = XtCreateManagedWidget("equalLabel", xmLabelWidgetClass, buttonForm,
					     NULL, 0);

          // Create the lookup button
          lookupButton = XtCreateManagedWidget("lookupButton", xmPushButtonWidgetClass, buttonForm,
					       NULL, 0);

      // Create the slider frame
      slideFrame = XtCreateManagedWidget("slideFrame", xmFrameWidgetClass, tlutForm,
					 NULL, 0);

        // Create the slider horizontal row column
        slideForm = XtCreateManagedWidget("slideForm", sgSpringBoxWidgetClass, slideFrame,
  				       NULL, 0);

          // Create the slider springbox
          sliderForm = XtCreateManagedWidget("sliderForm", sgSpringBoxWidgetClass, slideForm,
					     NULL, 0);
  
            // Create the first slider
            s1Slider = XtCreateManagedWidget("s1Slider", xmScaleWidgetClass, sliderForm,
					     NULL, 0);
  
            // Create the second slider
            s2Slider = XtCreateManagedWidget("s2Slider", xmScaleWidgetClass, sliderForm,
  					   NULL, 0);
    
            // Create the third slider
            s3Slider = XtCreateManagedWidget("s3Slider", xmScaleWidgetClass, sliderForm,
  					   NULL, 0);
    
            // Create the fourth slider
            s4Slider = XtCreateManagedWidget("s4Slider", xmScaleWidgetClass, sliderForm,
  					   NULL, 0);
  
          // Create the slider springbox
          labelForm = XtCreateManagedWidget("labelForm", xmRowColumnWidgetClass, slideForm,
					    NULL, 0);
  
            // Create the first slider label
            s1Label = XtCreateManagedWidget("s1Label", xmLabelWidgetClass, labelForm,
					    NULL, 0);
  
            // Create the second slider label
            s2Label = XtCreateManagedWidget("s2Label", xmLabelWidgetClass, labelForm,
					    NULL, 0);
  
            // Create the third slider label
            s3Label = XtCreateManagedWidget("s3Label", xmLabelWidgetClass, labelForm,
					    NULL, 0);
  
            // Create the fourth slider label
            s4Label = XtCreateManagedWidget("s4Label", xmLabelWidgetClass, labelForm,
					    NULL, 0);

    // Create the parameter slider frame
    parFrame = XtCreateManagedWidget("parFrame", xmFrameWidgetClass, mainForm,
				     NULL, 0);
  
      // Create the parameter slider vertical row column
      parForm = XtCreateManagedWidget("parForm", xmRowColumnWidgetClass, parFrame,
				     NULL, 0);

        if (state->world->timeVariantVolumes) {
	  // Create the time delay slider form
	  delayForm = XtCreateManagedWidget("delayForm", sgSpringBoxWidgetClass, parForm,
					    NULL, 0);
    
  	    // Create the time delay label
	    delayLabel = XtCreateManagedWidget("delayLabel", xmLabelWidgetClass, delayForm,
					       NULL, 0);

	    // Create the time delay slider
	    delaySlider = XtCreateManagedWidget("delaySlider", xmScaleWidgetClass, delayForm,
						NULL, 0);
	}
      
        // Create the parameter slider vertical row column
        renderForm = XtCreateManagedWidget("renderForm", sgSpringBoxWidgetClass, parForm,
					  NULL, 0);
  
          // Create field of view form
          fovForm = XtCreateManagedWidget("fovForm", sgSpringBoxWidgetClass, renderForm,
					  NULL, 0);

            // Create the field of view label
            fovLabel = XtCreateManagedWidget("fovLabel", xmLabelWidgetClass, fovForm,
					     NULL, 0);

            // Create the field of view slider
            fovSlider = XtCreateManagedWidget("fovSlider", xmScaleWidgetClass, fovForm,
					      NULL, 0);
      
          // Create stereo separation form
          sepForm = XtCreateManagedWidget("sepForm", sgSpringBoxWidgetClass, renderForm,
					  NULL, 0);

            // Create the separation slider label
            sepLabel = XtCreateManagedWidget("sepLabel", xmLabelWidgetClass, sepForm,
					     NULL, 0);
    
            // Create the separation slider
            sepSlider = XtCreateManagedWidget("sepSlider", xmScaleWidgetClass, sepForm,
					      NULL, 0);

        // Create the parameter text vertical row column
        statusForm = XtCreateManagedWidget("statusForm", sgSpringBoxWidgetClass, parForm,
					   NULL, 0);

          // Create the frames per second text
          statusText = XtCreateManagedWidget("statusText", xmTextWidgetClass, statusForm,
					     NULL, 0);

          // Create the slice count label
          sliceLabel = XtCreateManagedWidget("sliceLabel", xmLabelWidgetClass, statusForm,
					     NULL, 0);

          // Create the slice count text
          sliceText = XtCreateManagedWidget("sliceText", xmTextWidgetClass, statusForm,
					    NULL, 0);

  // Add thbe buttons to the button group
  sliderGroup.add(tfuncButton);
  sliderGroup.add(camapButton);
  sliderGroup.add(lookupButton);

  // Center the labels
  SetValue(addLabel, XmNtopSpring, (XtArgVal) 1);
  SetValue(addLabel, XmNbottomSpring, (XtArgVal) 1);
  SetValue(equalLabel, XmNtopSpring, (XtArgVal) 1);
  SetValue(equalLabel, XmNbottomSpring, (XtArgVal) 1);

  // Center the sliders
  SetValue(s1Slider, XmNrightSpring, (XtArgVal) 1);
  SetValue(s1Slider, XmNleftSpring, (XtArgVal) 1);
  SetValue(s2Slider, XmNrightSpring, (XtArgVal) 1);
  SetValue(s2Slider, XmNleftSpring, (XtArgVal) 1);
  SetValue(s3Slider, XmNrightSpring, (XtArgVal) 1);
  SetValue(s3Slider, XmNleftSpring, (XtArgVal) 1);
  SetValue(s4Slider, XmNrightSpring, (XtArgVal) 1);
  SetValue(s4Slider, XmNleftSpring, (XtArgVal) 1);
  
  // Center the labels
  SetValue(s1Label, XmNhorizontalSpring, (XtArgVal) 1);
  SetValue(s2Label, XmNhorizontalSpring, (XtArgVal) 1);
  SetValue(s3Label, XmNhorizontalSpring, (XtArgVal) 1);
  SetValue(s4Label, XmNhorizontalSpring, (XtArgVal) 1);

  // Center the labels
  if (state->world->timeVariantVolumes) {
    SetValue(delayLabel, XmNtopSpring, (XtArgVal) 1);
    SetValue(delayLabel, XmNbottomSpring, (XtArgVal) 1);
  }
  SetValue(sepLabel, XmNtopSpring, (XtArgVal) 1);
  SetValue(sepLabel, XmNbottomSpring, (XtArgVal) 1);
  SetValue(fovLabel, XmNtopSpring, (XtArgVal) 1);
  SetValue(fovLabel, XmNbottomSpring, (XtArgVal) 1);
  SetValue(sliceLabel, XmNtopSpring, (XtArgVal) 1);
  SetValue(sliceLabel, XmNbottomSpring, (XtArgVal) 1);
  
  // Setup the button callbacks
  //
  // We create a structure to hold the button index and the this pointer
  // so that one callback can handle all the buttons.  This avoids having
  // a static callback and a member callback function for each button.

  int buttonCount = 3;
  smcs = new IndexCallbackStruct[buttonCount];
  for (int i=0; i<buttonCount; i++) {
    smcs[i]._this = this;
    smcs[i].index = i;
  }

  XtAddCallback(tfuncButton, XmNactivateCallback, &MainWindow::SliderModeCallback,
		(XtPointer) &smcs[0]);
  XtAddCallback(camapButton, XmNactivateCallback, &MainWindow::SliderModeCallback,
		(XtPointer) &smcs[1]);
  XtAddCallback(lookupButton, XmNactivateCallback, &MainWindow::SliderModeCallback,
		(XtPointer) &smcs[2]);

  // Setup the slider callbacks
  //
  // We create a structure to hold the slider index and the this pointer
  // so that one callback can handle all the sliders.  This avoids having
  // a static callback and a member callback function for each slider.

  int sliderCount = 4;
  sccs = new IndexCallbackStruct[sliderCount];
  for (i=0; i<sliderCount; i++) {
    sccs[i]._this = this;
    sccs[i].index = i;
  }

  XtAddCallback(s1Slider, XmNvalueChangedCallback, &MainWindow::SliderChangeCallback,
		(XtPointer) &sccs[0]);
  XtAddCallback(s2Slider, XmNvalueChangedCallback, &MainWindow::SliderChangeCallback,
		(XtPointer) &sccs[1]);
  XtAddCallback(s3Slider, XmNvalueChangedCallback, &MainWindow::SliderChangeCallback,
		(XtPointer) &sccs[2]);
  XtAddCallback(s4Slider, XmNvalueChangedCallback, &MainWindow::SliderChangeCallback,
		(XtPointer) &sccs[3]);

  XtAddCallback(s1Slider, XmNdragCallback, &MainWindow::SliderDragCallback,
		(XtPointer) &sccs[0]);
  XtAddCallback(s2Slider, XmNdragCallback, &MainWindow::SliderDragCallback,
		(XtPointer) &sccs[1]);
  XtAddCallback(s3Slider, XmNdragCallback, &MainWindow::SliderDragCallback,
		(XtPointer) &sccs[2]);
  XtAddCallback(s4Slider, XmNdragCallback, &MainWindow::SliderDragCallback,
		(XtPointer) &sccs[3]);

  // Setup parameter slider callbacks

  if (state->world->timeVariantVolumes) {
    XtAddCallback(delaySlider, XmNvalueChangedCallback, &MainWindow::DelayChangeCallback,
		  (XtPointer) this);
    XtAddCallback(delaySlider, XmNdragCallback, &MainWindow::DelayChangeCallback,
		  (XtPointer) this);
  }

  XtAddCallback(sepSlider, XmNvalueChangedCallback, &MainWindow::SeparationChangeCallback,
		(XtPointer) this);
  XtAddCallback(sepSlider, XmNdragCallback, &MainWindow::SeparationChangeCallback,
		(XtPointer) this);

  XtAddCallback(fovSlider, XmNvalueChangedCallback, &MainWindow::FovChangeCallback,
		(XtPointer) this);
  XtAddCallback(fovSlider, XmNdragCallback, &MainWindow::FovChangeCallback,
		(XtPointer) this);

  // Setup the time cycle timeouts for any time variant volumes
  tvcs = new IndexCallbackStruct[state->world->nVols];

  for (int v=0; v<state->world->nVols; v++) {
    tvcs[v]._this = this;
    tvcs[v].index = v;
  }

  // Setup the slice count text widget callbacks
  XtAddCallback(sliceText, XmNlosingFocusCallback, &MainWindow::SliceLoseFocusCallback,
		(XtPointer) this);
  XtAddCallback(sliceText, XmNactivateCallback, &MainWindow::SliceActivateCallback,
		(XtPointer) this);

  // Assign the main view widget
  addView(mainForm);

  // Create the menu bar and associated widgets
  // The default client data for all elements in the menus is the this pointer
  menuBar = new VkMenuBar(menuPaneDesc, (XtPointer) this, False);
  setMenuBar(menuBar);

  // Set the window and icon titles
  setTitle("windowTitle");
  setIconName("iconTitle");

  // Setup the keypress action handler
  static XtActionsRec actions[] = {
    { "HandleKeyPress", &MainWindow::HandleKeyPressCallback }
  };
  XtAppAddActions(theApplication->appContext(), actions, XtNumber(actions));

  oecs = NULL;
  vecs = NULL;
  vscs = NULL;
  secs = NULL;
  sscs = NULL;
  cecs = NULL;
  cscs = NULL;

  rccs = NULL;
  tccs = NULL;
  cccs = NULL;
  accs = NULL;
}


MainWindow::~MainWindow()
{
  sliderGroup.remove(tfuncButton);
  sliderGroup.remove(camapButton);
  sliderGroup.remove(lookupButton);

  // Free the memory used by the button callback structures
  delete [] nwcs;
  delete [] kccs;
  delete [] sccs;

  if (fkcs)
    delete [] fkcs;

  if (oecs)
    delete [] oecs;
  if (vecs)
    delete [] vecs;
  if (vscs)
    delete [] vscs;
  if (secs)
    delete [] secs;
  if (sscs)
    delete [] sscs;
  if (cecs)
    delete [] cecs;
  if (cscs)
    delete [] cscs;

  if (rccs)
    delete [] rccs;
  if (tccs)
    delete [] tccs;
  if (cccs)
    delete [] cccs;
  if (accs)
    delete [] accs;
}


const char* MainWindow::className()
{
  return( "MainWindow" );
}


void MainWindow::ReadyToGo()
{
  InstallDynamicMenus();

  // Update the slices text field
  char buf[64];
  sprintf(buf, "%d", state->view->slices);

  SetValue(sliceText, XmNvalue, (XtArgVal) &buf);

  UpdateState();
}


void MainWindow::Reset( VRState *_state )
{
  state = _state;

  RemoveDynamicMenus();
}


void MainWindow::UpdateStatusMessage(char *msg)
{
  char buf[128];

  if (msg)
    strcpy(state->world->msg, msg);

  sprintf(buf, "%s", msg);

  SetValue(statusText, XmNvalue, (XtArgVal) buf);
}


void MainWindow::UpdateState()
{
  ResetMenuValues();
  ResetSliderValues();
  ResetParameterValues();
  tlutWindow->Redraw();

  // Start up any volume timers that aren't running
  if (!state->world->initing)
    for (int v=0; v<state->world->nVols; v++)
      if (state->volumeData[v]->tRes > 1)
	if (state->volumeData[v]->timerId == 0)
	  TimeCycleVolumeCallback(&tvcs[v], (XtIntervalId*) 0);
}


void MainWindow::ResetMenuValues()
{
  int i, count;

  // Update the rendering option menu
  count=0;
  ((VkMenuToggle*) ((*renderOptionMenu)[count++]))->setVisualState(state->mode->pixelRes);
  if (state->world->allowStereoMode)
    ((VkMenuToggle*) ((*renderOptionMenu)[count]))->activate();
  else
    ((VkMenuToggle*) ((*renderOptionMenu)[count]))->deactivate();
  ((VkMenuToggle*) ((*renderOptionMenu)[count++]))->setVisualState(state->world->stereoMode);
  ((VkMenuToggle*) ((*renderOptionMenu)[count++]))->setVisualState(state->mode->perspMode);

  if (state->mode->mipMode) {
    ((VkMenuToggle*) ((*blendOptionMenu)[0]))->setVisualState(FALSE);
    ((VkMenuToggle*) ((*blendOptionMenu)[1]))->setVisualState(TRUE);
  } else {
    ((VkMenuToggle*) ((*blendOptionMenu)[0]))->setVisualState(TRUE);
    ((VkMenuToggle*) ((*blendOptionMenu)[1]))->setVisualState(FALSE);
  }    

  // Update the volume option menu
  count=0;
  if (state->view->curVol == -1) {
    ((VkMenuToggle*) ((*volumeOptionMenu)[count++]))->deactivate();
    ((VkMenuToggle*) ((*volumeOptionMenu)[count++]))->deactivate();
    ((VkMenuToggle*) ((*volumeOptionMenu)[count++]))->deactivate();
    ((VkMenuToggle*) ((*volumeOptionMenu)[count++]))->deactivate();
  } else {
    VRVolumeData *vd = state->volumeData[state->view->curVol];
    ((VkMenuToggle*) ((*volumeOptionMenu)[count]))->activate();
    ((VkMenuToggle*) ((*volumeOptionMenu)[count++]))->setVisualState(vd->drawColor);
    ((VkMenuToggle*) ((*volumeOptionMenu)[count]))->activate();
    ((VkMenuToggle*) ((*volumeOptionMenu)[count++]))->setVisualState(vd->drawInterp);
    ((VkMenuToggle*) ((*volumeOptionMenu)[count]))->activate();
    ((VkMenuToggle*) ((*volumeOptionMenu)[count++]))->setVisualState(vd->modCmap);
    ((VkMenuToggle*) ((*volumeOptionMenu)[count]))->activate();
    ((VkMenuToggle*) ((*volumeOptionMenu)[count++]))->setVisualState(vd->modAmap);
  }

  // Update the surface option menu
  count=0;
  if (state->view->curSurf == -1) {
    ((VkMenuToggle*) ((*surfaceOptionMenu)[count++]))->deactivate();
    ((VkMenuToggle*) ((*surfaceOptionMenu)[count++]))->deactivate();
    ((VkMenuToggle*) ((*surfaceOptionMenu)[count++]))->deactivate();
    ((VkMenuToggle*) ((*surfaceOptionMenu)[count++]))->deactivate();
  } else {
    VRSurfaceData *vd = state->surfaceData[state->view->curSurf];
    ((VkMenuToggle*) ((*surfaceOptionMenu)[count++]))->activate();
    // No visual state for generate surface action button
    ((VkMenuToggle*) ((*surfaceOptionMenu)[count]))->activate();
    ((VkMenuToggle*) ((*surfaceOptionMenu)[count++]))->setVisualState(vd->drawLighted);
    ((VkMenuToggle*) ((*surfaceOptionMenu)[count]))->activate();
    ((VkMenuToggle*) ((*surfaceOptionMenu)[count++]))->setVisualState(vd->drawMeshed);
    ((VkMenuToggle*) ((*surfaceOptionMenu)[count]))->activate();
    ((VkMenuToggle*) ((*surfaceOptionMenu)[count++]))->setVisualState(vd->drawTextured);
  }

  // Update miscellaneous option menu
  count=0;
  ((VkMenuToggle*) ((*miscOptionMenu)[count++]))->setVisualState(state->mode->iaSurfMode);
  ((VkMenuToggle*) ((*miscOptionMenu)[count++]))->setVisualState(state->mode->iaSliderMode);
  if (state->world->define4BitBricks)
    ((VkMenuToggle*) ((*miscOptionMenu)[count++]))->setVisualState(state->mode->brickRes);
  ((VkMenuToggle*) ((*miscOptionMenu)[count++]))->setVisualState(state->mode->clipGeomMode);
  ((VkMenuToggle*) ((*miscOptionMenu)[count++]))->setVisualState(state->mode->loopMode);
  ((VkMenuToggle*) ((*miscOptionMenu)[count++]))->setVisualState(state->mode->frontbufMode);

  // Update the object enable menu
  count=0;
  ((VkMenuToggle*) ((*objEnableMenu)[count++]))->setVisualState(state->mode->volumeMode);
  if (state->world->nElevs)
    ((VkMenuToggle*) ((*objEnableMenu)[count++]))->setVisualState(state->mode->elevMode);
  ((VkMenuToggle*) ((*objEnableMenu)[count++]))->setVisualState(state->mode->surfaceMode);
  ((VkMenuToggle*) ((*objEnableMenu)[count++]))->setVisualState(state->mode->pointsMode);
  ((VkMenuToggle*) ((*objEnableMenu)[count++]))->setVisualState(state->mode->sliceMode);
  ((VkMenuToggle*) ((*objEnableMenu)[count++]))->setVisualState(state->mode->textMode);
  ((VkMenuToggle*) ((*objEnableMenu)[count++]))->setVisualState(state->mode->vectorMode);
  ((VkMenuToggle*) ((*objEnableMenu)[count++]))->setVisualState(state->mode->frameMode);

  // Update the volume enable menu
  for (i=0; i<state->world->nVols; i++)
    ((VkMenuToggle*) ((*volEnableMenu)[i]))->setVisualState(state->volumeData[i]->active);

  // Update the surface enable menu
  for (i=0; i<MAX_SURFS; i++)
    ((VkMenuToggle*) ((*surfEnableMenu)[i]))->setVisualState(state->surfaceData[i]->active);

  // Update the clip plane enable menu
  for (i=0; i<state->world->nPlanes; i++)
    ((VkMenuToggle*) ((*clipEnableMenu)[i]))->setVisualState(state->planeData->plane[i].active);

  // Update the volume select menu
  ((VkMenuToggle*) ((*volSelectMenu)[0]))->setVisualState(state->view->curVol == -1);
  for (i=0; i<state->world->nVols; i++)
     ((VkMenuToggle*) ((*volSelectMenu)[i+2]))->setVisualState(state->view->curVol == i);

  // Update the surface select menu
  ((VkMenuToggle*) ((*surfSelectMenu)[0]))->setVisualState(state->view->curSurf == -1);
  for (i=0; i<MAX_SURFS; i++)
     ((VkMenuToggle*) ((*surfSelectMenu)[i+2]))->setVisualState(state->view->curSurf == i);

  // Update the clip plane select menu
  ((VkMenuToggle*) ((*clipSelectMenu)[0]))->setVisualState(state->view->curPlane == -1);
  for (i=0; i<state->world->nPlanes; i++)
     ((VkMenuToggle*) ((*clipSelectMenu)[i+2]))->setVisualState(state->view->curPlane == i);

  if (state->world->magicExtensions) {
    // Update the render menu
    int r=0;
    for (i=0; i<MAX_RMODES; i++) {
      if (state->world->allowRenderMode[i]) {
	VkMenuToggle *render = (VkMenuToggle*) ((*renderMenu)[r++]);
	render->setVisualState(state->mode->renderMode == i);
      }
    }
  }

  // Update the transfer function menu
  int curFunc = -1;

  if (state->view->curVol != -1)
    curFunc = state->volumeData[state->view->curVol]->curFunc;

  if (curFunc != -1)
    funcMenu->activate();
  else
    funcMenu->deactivate();

  for (i=0; i<state->tableData->nFuncs; i++)
    ((VkMenuToggle*) ((*funcMenu)[i]))->setVisualState(curFunc == i);

  // Update the colormap menu
  int curCmap = -1;

  if (state->view->curVol != -1)
    curCmap = state->volumeData[state->view->curVol]->curCmap;

  if ((curFunc != -1) && (state->tableData->func[curFunc].useMap))
    cmapMenu->activate();
  else
    cmapMenu->deactivate();

  for (i=0; i<state->tableData->nColormaps; i++)
    ((VkMenuToggle*) ((*cmapMenu)[i]))->setVisualState(curCmap == i);

  // Update the alphamap menu
  int curAmap = -1;

  if (state->view->curVol != -1)
    curAmap = state->volumeData[state->view->curVol]->curAmap;

  if ((curFunc != -1) && (state->tableData->func[curFunc].useMap))
    amapMenu->activate();
  else
    amapMenu->deactivate();

  for (i=0; i<state->tableData->nAlphamaps; i++)
    ((VkMenuToggle*) ((*amapMenu)[i]))->setVisualState(curAmap == i);
}


void MainWindow::ResetSliderValues()
{
  switch (state->mode->sliderMode) {
  case 0:
    sliderGroup.arm(tfuncButton, NULL);
    break;
  case 1:
    sliderGroup.arm(camapButton, NULL);
    break;
  case 2:
    sliderGroup.arm(lookupButton, NULL);
    break;
  }

  if (state->view->curVol != -1) {

    VRVolumeData *vd = state->volumeData[state->view->curVol];
    TransferFunc *func = &state->tableData->func[vd->curFunc];
    XmString str;

    if (func->useMap) {
      SetValue(tfuncButton, XmNsensitive, TRUE);
      SetValue(camapButton, XmNsensitive, TRUE);
      SetValue(lookupButton, XmNsensitive, TRUE);
    } else {
      SetValue(tfuncButton, XmNsensitive, FALSE);
      SetValue(camapButton, XmNsensitive, FALSE);
      SetValue(lookupButton, XmNsensitive, TRUE);
    }

    switch (state->mode->sliderMode) {
    case 0:
    case 2:
      func = &state->tableData->func[vd->curFunc];
      SetValue(s1Label, XmNlabelString, (XtArgVal)
	       (str = XmStringCreateLocalized(func->slider[0])));
      XmStringFree(str);
      SetValue(s2Label, XmNlabelString, (XtArgVal)
	       (str = XmStringCreateLocalized(func->slider[1])));
      XmStringFree(str);
      SetValue(s3Label, XmNlabelString, (XtArgVal)
	       (str = XmStringCreateLocalized(func->slider[2])));
      XmStringFree(str);
      SetValue(s4Label, XmNlabelString, (XtArgVal)
	       (str = XmStringCreateLocalized(func->slider[3])));
      XmStringFree(str);
      SetValue(s1Slider, XmNvalue,
	       ConvertToSlider(vd->parm[0], func->pmin[0], func->pmax[0]));
      SetValue(s1Slider, XmNsensitive, func->sensitive[0]);
      SetValue(s2Slider, XmNvalue,
	       ConvertToSlider(vd->parm[1], func->pmin[1], func->pmax[1]));
      SetValue(s2Slider, XmNsensitive, func->sensitive[1]);
      SetValue(s3Slider, XmNvalue,
	       ConvertToSlider(vd->parm[2], func->pmin[2], func->pmax[2]));
      SetValue(s3Slider, XmNsensitive, func->sensitive[2]);
      SetValue(s4Slider, XmNvalue,
	       ConvertToSlider(vd->parm[3], func->pmin[3], func->pmax[3]));
      SetValue(s4Slider, XmNsensitive, func->sensitive[3]);
      break;
    case 1:
      func = &state->tableData->cafunc;
      SetValue(s1Label, XmNlabelString, (XtArgVal)
	       (str = XmStringCreateLocalized(func->slider[0])));
      XmStringFree(str);
      SetValue(s2Label, XmNlabelString, (XtArgVal)
	       (str = XmStringCreateLocalized(func->slider[1])));
      XmStringFree(str);
      SetValue(s3Label, XmNlabelString, (XtArgVal)
	       (str = XmStringCreateLocalized(func->slider[2])));
      XmStringFree(str);
      SetValue(s4Label, XmNlabelString, (XtArgVal)
	       (str = XmStringCreateLocalized(func->slider[3])));
      XmStringFree(str);
      SetValue(s1Slider, XmNvalue,
	       ConvertToSlider(vd->caparm[0], func->pmin[0], func->pmax[0]));
      SetValue(s1Slider, XmNsensitive, func->sensitive[0]);
      SetValue(s2Slider, XmNvalue,
	       ConvertToSlider(vd->caparm[1], func->pmin[1], func->pmax[1]));
      SetValue(s2Slider, XmNsensitive, func->sensitive[1]);
      SetValue(s3Slider, XmNvalue,
	       ConvertToSlider(vd->caparm[2], func->pmin[2], func->pmax[2]));
      SetValue(s3Slider, XmNsensitive, func->sensitive[2]);
      SetValue(s4Slider, XmNvalue,
	       ConvertToSlider(vd->caparm[3], func->pmin[3], func->pmax[3]));
      SetValue(s4Slider, XmNsensitive, func->sensitive[3]);
      break;
    }

  } else {

    SetValue(tfuncButton, XmNsensitive, FALSE);
    SetValue(camapButton, XmNsensitive, FALSE);
    SetValue(lookupButton, XmNsensitive, FALSE);

    SetValue(s1Slider, XmNsensitive, FALSE);
    SetValue(s2Slider, XmNsensitive, FALSE);
    SetValue(s3Slider, XmNsensitive, FALSE);
    SetValue(s4Slider, XmNsensitive, FALSE);
  }
}


void MainWindow::ResetParameterValues()
{
  if (state->world->timeVariantVolumes)
    if (state->view->curVol >= 0) {

      VRVolumeData *vd = state->volumeData[state->view->curVol];
      double interval;

      if (vd->timeInterval == 0)
	interval = log10(500000.0);
      else
	interval = log10((double) vd->timeInterval);

      SetValue(delaySlider, XmNvalue, ConvertToSlider(interval, log10(50.0), log10(500000.0)));
      SetValue(delaySlider, XmNsensitive, (vd->tRes >= 2));

    } else {

      SetValue(delaySlider, XmNvalue,
	       ConvertToSlider(log10(3000.0), log10(50.0), log10(500000.0)));
      SetValue(delaySlider, XmNsensitive, FALSE);
    }

  SetValue(sepSlider, XmNvalue,
	   ConvertToSlider(state->mode->stereoSep, 0.0, STEREO_SEP));
  SetValue(sepSlider, XmNsensitive, state->world->stereoMode);

  SetValue(fovSlider, XmNvalue, ConvertToSlider(state->mode->perspFov, 20.0, 800.0));
  SetValue(fovSlider, XmNsensitive, state->mode->perspMode);
}


void MainWindow::InstallDynamicMenus()
{
  int buttonCount, count;
  int i = 0;

  // Find the file menu
  fileMenu = (VkSubMenu*) menuBar->findNamedItem("File");

  // Create the file key callbacks
  buttonCount = 5;
  fkcs = new KeyCallbackStruct[buttonCount];
  for (i=0; i<buttonCount; i++)
    fkcs[i]._this = this;

  count = 0;
  fkcs[count].key = '?';
  fileMenu->addAction("fileresetbut", &MainWindow::KeyChangeCallback,
		      (XtPointer) &fkcs[count++], 0);
  fkcs[count].key = 'r';
  fileMenu->addAction("filerereadbut", &MainWindow::KeyChangeCallback,
		      (XtPointer) &fkcs[count++], 1);
#ifdef VR_OPENGL
  fkcs[count].key = '*';
  fileMenu->addAction("filesnapbut", &MainWindow::KeyChangeCallback,
		      (XtPointer) &fkcs[count++], 1);
#endif

#if 0
  if (state->world->nMonitors > 0) {

    // Create the "new tied window" submenu
    winTiedMenu = fileMenu->addSubmenu("winTiedMenu", 0);

    // Create the "new untied window" submenu
    winUntiedMenu = fileMenu->addSubmenu("winUntiedMenu", 1);

    nwcs = new IndexCallbackStruct[state->world->nMonitors];

    // Add an item to each menu for each monitor
    for (i=0; i<state->world->nMonitors; i++) {
      char buf[128];

      sprintf(buf, "Monitor #%d", i+1);
      nwcs[i]._this = this;
      nwcs[i].index = i;

      winTiedMenu->addAction(buf, &MainWindow::NewTiedWindowCallback,
			     (XtPointer) &nwcs[i]);
      winUntiedMenu->addAction(buf, &MainWindow::NewUntiedWindowCallback,
			       (XtPointer) &nwcs[i]);
    }

  } else {

    nwcs = new IndexCallbackStruct[1];
    nwcs[0]._this = this;
    nwcs[0].index = -1;

    // Create the "new tied window" item
    winTiedItem = fileMenu->addAction("winTiedItem",
				      &MainWindow::NewTiedWindowCallback,
				      (XtPointer) &nwcs[0], 0);

    // Create the "new tied window" item
    winUntiedItem = fileMenu->addAction("winUntiedItem",
					&MainWindow::NewUntiedWindowCallback,
					(XtPointer) &nwcs[0], 1);
  }
#endif

  // Add the option menu item
  optionMenu = menuBar->addSubmenu("optionmenu");
  optionMenu->showTearOff(True);

  // Add the rendering option menu item
  renderOptionMenu = optionMenu->addSubmenu("renderoptionmenu");
  renderOptionMenu->showTearOff(True);

  buttonCount = 5;
  rocs = new KeyCallbackStruct[buttonCount];
  for (i=0; i<buttonCount; i++)
    rocs[i]._this = this;

  count = 0;
  rocs[count].key = 'h';
  renderOptionMenu->addToggle("renderresbut", &MainWindow::KeyChangeCallback,
			      (XtPointer) &rocs[count++]);
  rocs[count].key = ':';
  renderOptionMenu->addToggle("rendersterbut", &MainWindow::KeyChangeCallback,
			      (XtPointer) &rocs[count++]);
  rocs[count].key = 'p';
  renderOptionMenu->addToggle("renderperspbut", &MainWindow::KeyChangeCallback,
			      (XtPointer) &rocs[count++]);

  // Add the blend option menu
  blendOptionMenu = renderOptionMenu->addRadioSubmenu("blendoptionmenu");
  blendOptionMenu->showTearOff(True);

  blendOptionMenu->addToggle("blendoverbut", &MainWindow::OverBlendCallback, (XtPointer) this);
  blendOptionMenu->addToggle("blendmipbut", &MainWindow::MIPBlendCallback, (XtPointer) this);

  // Add volume option menu
  volumeOptionMenu = optionMenu->addSubmenu("volumeoptionmenu");
  volumeOptionMenu->showTearOff(True);

  buttonCount = 5;
  vocs = new KeyCallbackStruct[buttonCount];
  for (i=0; i<buttonCount; i++)
    vocs[i]._this = this;

  count = 0;
  vocs[count].key = 'O';
  volumeOptionMenu->addToggle("volcolorbut", &MainWindow::KeyChangeCallback,
			      (XtPointer) &vocs[count++]);
  vocs[count].key = 'I';
  volumeOptionMenu->addToggle("volinterpbut", &MainWindow::KeyChangeCallback,
			      (XtPointer) &vocs[count++]);
  vocs[count].key = 'C';
  volumeOptionMenu->addToggle("volcmapbut", &MainWindow::KeyChangeCallback,
			      (XtPointer) &vocs[count++]);
  vocs[count].key = 'A';
  volumeOptionMenu->addToggle("volamapbut", &MainWindow::KeyChangeCallback,
			      (XtPointer) &vocs[count++]);

  // Add surface option menu
  surfaceOptionMenu = optionMenu->addSubmenu("surfaceoptionmenu");
  surfaceOptionMenu->showTearOff(True);

  buttonCount = 5;
  socs = new KeyCallbackStruct[buttonCount];
  for (i=0; i<buttonCount; i++)
    socs[i]._this = this;

  count = 0;
  socs[count].key = 'g';
  surfaceOptionMenu->addAction("surfgenbut", &MainWindow::KeyChangeCallback,
			      (XtPointer) &socs[count++]);
  socs[count].key = 'L';
  surfaceOptionMenu->addToggle("surflightbut", &MainWindow::KeyChangeCallback,
			      (XtPointer) &socs[count++]);
  socs[count].key = 'M';
  surfaceOptionMenu->addToggle("surfmeshbut", &MainWindow::KeyChangeCallback,
			      (XtPointer) &socs[count++]);
  socs[count].key = 'X';
  surfaceOptionMenu->addToggle("surftexbut", &MainWindow::KeyChangeCallback,
			      (XtPointer) &socs[count++]);

  // Add the miscellaneous option menu item
  miscOptionMenu = optionMenu->addSubmenu("miscoptionmenu");
  miscOptionMenu->showTearOff(True);

  buttonCount = 6;
  mocs = new KeyCallbackStruct[buttonCount];
  for (i=0; i<buttonCount; i++)
    mocs[i]._this = this;

  count = 0;
  mocs[count].key = 'N';
  miscOptionMenu->addToggle("miscpntbut", &MainWindow::KeyChangeCallback,
			    (XtPointer) &mocs[count++]);
  mocs[count].key = 'S';
  miscOptionMenu->addToggle("miscsliderbut", &MainWindow::KeyChangeCallback,
			    (XtPointer) &mocs[count++]);
  if (state->world->define4BitBricks) {
    mocs[count].key = 'D';
    miscOptionMenu->addToggle("misc4bitbut", &MainWindow::KeyChangeCallback,
			      (XtPointer) &mocs[count++]);
  }
  mocs[count].key = 'G';
  miscOptionMenu->addToggle("miscclipbut", &MainWindow::KeyChangeCallback,
			    (XtPointer) &mocs[count++]);
  mocs[count].key = 'l';
  miscOptionMenu->addToggle("miscloopbut", &MainWindow::KeyChangeCallback,
			    (XtPointer) &mocs[count++]);
  mocs[count].key = 'd';
  miscOptionMenu->addToggle("miscdbbut", &MainWindow::KeyChangeCallback,
			    (XtPointer) &mocs[count++]);

  // Add the enable menu item
  enableMenu = menuBar->addSubmenu("enablemenu");
  enableMenu->showTearOff(True);

  // Add the object menu item
  objEnableMenu = enableMenu->addSubmenu("objenablemenu");
  objEnableMenu->showTearOff(True);

  buttonCount = 10;
  oecs = new KeyCallbackStruct[buttonCount];
  for (i=0; i<buttonCount; i++)
    oecs[i]._this = this;

  count = 0;
  oecs[count].key = 'v';
  objEnableMenu->addToggle("objvolbut", &MainWindow::KeyChangeCallback,
			   (XtPointer) &oecs[count++]);
  if (state->world->nElevs) {
    oecs[count].key = 'e';
    objEnableMenu->addToggle("objelevbut", &MainWindow::KeyChangeCallback,
			     (XtPointer) &oecs[count++]);
  }
  oecs[count].key = 's';
  objEnableMenu->addToggle("objsurfbut", &MainWindow::KeyChangeCallback,
			   (XtPointer) &oecs[count++]);
  oecs[count].key = 'n';
  objEnableMenu->addToggle("objpntbut", &MainWindow::KeyChangeCallback,
			   (XtPointer) &oecs[count++]);
  oecs[count].key = 'c';
  objEnableMenu->addToggle("objclipbut", &MainWindow::KeyChangeCallback,
			   (XtPointer) &oecs[count++]);
  oecs[count].key = 't';
  objEnableMenu->addToggle("objtextbut", &MainWindow::KeyChangeCallback,
			   (XtPointer) &oecs[count++]);
  oecs[count].key = 'a';
  objEnableMenu->addToggle("objvecbut", &MainWindow::KeyChangeCallback,
			   (XtPointer) &oecs[count++]);
  oecs[count].key = 'f';
  objEnableMenu->addToggle("objframebut", &MainWindow::KeyChangeCallback,
			   (XtPointer) &oecs[count++]);

  // Add the volume menu item
  volEnableMenu = enableMenu->addSubmenu("volenablemenu");
  volEnableMenu->showTearOff(True);

  vecs = new IndexCallbackStruct[state->world->nVols];

  for (i=0; i<state->world->nVols; i++) {
    vecs[i]._this = this;
    vecs[i].index = i;

    char buf[25];

    sprintf(buf, "Volume #%d", i+1);
    volEnableMenu->addToggle(buf, &MainWindow::VolumeEnableCallback,
			     (XtPointer) &vecs[i]);
  }

  // Add the surface menu item
  surfEnableMenu = enableMenu->addSubmenu("surfenablemenu");
  surfEnableMenu->showTearOff(True);

  secs = new IndexCallbackStruct[MAX_SURFS];

  for (i=0; i<MAX_SURFS; i++) {
    secs[i]._this = this;
    secs[i].index = i;

    char buf[25];

    sprintf(buf, "Surface #%d", i+1);
    surfEnableMenu->addToggle(buf, &MainWindow::SurfaceEnableCallback,
			     (XtPointer) &secs[i]);
  }

  // Add the clip plane menu item
  clipEnableMenu = enableMenu->addSubmenu("clipenablemenu");
  clipEnableMenu->showTearOff(True);

  cecs = new IndexCallbackStruct[state->world->nPlanes];

  for (i=0; i<state->world->nPlanes; i++) {
    cecs[i]._this = this;
    cecs[i].index = i;

    char buf[25];

    sprintf(buf, "Clip Plane #%d", i+1);
    clipEnableMenu->addToggle(buf, &MainWindow::ClipEnableCallback,
			     (XtPointer) &cecs[i]);
  }

  // Add the select menu item
  selectMenu = menuBar->addSubmenu("selectmenu");
  selectMenu->showTearOff(True);

  // Add the volume menu item
  volSelectMenu = selectMenu->addRadioSubmenu("volselectmenu");
  volSelectMenu->showTearOff(True);

  vscs = new IndexCallbackStruct[state->world->nVols+1];

  // Add the no selected volume item
  vscs[state->world->nVols]._this = this;
  vscs[state->world->nVols].index = -1;
  volSelectMenu->addToggle("None", &MainWindow::VolumeSelectCallback,
			(XtPointer) &vscs[state->world->nVols]);

  // Add the separator to distinguish the no selected volume item
  volSelectMenu->addSeparator();

  for (i=0; i<state->world->nVols; i++) {
    vscs[i]._this = this;
    vscs[i].index = i;

    char buf[25];

    sprintf(buf, "Volume #%d", i+1);
    VkMenuToggle *tog = volSelectMenu->addToggle(buf,
						 &MainWindow::VolumeSelectCallback,
						 (XtPointer) &vscs[i]);
  }

  // Add the surface menu item
  surfSelectMenu = selectMenu->addRadioSubmenu("surfselectmenu");
  surfSelectMenu->showTearOff(True);

  sscs = new IndexCallbackStruct[MAX_SURFS+1];

  // Add the no selected surface item
  sscs[MAX_SURFS]._this = this;
  sscs[MAX_SURFS].index = -1;
  surfSelectMenu->addToggle("None", &MainWindow::SurfaceSelectCallback,
			(XtPointer) &sscs[MAX_SURFS]);

  // Add the separator to distinguish the no selected surface item
  surfSelectMenu->addSeparator();

  for (i=0; i<MAX_SURFS; i++) {
    sscs[i]._this = this;
    sscs[i].index = i;

    char buf[25];

    sprintf(buf, "Surface #%d", i+1);
    surfSelectMenu->addToggle(buf, &MainWindow::SurfaceSelectCallback,
			     (XtPointer) &sscs[i]);
  }

  // Add the clip plane menu item
  clipSelectMenu = selectMenu->addRadioSubmenu("clipselectmenu");
  clipSelectMenu->showTearOff(True);

  cscs = new IndexCallbackStruct[state->world->nPlanes+1];

  // Add the no selected clip plane item
  cscs[state->world->nPlanes]._this = this;
  cscs[state->world->nPlanes].index = -1;
  clipSelectMenu->addToggle("None", &MainWindow::ClipSelectCallback,
			    (XtPointer) &cscs[state->world->nPlanes]);

  // Add the separator to distinguish the no selected clip plane item
  clipSelectMenu->addSeparator();

  for (i=0; i<state->world->nPlanes; i++) {
    cscs[i]._this = this;
    cscs[i].index = i;

    char buf[25];

    sprintf(buf, "Clip Plane #%d", i+1);
    clipSelectMenu->addToggle(buf, &MainWindow::ClipSelectCallback,
			     (XtPointer) &cscs[i]);
  }

  // Add the render menu
  if (state->world->magicExtensions) {

    renderMenu = menuBar->addRadioSubmenu("rendermenu");
    renderMenu->showTearOff(True);

    rccs = new IndexCallbackStruct[MAX_RMODES];

    for (i=0; i<MAX_RMODES; i++) {
      rccs[i]._this = this;
      rccs[i].index = i;

      if (state->world->allowRenderMode[i])
	renderMenu->addToggle(renderModeName[i], &MainWindow::RenderChangeCallback,
			      (XtPointer) &rccs[i]);
    }
  }

  // Set up the transfer function menu
  funcMenu = menuBar->addRadioSubmenu("funcmenu");
  funcMenu->showTearOff(True);

  tccs = new IndexCallbackStruct[state->tableData->nFuncs];

  for (i=0; i<state->tableData->nFuncs; i++) {
    tccs[i]._this = this;
    tccs[i].index = i;

    TransferFunc *func = &state->tableData->func[i];

    funcMenu->addToggle(func->title, &MainWindow::TransferFuncChangeCallback,
			(XtPointer) &tccs[i], i);
  }

  // Set up the colormap menu
  cmapMenu = menuBar->addRadioSubmenu("cmapmenu");
  cmapMenu->showTearOff(True);

  cccs = new IndexCallbackStruct[state->tableData->nColormaps];

  for (i=0; i<state->tableData->nColormaps; i++) {
    cccs[i]._this = this;
    cccs[i].index = i;
    cmapMenu->addToggle(state->tableData->colormapName[i], &MainWindow::CmapChangeCallback,
			(XtPointer) &cccs[i], i);
  }

  // Set up the alphamap menu
  amapMenu = menuBar->addRadioSubmenu("amapmenu");
  amapMenu->showTearOff(True);

  accs = new IndexCallbackStruct[state->tableData->nAlphamaps];

  for (i=0; i<state->tableData->nAlphamaps; i++) {
    accs[i]._this = this;
    accs[i].index = i;
    amapMenu->addToggle(state->tableData->alphamapName[i], &MainWindow::AmapChangeCallback,
			(XtPointer) &accs[i], i);
  }
}


void MainWindow::RemoveDynamicMenus()
{
  RemoveMenu(enableMenu);
  RemoveMenu(selectMenu);

  if (state->world->magicExtensions)
    RemoveMenu(renderMenu);

  RemoveMenu(funcMenu);
  RemoveMenu(cmapMenu);
  RemoveMenu(amapMenu);
}


void MainWindow::RemoveMenu(VkMenu *menu)
{
  for (int i=0; i<menu->numItems(); i++) {
    VkMenuItem *item = (*menu)[i];
    if (item->isContainer())
      RemoveMenu((VkMenu*) item);
    item->remove();
    delete item;
  }
}


void MainWindow::SeparationChange(Widget, XtPointer clData)
{
  XmScaleCallbackStruct *xscs = (XmScaleCallbackStruct*) clData;

  state->mode->stereoSep = ConvertFromSlider(xscs->value, 0.0, STEREO_SEP);
  state->mode->stereoRot = atan2(state->view->zTrans, state->mode->stereoSep);

  char msg[256];
  sprintf(msg, "Stereo separation is %05.3f.", state->mode->stereoSep);
  UpdateStatusMessage(msg);

  state->mode->stateChanged = TRUE;

  RedrawWindows();
}


void MainWindow::FovChange(Widget, XtPointer clData)
{
  XmScaleCallbackStruct *xscs = (XmScaleCallbackStruct*) clData;

  state->mode->perspFov = ConvertFromSlider(xscs->value, 20.0, 800.0);

  ComputePerspScale( state );

  char msg[256];
  sprintf(msg, "Field of view is %5.2f degrees.", state->mode->perspFov/10.0);
  UpdateStatusMessage(msg);

  state->mode->stateChanged = TRUE;

  RedrawWindows();
}


void MainWindow::DelayChange(Widget, XtPointer clData)
{
  XmScaleCallbackStruct *xscs = (XmScaleCallbackStruct*) clData;
  VRVolumeData *vd = state->volumeData[state->view->curVol];

  double interval = ConvertFromSlider(xscs->value, log10(50.0), log10(500000.0));

  // Display time loop if slider is far right
  char msg[256];
  if (interval >= log10(450000.0)) {
    vd->timeInterval = 0;
    sprintf(msg, "Volume #%d animation rate is  0.00 fps.", state->view->curVol);
  } else {
    vd->timeInterval = (int) pow(10.0, interval);
    sprintf(msg, "Volume #%d animation rate is %5.2f fps.", state->view->curVol,
	    1000.0 / vd->timeInterval);
  }
  UpdateStatusMessage(msg);

  if (vd->timerId)
    XtRemoveTimeOut(vd->timerId);
  vd->timerId = XtAppAddTimeOut(theApplication->appContext(), vd->timeInterval,
				TimeCycleVolumeCallback, (XtPointer) &tvcs[state->view->curVol]);

  state->mode->stateChanged = TRUE;
  RedrawWindows();
}


void MainWindow::SliceLoseFocus(Widget, XtPointer)
{
  UpdateSliceText();
}


void MainWindow::SliceActivate(Widget, XtPointer)
{
  UpdateSliceText();
}


void MainWindow::Exit(Widget, XtPointer)
{
  theApplication->quitYourself();
}


void MainWindow::UpdateSliceText()
{
  char *str;
  GetValue(sliceText, XmNvalue, (XtArgVal) &str);

  int slices = atoi(str);
  if ((slices >= state->world->sliceMin) &&
      (slices <= state->world->sliceMax) &&
      (slices != state->view->slices)) {

    state->view->slices = slices;

    ComputeDeltas( state, state->view );

    RedrawWindow( state );
  }

  char buf[64];
  sprintf(buf, "%d", state->view->slices);

  SetValue(sliceText, XmNvalue, (XtArgVal) buf);
}


int MainWindow::ConvertToSlider(float value, float min, float max)
{
  return( 800 * ((value - min) / (max - min)) );
}


float MainWindow::ConvertFromSlider(int value, float min, float max)
{
  return( (max - min) * (value / 800.0) + min );
}


void MainWindow::SetValue(Widget widget, String arg, XtArgVal value)
{
  Arg args[1];

  XtSetArg(args[0], arg, value);
  XtSetValues(widget, args, 1);
}


void MainWindow::GetValue(Widget widget, String arg, XtArgVal value)
{
  Arg args[1];

  XtSetArg(args[0], arg, value);
  XtGetValues(widget, args, 1);
}


void MainWindow::BuildWindowList(VRState *state)
{
  Window win[500];
  int p1, p2;

  // Setup for the loop
  p1 = 0;
  p2 = 1;
  win[0] = XtWindow(state->win->mainForm);

  // Loop reading off a window and adding its children
  while (p1 < p2) {

    Window w = win[p1];
    Window root, parent, *child;
    unsigned int childCount;
    int status;

    status = XQueryTree(state->view->disp, w, &root, &parent, &child, &childCount);
    if (status == 0) {
      fprintf(stderr, "XQueryTree failed!\n");
      return;
    }

    // Add the new windows
    for (int c=0; c<childCount; c++)
      win[p2++] = child[c];
    XFree(child);

    // Move to the next window
    p1++;
  }

  state->winListCount = p1;
  memcpy(state->winList, win, p1*sizeof(Window));
}


void MainWindow::NewTiedWindowCallback(Widget, XtPointer clData, XtPointer)
{
  // Appropriately cast the client data to a IndexCallbackStruct
  IndexCallbackStruct *nw = (IndexCallbackStruct*) clData;

  MainWindow *win = MakeTiedWindow( nw->_this->state, nw->index );
  if (win) {
    win->show();
    win->ReadyToGo();
  }
}


void MainWindow::NewUntiedWindowCallback(Widget, XtPointer clData, XtPointer)
{
  // Appropriately cast the client data to a IndexCallbackStruct
  IndexCallbackStruct *nw = (IndexCallbackStruct*) clData;

  MainWindow *win = MakeUntiedWindow( nw->_this->state, nw->index );
  if (win) {
    win->show();
    win->ReadyToGo();
  }
}


void MainWindow::OverBlendCallback(Widget, XtPointer clData, XtPointer)
{
  MainWindow *_this = (MainWindow*) clData;

  _this->state->mode->mipMode = FALSE;
  _this->state->mode->stateChanged = TRUE;
  RedrawWindows();
}


void MainWindow::MIPBlendCallback(Widget, XtPointer clData, XtPointer)
{
  MainWindow *_this = (MainWindow*) clData;

  _this->state->mode->mipMode = TRUE;
  _this->state->mode->stateChanged = TRUE;
  RedrawWindows();
}



void MainWindow::KeyChangeCallback(Widget, XtPointer clData, XtPointer)
{
  // Appropriately cast the client data to a KeyCallbackStruct
  KeyCallbackStruct *kc = (KeyCallbackStruct*) clData;

  // Tell the window to process the button's key equivalent
  kc->_this->renderWindow->HandleKey(kc->key);
  RedrawWindows();
}


void MainWindow::TimeCycleVolumeCallback(XtPointer caData, XtIntervalId*)
{
  IndexCallbackStruct *tcv = (IndexCallbackStruct*) caData;
  VRVolumeData *vd = tcv->_this->state->volumeData[tcv->index];

  vd->stateChanged = TRUE;
  vd->curTime = (vd->curTime+1) % vd->tRes;

  // Force a redraw if one isn't already planned
  if (!tcv->_this->state->mode->loopMode && !tcv->_this->state->view->autoSpin)
    RedrawWindow(tcv->_this->state);

  if (vd->timeInterval)
    vd->timerId = XtAppAddTimeOut(theApplication->appContext(), vd->timeInterval,
				  TimeCycleVolumeCallback, (XtPointer) tcv);
}


void MainWindow::SliderModeCallback(Widget, XtPointer clData, XtPointer)
{
  // Appropriately cast the client data to a IndexCallbackStruct
  IndexCallbackStruct *sc = (IndexCallbackStruct*) clData;

  sc->_this->state->mode->sliderMode = sc->index;
  sc->_this->state->mode->stateChanged = TRUE;
  sc->_this->UpdateState();
}


void MainWindow::VolumeEnableCallback(Widget, XtPointer clData, XtPointer)
{
  // Appropriately cast the client data to a IndexCallbackStruct
  IndexCallbackStruct *vc = (IndexCallbackStruct*) clData;

  // Update the current volume and redraw
  VRVolumeData *vd = vc->_this->state->volumeData[vc->index];
  vd->active = !vd->active;

  char msg[256];
  sprintf(msg, "Volume #%d %s.", vc->index+1, vd->active ? "enabled" : "disabled");
  vc->_this->UpdateStatusMessage(msg);
  vd->stateChanged = TRUE;

  RedrawWindows();
  vc->_this->UpdateState();
}


void MainWindow::VolumeSelectCallback(Widget, XtPointer clData, XtPointer)
{
  // Appropriately cast the client data to a IndexCallbackStruct
  IndexCallbackStruct *vc = (IndexCallbackStruct*) clData;

  // Update the current volume and redraw
  vc->_this->state->view->curVol = vc->index;

  char msg[256];
  sprintf(msg, "Volume #%d selected.", vc->index+1);
  vc->_this->UpdateStatusMessage(msg);
  vc->_this->state->view->stateChanged = TRUE;

  RedrawWindows();
  vc->_this->UpdateState();
}


void MainWindow::SurfaceEnableCallback(Widget, XtPointer clData, XtPointer)
{
  // Appropriately cast the client data to a IndexCallbackStruct
  IndexCallbackStruct *sc = (IndexCallbackStruct*) clData;

  // Update the current surface and redraw
  VRSurfaceData *sd = sc->_this->state->surfaceData[sc->index];
  sd->active = !sd->active;

  char msg[256];
  sprintf(msg, "Surface #%d %s.", sc->index+1, sd->active ? "enabled" : "disabled");
  sc->_this->UpdateStatusMessage(msg);
  sd->stateChanged = TRUE;

  RedrawWindows();
  sc->_this->UpdateState();
}


void MainWindow::SurfaceSelectCallback(Widget, XtPointer clData, XtPointer)
{
  // Appropriately cast the client data to a IndexCallbackStruct
  IndexCallbackStruct *sc = (IndexCallbackStruct*) clData;

  // Update the current surface and redraw
  sc->_this->state->view->curSurf = sc->index;

  char msg[256];
  sprintf(msg, "Surface #%d selected.", sc->index+1);
  sc->_this->UpdateStatusMessage(msg);
  sc->_this->state->view->stateChanged = TRUE;

  RedrawWindows();
  sc->_this->UpdateState();
}


void MainWindow::ClipEnableCallback(Widget, XtPointer clData, XtPointer)
{
  // Appropriately cast the client data to a IndexCallbackStruct
  IndexCallbackStruct *pc = (IndexCallbackStruct*) clData;

  // Update the current surface and redraw
  Plane *pd = &pc->_this->state->planeData->plane[pc->index];
  pd->active = !pd->active;

  char msg[256];
  sprintf(msg, "Clip plane #%d %s.", pc->index+1, pd->active ? "enabled" : "disabled");
  pc->_this->UpdateStatusMessage(msg);
  pc->_this->state->planeData->stateChanged = TRUE;

  RedrawWindows();
  pc->_this->UpdateState();
}


void MainWindow::ClipSelectCallback(Widget, XtPointer clData, XtPointer)
{
  // Appropriately cast the client data to a IndexCallbackStruct
  IndexCallbackStruct *pc = (IndexCallbackStruct*) clData;

  // Update the current surface and redraw
  pc->_this->state->view->curPlane = pc->index;

  char msg[256];
  sprintf(msg, "Clip plane #%d selected.", pc->index+1);
  pc->_this->UpdateStatusMessage(msg);
  pc->_this->state->view->stateChanged = TRUE;

  RedrawWindows();
  pc->_this->UpdateState();
}


void MainWindow::RenderChangeCallback(Widget, XtPointer clData, XtPointer)
{
  // Appropriately cast the client data to a IndexCallbackStruct
  IndexCallbackStruct *rc = (IndexCallbackStruct*) clData;

  // Update render mode and redraw
  rc->_this->state->mode->renderMode = rc->index;

  rc->_this->state->mode->stateChanged = TRUE;

  RedrawWindows();
  rc->_this->UpdateState();
}


void MainWindow::TransferFuncChangeCallback(Widget, XtPointer clData, XtPointer)
{
  // Appropriately cast the client data to a IndexCallbackStruct
  IndexCallbackStruct *fc = (IndexCallbackStruct*) clData;

  if (fc->_this->state->view->curVol != -1) {

    VRVolumeData *vd = fc->_this->state->volumeData[fc->_this->state->view->curVol];

    if (vd->curFunc != fc->index) {
      vd->curFunc = fc->index;
      vd->parmValid = FALSE;

      // If this transfer function doesn't use maps kick the slidermode over if necessary
      if ((!fc->_this->state->tableData->func[fc->index].useMap) &&
	  (fc->_this->state->mode->sliderMode != 2))
	fc->_this->state->mode->sliderMode = 2;

      // Update and install the tlut and redraw
      fc->_this->renderWindow->Focus();
      UpdateTable(fc->_this->state, fc->_this->state->view->curVol);
      InstallTable(fc->_this->state, fc->_this->state->view->curVol);

      vd->stateChanged = TRUE;
      RedrawWindows();
      fc->_this->UpdateState();
    }
  }
}


void MainWindow::CmapChangeCallback(Widget, XtPointer clData, XtPointer)
{
  // Appropriately cast the client data to a IndexCallbackStruct
  IndexCallbackStruct *tc = (IndexCallbackStruct*) clData;

  if (tc->_this->state->view->curVol != -1) {

    VRVolumeData *vd = tc->_this->state->volumeData[tc->_this->state->view->curVol];

    if (vd->curCmap != tc->index) {

      tc->_this->state->volumeData[tc->_this->state->view->curVol]->curCmap = tc->index;
      vd->cmapValid = FALSE;

      // Update and install the tlut and redraw
      tc->_this->renderWindow->Focus();
      UpdateTable(tc->_this->state, tc->_this->state->view->curVol);
      InstallTable(tc->_this->state, tc->_this->state->view->curVol);

      vd->stateChanged = TRUE;
      RedrawWindows();
      tc->_this->tlutWindow->Redraw();
      tc->_this->UpdateState();
    }
  }
}


void MainWindow::AmapChangeCallback(Widget, XtPointer clData, XtPointer)
{
  // Appropriately cast the client data to a IndexCallbackStruct
  IndexCallbackStruct *tc = (IndexCallbackStruct*) clData;

  if (tc->_this->state->view->curVol != -1) {

    VRVolumeData *vd = tc->_this->state->volumeData[tc->_this->state->view->curVol];

    if (vd->curAmap != tc->index) {

      tc->_this->state->volumeData[tc->_this->state->view->curVol]->curAmap = tc->index;
      vd->amapValid = FALSE;

      // Update and install the tlut and redraw
      tc->_this->renderWindow->Focus();
      UpdateTable(tc->_this->state, tc->_this->state->view->curVol);
      InstallTable(tc->_this->state, tc->_this->state->view->curVol);

      vd->stateChanged = TRUE;
      RedrawWindows();
      tc->_this->tlutWindow->Redraw();
      tc->_this->UpdateState();
    }
  }
}


void MainWindow::SliderChangeCallback(Widget, XtPointer clData, XtPointer caData)
{
  // Appropriately cast the client data to a IndexCallbackStruct
  IndexCallbackStruct *sc = (IndexCallbackStruct*) clData;

  // Appropriately cast the call data to a XmScaleCallbackStruct
  XmScaleCallbackStruct *xscs = (XmScaleCallbackStruct*) caData;

  // Update the transfer function and redraw
  if (sc->_this->state->view->curVol != -1) {

    VRVolumeData *vd = sc->_this->state->volumeData[sc->_this->state->view->curVol];
    TransferFunc *func;

    if (sc->_this->state->mode->sliderMode == 1) {

      // Update the colormap / alphamap parameter
      func = &sc->_this->state->tableData->cafunc;
      vd->caparm[sc->index] = ConvertFromSlider(xscs->value,
						func->pmin[sc->index],
						func->pmax[sc->index]);

    } else {

      // Update the transfer function parameter
      func = &sc->_this->state->tableData->func[vd->curFunc];
      vd->parm[sc->index] = ConvertFromSlider(xscs->value,
					      func->pmin[sc->index],
					      func->pmax[sc->index]);
    }

    sc->_this->renderWindow->Focus();
    UpdateTable(sc->_this->state, sc->_this->state->view->curVol);
    InstallTable(sc->_this->state, sc->_this->state->view->curVol);

    vd->stateChanged = TRUE;
    RedrawWindows();
    sc->_this->tlutWindow->Redraw();
  }
}


void MainWindow::SliderDragCallback(Widget, XtPointer clData, XtPointer caData)
{
  // Appropriately cast the client data to a IndexCallbackStruct
  IndexCallbackStruct *sc = (IndexCallbackStruct*) clData;

  // Appropriately cast the call data to a XmScaleCallbackStruct
  XmScaleCallbackStruct *xscs = (XmScaleCallbackStruct*) caData;

  // Update the transfer function and redraw
  if (sc->_this->state->view->curVol != -1) {

    VRVolumeData *vd = sc->_this->state->volumeData[sc->_this->state->view->curVol];
    TransferFunc *func;

    if (sc->_this->state->mode->sliderMode == 1) {

      // Update the colormap / alphamap parameter
      func = &sc->_this->state->tableData->cafunc;
      vd->caparm[sc->index] = ConvertFromSlider(xscs->value,
						func->pmin[sc->index],
						func->pmax[sc->index]);

    } else {

      // Update the transfer function parameter
      func = &sc->_this->state->tableData->func[vd->curFunc];
      vd->parm[sc->index] = ConvertFromSlider(xscs->value,
					      func->pmin[sc->index],
					      func->pmax[sc->index]);
    }

    sc->_this->renderWindow->Focus();
    UpdateTable(sc->_this->state, sc->_this->state->view->curVol);
    InstallTable(sc->_this->state, sc->_this->state->view->curVol);

    vd->stateChanged = TRUE;
    if (sc->_this->state->mode->iaSliderMode)
      RedrawWindows();
    sc->_this->tlutWindow->Redraw();
  }
}


void MainWindow::SeparationChangeCallback(Widget w, XtPointer clData, XtPointer caData)
{
  MainWindow *_this = (MainWindow*) clData;
  _this->SeparationChange(w, caData);
}


void MainWindow::FovChangeCallback(Widget w, XtPointer clData, XtPointer caData)
{
  MainWindow *_this = (MainWindow*) clData;
  _this->FovChange(w, caData);
}


void MainWindow::DelayChangeCallback(Widget w, XtPointer clData, XtPointer caData)
{
  MainWindow *_this = (MainWindow*) clData;
  _this->DelayChange(w, caData);
}


void MainWindow::SliceLoseFocusCallback(Widget w, XtPointer clData, XtPointer caData)
{
  MainWindow *_this = (MainWindow*) clData;
  _this->SliceLoseFocus(w, caData);
}


void MainWindow::SliceActivateCallback(Widget w, XtPointer clData, XtPointer caData)
{
  MainWindow *_this = (MainWindow*) clData;
  _this->SliceActivate(w, caData);
}


void MainWindow::CloseWindowCallback(Widget, XtPointer clData, XtPointer)
{
  MainWindow *_this = (MainWindow*) clData;

  // Destroy this window!
  ReleaseTopLevelWindow( _this->state );
}


void MainWindow::HandleKeyPressCallback(Widget widget, XEvent *rawEvent,
					String *params, Cardinal *numParams)
{
  VRState *state = NULL;
  int s=0;

  if (stateCount > 1)  {

    // Find the right state
    for (s=0; s<stateCount; s++) {

      // Build the window list if necessary
      if (states[s]->winList == NULL)
	BuildWindowList(states[s]);

      // Is this widget in this state's window list?
      for (int w=0; w<states[s]->winListCount; w++)
	if (states[s]->winList[w] == XtWindow(widget)) {
	  state = states[s];
	  break;
	}

      // Found the right state, stop searching
      if (state != NULL)
	break;
    }
  } else
    state = states[0];

  if (state->view->debug == 9)
    printf("Handling a key (for window %d)...\n", s+1);

  if ((rawEvent->type != KeyPress) &&
      (rawEvent->type != KeyRelease) &&
      (*numParams == 0)) {
    fprintf(stderr, "HandleKeyPress() received an unexpected event type (%d)!\n",
	    rawEvent->type);
    return;
  }

  // If arguments are passed send their characters on to be handled
  if (*numParams) {

    int i, j;

    i = 0;
    while (i < *numParams) {
      j = 0;
      while (j < strlen(params[i]))
	state->win->renderWindow->HandleKey(params[i][j], True);
    }

  } else {

    // Pass the keypress event on to the event handling routine of the rendering window
    int i;
    char s[100];

    i = XLookupString((XKeyEvent*) rawEvent, s, 100, NULL, NULL);
    if ( i )
      state->win->renderWindow->HandleKey(s[0], True);
  }

  RedrawWindows();
}


void MainWindow::ExitCallback(Widget w, XtPointer clData, XtPointer caData)
{
  MainWindow *_this = (MainWindow*) clData;
  _this->Exit(w, caData);
}
