/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/
//
// The setup for the interface.
//


#include <sys/types.h>
#include <sys/sysmp.h>

#include <Vk/VkApp.h>
#include <Vk/VkErrorDialog.h>
#include <Vk/VkBusyDialog.h>

#include "genSetup.H"
#include "genVolRen.h"
#include "genWindowMaint.h"
#include "genParseArgs.H"
#include "genLoadData.h"
#include "genSignal.H"
#include "hciMainWindow.H"
#include "hciUpdateScreen.h"
#include "volInit.h"
#include "volGeomUtils.h"


VRWorld *world;
VRState *state;

static MainWindow *win;


int main(int argc, char **argv)
{
  int volNumber;
  int elevNumber;

  // We want lock the process onto one processor in an unfettered manner
  sysmp( MP_MUSTRUN, 1 );

  // Create the application context
  VkApp *app = new VkApp("Volren", &argc, argv);

  // Parse remaining command line arguments
  world = MakeVRWorld( NULL );
  LoadVRWorld( world, argc, argv );

  // Enable the SIGUSR1 signal catcher if appropriate
  if (world->allowDataReread)
    RegisterRereadSignalHandler();

  // Mark that we are initializing
  world->initing = TRUE;

  // Create the initial state
  state = MakeVRState( NULL, world );

  // Create a top level window
  win = MakeTopLevelWindow(state);

  // Create the windows
  win->show();

  // Handle the initial slew of events
  theApplication->handlePendingEvents();

  // Post a busy dialog
  NotifyInfo("Loading volume data...");

  // Compile the data if requested
  if ( world->byteCompiling )
  {
     for ( volNumber = 0; volNumber < state->world->nVols; volNumber++ )
	CompileVRVolumeData( state, state->volumeData, volNumber );
    return( 0 );
  }

  // Load the polygon data if requested
  if (state->world->polygonFile) {
    state->polygonData = MakeVRPolygonData( state, NULL );
    LoadVRPolygonData( state, state->polygonData );
  }

  // Load the table and volume data
  LoadVRTableData( state, state->tableData );

  for (elevNumber=0; elevNumber<state->world->nElevs; elevNumber++)
    LoadVRElevData( state, state->elevData, elevNumber );

  for (volNumber=0; volNumber<state->world->nVols; volNumber++)
    LoadVRVolumeData(state, state->volumeData, volNumber, -1, -1, -1);

  // Mark that we are done initializing
  world->initing = FALSE;

  // Update the default structure values based upon the new information
  ResetVRState(state);
  UpdateView(state);
  ComputeAllPlaneExtents(state, state->planeData);

  char msg[100];
  sprintf(msg, "Volren v%s for %s on %s   ( Usable texture: %3.1f Mb )",
	  VR_VERSION,
#ifdef VR_IRISGL
	  VR_NAME_IRISGL,
#endif
#ifdef VR_OPENGL
	  VR_NAME_OPENGL,
#endif
	  VR_NAME_MACHINE, (world->usableTexMem / (1024.0*1024.0)));
  win->UpdateStatusMessage(msg);

  // Install the dynamic menus on the main window
  win->ReadyToGo();

  // Handle events!
  app->run();

  // NEVER REACHES HERE
  return( 0 );
}


void NotifyInfo(char *msg)
{
  win->UpdateStatusMessage(msg);
  theApplication->handlePendingEvents();
}


void NotifyError(char *msg, int loud)
{
  XBell(theApplication->display(), 50);

  if (loud) {

    VkErrorDialog error("Error");

    error.centerOnScreen(TRUE);
    error.setTitle("Error");

    error.postBlocked(msg);

  } else {

    win->UpdateStatusMessage(msg);
  }
}
