/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/

#ifndef _MIS_MATRIX_H_
#define _MIS_MATRIX_H_


#include <string.h>


#ifdef __cplusplus
extern "C" {
#endif


/*
 * The _safe routines should be safe even if the result is an argument.
 * The non-_safe routines are designed to be as fast as possible and may
 * fail if the result variable is the same as an argument.
 */


/* Transformation matrix */

typedef float matrix[4][4];


#define matrix_assign( a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, A )    \
{                                                                             \
   (A)[0][0] = a; (A)[0][1] = b; (A)[0][2] = c; (A)[0][3] = d;                \
   (A)[1][0] = e; (A)[1][1] = f; (A)[1][2] = g; (A)[1][3] = h;                \
   (A)[2][0] = i; (A)[2][1] = j; (A)[2][2] = k; (A)[2][3] = l;                \
   (A)[3][0] = m; (A)[3][1] = n; (A)[3][2] = o; (A)[3][3] = p;                \
}


/* C = a(row).b(row) */
   
#define matrix_inner_product( a, b, row, col, C )  		              \
{								              \
   (C)[row][col] = (a)[row][0] * (b)[0][col] +			              \
                   (a)[row][1] * (b)[1][col] +			              \
   	           (a)[row][2] * (b)[2][col] +			              \
                   (a)[row][3] * (b)[3][col];				      \
}


/* C = a.b */

#define matrix_mult( a, b, C )						      \
{								              \
   matrix_inner_product( a, b, 0, 0, C );			              \
   matrix_inner_product( a, b, 0, 1, C );			              \
   matrix_inner_product( a, b, 0, 2, C );			              \
   matrix_inner_product( a, b, 0, 3, C );			              \
   matrix_inner_product( a, b, 1, 0, C );			              \
   matrix_inner_product( a, b, 1, 1, C );			              \
   matrix_inner_product( a, b, 1, 2, C );			              \
   matrix_inner_product( a, b, 1, 3, C );			              \
   matrix_inner_product( a, b, 2, 0, C );			              \
   matrix_inner_product( a, b, 2, 1, C );			              \
   matrix_inner_product( a, b, 2, 2, C );			              \
   matrix_inner_product( a, b, 2, 3, C );			              \
   matrix_inner_product( a, b, 3, 0, C );			              \
   matrix_inner_product( a, b, 3, 1, C );			              \
   matrix_inner_product( a, b, 3, 2, C );			              \
   matrix_inner_product( a, b, 3, 3, C );			              \
}

/* C = a.b */

#define matrix_mult_safe( a, b, C )					      \
{								              \
   matrix d;								      \
									      \
   matrix_inner_product( a, b, 0, 0, d );			              \
   matrix_inner_product( a, b, 0, 1, d );			              \
   matrix_inner_product( a, b, 0, 2, d );			              \
   matrix_inner_product( a, b, 0, 3, d );			              \
   matrix_inner_product( a, b, 1, 0, d );			              \
   matrix_inner_product( a, b, 1, 1, d );			              \
   matrix_inner_product( a, b, 1, 2, d );			              \
   matrix_inner_product( a, b, 1, 3, d );			              \
   matrix_inner_product( a, b, 2, 0, d );			              \
   matrix_inner_product( a, b, 2, 1, d );			              \
   matrix_inner_product( a, b, 2, 2, d );			              \
   matrix_inner_product( a, b, 2, 3, d );			              \
   matrix_inner_product( a, b, 3, 0, d );			              \
   matrix_inner_product( a, b, 3, 1, d );			              \
   matrix_inner_product( a, b, 3, 2, d );			              \
   matrix_inner_product( a, b, 3, 3, d );			              \
									      \
   matrix_copy( d, 4, C );						      \
}

/* B = a^T */

#define matrix_transpose( a, n, B )                                           \
{								              \
   register                                                                   \
   int      i, j;						              \
									      \
   for ( i = 0; i < n; i++ )					              \
   {								              \
      for ( j = 0; j < n; j++ )					              \
      {								              \
	 (B)[j][i] = (a)[i][j];                                               \
      }								              \
   }								              \
}

#define matrix_print( a )       matrix_print_prefix( a, " " )
#define matrix_print_prefix( a, b )                                           \
{								              \
   register                                                                   \
   int      i, j;						              \
									      \
   for ( i = 0; i < 4; i++ )					              \
   {								              \
      printf( "%s", b );                                                      \
      for ( j = 0; j < 4; j++ )					              \
      {								              \
	 printf( " %9.4f", (a)[i][j]);                                        \
      }								              \
      printf( "\n" );							      \
   }								              \
}

/* B = a */

#define matrix_copy( a, n, B )  { memcpy(B, a, n*n*sizeof(float)); }

/* A = A*scalemat(x, y, z) */

#define matrix_scale( x, y, z, A )					      \
{									      \
  matrix b;								      \
									      \
  matrix_assign(   x, 0.0, 0.0, 0.0,					      \
		 0.0,   y, 0.0, 0.0,					      \
		 0.0, 0.0,   z, 0.0,					      \
		 0.0, 0.0, 0.0, 1.0, b );				      \
  matrix_mult_safe( A, b, A );						      \
}

/* A = A*translatemat(x, y, z) */

#define matrix_translate( x, y, z, A )					      \
{									      \
  matrix b;								      \
									      \
  matrix_assign( 1.0, 0.0, 0.0, 0.0,					      \
		 0.0, 1.0, 0.0, 0.0,					      \
		 0.0, 0.0, 1.0, 0.0,					      \
		   x,   y,   z, 1.0, b );				      \
  matrix_mult_safe( A, b, A );						      \
}

/* A = scalemat(x, y, z)*A */

#define matrix_pre_scale( x, y, z, A )					      \
{									      \
  matrix b;								      \
									      \
  matrix_assign(   x, 0.0, 0.0, 0.0,					      \
		 0.0,   y, 0.0, 0.0,					      \
		 0.0, 0.0,   z, 0.0,					      \
		 0.0, 0.0, 0.0, 1.0, b );				      \
  matrix_mult_safe( b, A, A );						      \
}

/* A = translatemat(x, y, z)*A */

#define matrix_pre_translate( x, y, z, A )				      \
{									      \
  matrix b;								      \
									      \
  matrix_assign( 1.0, 0.0, 0.0, 0.0,					      \
		 0.0, 1.0, 0.0, 0.0,					      \
		 0.0, 0.0, 1.0, 0.0,					      \
		   x,   y,   z, 1.0, b );				      \
  matrix_mult_safe( b, A, A );						      \
}

/* A = A*rotationx(ang) */

#define matrix_xrot( ang, A )			\
{						\
  matrix b;					\
						\
  double s = sin(ang);				\
  double c = cos(ang);				\
						\
  matrix_assign( 1.0, 0.0, 0.0, 0.0,		\
		 0.0,   c,  -s, 0.0,		\
		 0.0,   s,   c, 0.0,		\
		 0.0, 0.0, 0.0, 1.0, b );	\
						\
  matrix_mult_safe( A, b, A );			\
}

/* A = A*rotationy(ang) */

#define matrix_yrot( ang, A )			\
{						\
  matrix b;					\
						\
  double s = sin(ang);				\
  double c = cos(ang);				\
						\
  matrix_assign(   c, 0.0,   s, 0.0,		\
		 0.0, 1.0, 0.0, 0.0,		\
		  -s, 0.0,   c, 0.0,		\
		 0.0, 0.0, 0.0, 1.0, b );	\
						\
  matrix_mult_safe( A, b, A );			\
}

/* A = A*rotationz(ang) */

#define matrix_zrot( ang, A )			\
{						\
  matrix b;					\
						\
  double s = sin(ang);				\
  double c = cos(ang);				\
						\
  matrix_assign(   c,  -s, 0.0, 0.0,		\
		   s,   c, 0.0, 0.0,		\
		 0.0, 0.0, 1.0, 0.0,		\
		 0.0, 0.0, 0.0, 1.0, b );	\
						\
  matrix_mult_safe( A, b, A );			\
}


extern matrix IdentityMatrix;


extern void matrix_invert4( matrix m1, matrix m2 );


#ifdef __cplusplus
}
#endif


#endif
