/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/
//
// Image reading, writing, and  extraction routines
//


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <il/ilSize.h>
#include <il/ilGenericImgFile.h>

#include "misImage.H"


void *ReadImage(char *filename, int rgb, int lower, int x, int y, int *w, int *h, void *buf)
{
  ilImage *img;
  ilConfig *config;
  static int chanlist[3] = {0, 1, 2};

  // Describe the configuration or mapping of the image
  // from the file to main memory.
  config = new ilConfig(ilUChar, ilInterleaved, rgb?3:1, chanlist, 0,
			lower?ilLowerLeftOrigin:ilUpperLeftOrigin, rgb?ilRGB:ilMinBlack);

  // Open a TIFF/SGI/FIT file
  img = ilOpenImgFile(filename, "r");
  if (img == NULL) {
    fprintf( stderr, "Unable to open image file \"%s\"\n", filename );
    fprintf( stderr, "The error might be: %s\n", strerror(oserror()) );
    exit( EXIT_FAILURE );
  }

  // Make sure we have the right number of channels
  if (img->getNumChans() != (rgb?3:1))
    fprintf( stderr, "Warning: Expecting a %s channel image and got a "
             "%d channel one (image \"%s\")!\n",
	     rgb?"three":"one", img->getNumChans(), filename );

  // If no subregion was specified, fetch the whole image
  if ((x < 0) || (y < 0)) {
    x = 0;
    y = 0;
    *w = img->getXsize();
    *h = img->getYsize();
  }

  // Check the validity of the subregion subspecified
  if (((x+(*w)) > img->getXsize()) || ((y+(*h)) > img->getYsize()) ) {
    fprintf(stderr, "Can't extract a %dx%d image at %dx%d from a %dx%d image (\"%s\")!\n",
	    *w, *h, x, y, img->getXsize(), img->getYsize(), filename );
    exit( EXIT_FAILURE );
  }

  if (buf == NULL) {
    buf = (void*) malloc((*w) * (*h) * (rgb?3:1));
    if (buf == NULL) {
      fprintf(stderr, "Unable to allocate image data.\n");
      exit( EXIT_FAILURE );
    }
  }

  // Tell IL to read the image and stuff it in the bricks
  img->getTile(x, y, *w, *h, buf, config);

  // Free memory
  delete config;
  delete img;

  // Return the memory pointer that was possibly allocated
  return( buf );
}


void WriteImage(const char *file, int nx, int ny, unsigned char *data)
{
#if 0
  ofstream ofs(file);
  if (!ofs) {
    cerr << "Failed to open image file!" << endl;
    exit( EXIT_FAILURE );
  }

  ofs << "P6\n"
      << "\n"
      << nx << " " << ny << "\n"
      << "255\n";
  ofs.write(data, nx*ny*3);
  ofs.flush();
#endif

  ilFileImg *img;
  img = ilCreateImgFile(file, ilSize(nx, ny, 1, 3), ilUChar, ilInterleaved, ilTIFF_IMG);
  if (img == NULL) {
    fprintf(stderr, "Unable to create image file!");
    exit( EXIT_FAILURE );
  }

  img->setCoordSpace(ilLowerLeftOrigin);
  img->setTile(0, 0, nx, ny, data);
  delete img;
}


void ExtractImage(unsigned char *dst, int dnx, int /*dny*/,
		  unsigned char *src, int snx, int /*sny*/,
		  int dx, int dy, int sx, int sy, int w, int h, int csize)
{
  // This routine copies a rectangle from src to dst.  The rectangle is defined
  // by (sx, sy) to (sx+w, sy+h).  It is copied to (dx, dy) in dst. No range
  // checking is done.  Each pixel (component) is assumed to be csize bytes long.
  // The sizes of src and dst are specified by (snx, sny) and (dnx, dny) respectively.

  src += csize * (sx + sy*snx);
  dst += csize * (dx + dy*dnx);

  for (int i=0; i<h; i++) {
    memcpy(dst, src, w*csize);
    src += snx*csize;
    dst += dnx*csize;
  }
}
