/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/


#include "misCoord.h"


void coord_orient( coord *c1,  coord *c2, matrix *M )
{
   float     d, c1_z, c1_y;
   coord cc1, cc2;
   matrix    Rx, Ry, Rz, M1, M2;

   d = 1.0 / sqrt( SQUARE( c1->y ) + SQUARE( c1->z) );

   c1_z = c1->z * d;
   c1_y = c1->y * d;

   matrix_assign(  1,     0,    0, 0,
	 	   0,  c1_z, c1_y, 0,
	 	   0, -c1_y, c1_z, 0,
		   0,     0,    0, 1, Rx );
                     		
   coord_transform( *c1, Rx, cc1 );
                     		
   matrix_assign( cc1.z,   0, cc1.x, 0,
                      0,   1,     0, 0,
                 -cc1.x,   0, cc1.z, 0,
		      0,   0,     0, 1, Ry );
                     		
   matrix_mult( Rx,  Ry, M1 );
                     		
   coord_transform( *c2, M1, cc2 );
                     		
   matrix_assign( cc2.x, -cc2.y,  0, 0,
	 	  cc2.y,  cc2.x,  0, 0,
		      0,      0,  1, 0,
		      0,      0,  0, 1, Rz );

   matrix_mult( M1,  Rz, M2 );
   matrix_transpose( M2, 4, (*M) );
}


void coord_view(   coord *c1,  coord *c2, float theta, matrix M )
{
   float     d, c1_y, c1_z;
   coord cc0, cc1;
   matrix    Rx, Ry, Rz, M0, M1, T0;


   /* Compute Rx, Ry, and Rz.  These matrices perform the rotations
    * Necessary to take the view vector to the z-axis.
    */

   matrix_assign(      1,      0,      0, 0,
                       0,      1,      0, 0,
                       0,      0,      1, 0,
                  -c1->x, -c1->y, -c1->z, 1, T0 );

   coord_sub( *c2, *c1, cc0 );

   d = sqrt( SQUARE( cc0.y ) + SQUARE( cc0.z) );

   if ( d > 0.00001 )
   {
      d = 1.0 / d;		

      c1_z = -cc0.z * d;
      c1_y =  cc0.y * d;
   }
   else
   {
      c1_z = -1.0;
      c1_y =  0.0;
   } 

   matrix_assign(  1,     0,     0, 0,
	 	   0,  c1_z, -c1_y, 0,
	 	   0,  c1_y,  c1_z, 0,
		   0,     0,     0, 1, Rx );

   matrix_mult( T0, Rx, M0 );
                       

   coord_transform( cc0, Rx, cc1 );

   d = sqrt( SQUARE(cc1.x) + SQUARE(cc1.z) );

   if ( d > 0.000001 )
   {
      d = 1.0/d;

      cc1.z *= -d;
      cc1.x *=  d;
   }
   else
   {       
      cc1.z = -1.0;
      cc1.x =  0.0;
   }


   matrix_assign( cc1.z,     0, -cc1.x, 0,
                      0,     1,      0, 0,
                  cc1.x,     0,  cc1.z, 0,
                      0,     0,      0, 1, Ry );
                     		
   matrix_mult( M0, Ry, M1 );
                     		
   matrix_assign( cos(theta),  sin(theta),  0, 0,
	 	 -sin(theta),  cos(theta),  0, 0,
		           0,           0,  1, 0,
  		           0,           0,  0, 1, Rz );


   matrix_mult( M1,  Rz, M );
}


void coord_look( coord *c1,  coord *c2, matrix M )
{
   float     d, c1_y, c1_z, x, y;
   coord cc0, cc1;
   matrix    Rx, Ry, Rz, M0, M1, T0;
   coord rms,rms1 ;


   /* Compute Rx, Ry, and Rz.  These matrices perform the rotations
    * Necessary to take the view vector to the z-axis.
    */

   matrix_assign(      1,      0,      0, 0,
                       0,      1,      0, 0,
                       0,      0,      1, 0,
                  -c1->x, -c1->y, -c1->z, 1, T0 );

   coord_sub( *c2, *c1, cc0 );

   d = sqrt( SQUARE( cc0.y ) + SQUARE( cc0.z) );

   if ( d > 0.00001 )
   {
      d = 1.0 / d;		

      c1_z = -cc0.z * d;
      c1_y =  cc0.y * d;
   }
   else
   {
      c1_z = -1.0;
      c1_y =  0.0;
   } 

   matrix_assign(  1,     0,     0, 0,
	 	   0,  c1_z, -c1_y, 0,
	 	   0,  c1_y,  c1_z, 0,
		   0,     0,     0, 1, Rx );


   coord_transform( cc0, Rx, cc1 );

   d = sqrt( SQUARE(cc1.x) + SQUARE(cc1.z) );

   if ( d > 0.000001 )
   {
      d = 1.0/d;

      cc1.z *= -d;
      cc1.x *=  d;
   }
   else
   {       
      cc1.z = -1.0;
      cc1.x =  0.0;
   }


   matrix_assign( cc1.z,     0, -cc1.x, 0,
                      0,     1,      0, 0,
                  cc1.x,     0,  cc1.z, 0,
                      0,     0,      0, 1, Ry );
                     		
   matrix_mult( Rx, Ry, M1 );
                     
   rms.x = 0.782608 ;
   rms.y = 0.0 ;
   rms.z = 0.622514 ;
   coord_transform(rms,M1,rms1) ;
   x = rms1.x;
   y = rms1.y;

   d = sqrt( SQUARE(x) + SQUARE(y) );

   x /= d;
   y /= d;

   matrix_assign( x,   -y,  0, 0,
	 	  y,  x,  0, 0,
                  0,   0,  1, 0,
  	          0,   0,  0, 1, Rz );


   matrix_mult( M1,  Rz, M0 );
   matrix_mult( T0,  M0, M );
}
