/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/

//
// The main window of the volume renderer
//


#ifndef _HCI_MAINWINDOW_H_
#define _HCI_MAINWINDOW_H_


#include <Vk/VkWindow.h>
#include <Vk/VkMenuItem.h>

#include "hciRenderWindow.H"
#include "hciTlutWindow.H"
#include "hciToggleGroup.H"
#include "genVolRen.h"


struct IndexCallbackStruct;
struct KeyCallbackStruct;


class MainWindow : public VkWindow
{
 public:

  MainWindow(const char *name, VRState *_state);
  virtual ~MainWindow();

  virtual const char* className();

  void ReadyToGo();
  void Reset(VRState *state);

  void UpdateStatusMessage(char *msg);
  void UpdateState();

  void ResetMenuValues();
  void ResetSliderValues();
  void ResetParameterValues();

  RenderWindow      *renderWindow;
  TlutWindow        *tlutWindow;

  XmFontList         smallFontList, medumFontList, largeFontList;

 protected:

  void InstallDynamicMenus();
  void RemoveDynamicMenus();
  void RemoveMenu(VkMenu *menu);

  void NewTiedWindow(Widget, XtPointer);
  void NewUntiedWindow(Widget, XtPointer);
  void SeparationChange(Widget, XtPointer);
  void FovChange(Widget, XtPointer);
  void DelayChange(Widget, XtPointer);
  void SliceLoseFocus(Widget, XtPointer);
  void SliceActivate(Widget, XtPointer);
  void Exit(Widget, XtPointer);

  void UpdateSliceText();

  static int   ConvertToSlider(float value, float min, float max);
  static float ConvertFromSlider(int value, float min, float max);

  static void SetValue(Widget widget, String arg, XtArgVal value);
  static void GetValue(Widget widget, String arg, XtArgVal value);

  int             menuFontsSet;

  VkMenuBar      *menuBar;
  VkSubMenu      *fileMenu;
#if 0
  VkSubMenu      *winTiedMenu;
  VkSubMenu      *winUntiedMenu;
  VkMenuItem     *winTiedItem;
  VkMenuItem     *winUntiedItem;
#endif
  VkSubMenu *optionMenu;
  VkSubMenu *renderOptionMenu;
  VkRadioSubMenu *blendOptionMenu;
  VkSubMenu *volumeOptionMenu;
  VkSubMenu *surfaceOptionMenu;
  VkSubMenu *miscOptionMenu;
  VkSubMenu *enableMenu;
  VkSubMenu *objEnableMenu;
  VkSubMenu *volEnableMenu;
  VkSubMenu *surfEnableMenu;
  VkSubMenu *clipEnableMenu;
  VkSubMenu *selectMenu;
  VkRadioSubMenu *volSelectMenu;
  VkRadioSubMenu *surfSelectMenu;
  VkRadioSubMenu *clipSelectMenu;
  VkRadioSubMenu *renderMenu;
  VkRadioSubMenu *funcMenu;
  VkRadioSubMenu *cmapMenu;
  VkRadioSubMenu *amapMenu;

  // The widget tree layout of the mainwindow

  Widget         mainForm;
  Widget           topForm;
  Widget             winFrame;
  //                   RenderWindow
  Widget             tlutForm;
  Widget               tlutFrame;
  //                     TlutWindow
  Widget               buttonFrame;
  Widget                 buttonForm;
  Widget                   camapButton;
  Widget                   addLabel;
  Widget                   tfuncButton;
  Widget                   equalLabel;
  Widget                   lookupButton;
  ToggleGroup              sliderGroup;
  Widget               slideFrame;
  Widget                 slideForm;
  Widget                   sliderForm;
  Widget                     s1Label;
  Widget                     s2Label;
  Widget                     s3Label;
  Widget                     s4Label;
  Widget                   labelForm;
  Widget                     s1Slider;
  Widget                     s2Slider;
  Widget                     s3Slider;
  Widget                     s4Slider;
  Widget           parFrame;
  Widget             parForm;
  Widget               delayForm;
  Widget                 delayLabel;
  Widget                 delaySlider;
  Widget               renderForm;
  Widget                 sepForm;
  Widget                   sepLabel;
  Widget                   sepSlider;
  Widget                 fovForm;
  Widget                   fovLabel;
  Widget                   fovSlider;
  Widget               statusForm;
  Widget                 statusText;
  Widget                 sliceLabel;
  Widget                 sliceText;

  static String defaultResources[];

  static VkMenuDesc menuPaneDesc[];
  static VkMenuDesc fileMenuDesc[];

 private:

  static void BuildWindowList(VRState *state);

  static void NewTiedWindowCallback(Widget, XtPointer, XtPointer);
  static void NewUntiedWindowCallback(Widget, XtPointer, XtPointer);
  static void ColorOptionsCallback(Widget, XtPointer, XtPointer);

  static void SliderModeCallback(Widget, XtPointer, XtPointer);

  static void VolumeEnableCallback(Widget, XtPointer, XtPointer);
  static void VolumeSelectCallback(Widget, XtPointer, XtPointer);
  static void SurfaceEnableCallback(Widget, XtPointer, XtPointer);
  static void SurfaceSelectCallback(Widget, XtPointer, XtPointer);
  static void ClipEnableCallback(Widget, XtPointer, XtPointer);
  static void ClipSelectCallback(Widget, XtPointer, XtPointer);
  static void RenderChangeCallback(Widget, XtPointer, XtPointer);
  static void TransferFuncChangeCallback(Widget, XtPointer, XtPointer);
  static void CmapChangeCallback(Widget, XtPointer, XtPointer);
  static void AmapChangeCallback(Widget, XtPointer, XtPointer);

  static void KeyChangeCallback(Widget, XtPointer, XtPointer);

  static void OverBlendCallback(Widget, XtPointer, XtPointer);
  static void MIPBlendCallback(Widget, XtPointer, XtPointer);

  static void TimeCycleVolumeCallback(XtPointer, XtIntervalId*);
  static void SliderChangeCallback(Widget, XtPointer, XtPointer);
  static void SliderDragCallback(Widget, XtPointer, XtPointer);
  static void SeparationChangeCallback(Widget, XtPointer, XtPointer);
  static void FovChangeCallback(Widget, XtPointer, XtPointer);
  static void DelayChangeCallback(Widget, XtPointer, XtPointer);
  static void SliceLoseFocusCallback(Widget, XtPointer, XtPointer);
  static void SliceActivateCallback(Widget, XtPointer, XtPointer);

  static void CloseWindowCallback(Widget, XtPointer, XtPointer);
  static void HandleKeyPressCallback(Widget, XEvent*, String*, Cardinal*);
  static void HandleKeyPressCallback(Widget, XtPointer, XEvent*, Boolean*);
  static void ExitCallback(Widget, XtPointer, XtPointer);

  VRState *state;

  KeyCallbackStruct   *fkcs;	// File key selected

  KeyCallbackStruct   *rocs;	// Rendering option key selected
  KeyCallbackStruct   *vocs;	// Volume option key selected
  KeyCallbackStruct   *socs;	// Surface option key selected
  KeyCallbackStruct   *mocs;	// Miscellaneous option key selected

  IndexCallbackStruct *smcs;	// Slider mode index selected

  KeyCallbackStruct   *oecs;	// Object enable key selected
  IndexCallbackStruct *vecs;	// Volume enable index selected
  IndexCallbackStruct *vscs;	// Volume select index selected
  IndexCallbackStruct *secs;	// Surface enable index selected
  IndexCallbackStruct *sscs;	// Surface select index selected
  IndexCallbackStruct *cecs;	// Clip plane enable index selected
  IndexCallbackStruct *cscs;	// Clip plane select index selected

  IndexCallbackStruct *nwcs;	// New window monitor index
  KeyCallbackStruct   *kccs;	// Keypress event key
  IndexCallbackStruct *sccs;	// Slider value return
  IndexCallbackStruct *rccs;	// Type of rendering requested
  IndexCallbackStruct *tccs;	// Transfer function index selected
  IndexCallbackStruct *cccs;	// Table index selected
  IndexCallbackStruct *accs;	// Table index selected
  IndexCallbackStruct *tvcs;	// Volume to time cycle

  friend RenderWindow;
};


struct IndexCallbackStruct
{
  MainWindow *_this;
  int         index;		// the index selected
};


struct KeyCallbackStruct
{
  MainWindow *_this;
  char        key;		// the key that was pressed
};


#endif
