#include <stdio.h>
#include <string.h>
#include <gl.h>
#include <device.h>
#include <get.h>
#include <gl/addrs.h>
#include <gl/cg2vme.h>

#define YMAXSTEREO 491
#define YOFFSET 532

char *leftname, *rightname;
long monitor;


int is_stereo() {
    int RV1 = TRUE;
    long rw1, rw2;
    int i;

    for(i=1; i<10; i++) {
	rw1 = getvideo(DE_R1);
	rw1 = rw1 ^ DER1_STEREO;
	rw2 = rw1;
	setvideo(DE_R1, rw2);
	rw2 = getvideo(DE_R1);
	RV1 = (rw1 == rw2) ? TRUE  :  FALSE;
	if(!RV1) break;

	rw2 = rw2 ^ DER1_STEREO;
	rw1 = rw2;
	setvideo(DE_R1, rw2);
	rw2 = getvideo(DE_R1);
	RV1 = (rw1 == rw2) ? TRUE  :  FALSE;
	if(!RV1) break;
    }
    return (RV1 == TRUE) ? FALSE  : TRUE;
}


initialize() {
    prefposition(0, XMAXSCREEN, 0, YMAXSCREEN);
    foreground();
    winopen("");
    doublebuffer();
    RGBmode();
    gconfig();

    qdevice(ESCKEY);

    viewport(0, XMAXSCREEN, 0, YMAXSCREEN);
    frontbuffer(TRUE);
    RGBcolor(0,0,0);
    clear();
    frontbuffer(FALSE);
/*
 *  Save the monitor type (HZ30, HZ60, STR_RECT...)
 */
    monitor = getmonitor();

    if(is_stereo())
       setmonitor(STR_RECT);
    else
       fprintf(stderr, "This monitor does not have stereo.\n");
}

draw_scene()
{
    char		*index, cmd[80], hdr[80];
    unsigned char	*imgbuf;
    int			bufsiz, x, y, xoff, yoff;
    int			width, height, nchan;
    unsigned long	*sgibuf;
    FILE		*left, *right;
/*
 *  Get the size of the files.
 */
   sprintf(cmd,"rlehdr -b -h %s", leftname);
   if ((left = popen(cmd, "r")) == NULL)
      fprintf(stderr, "Cannot open pipe to URT rlehdr utility.\n");
   if ((fread(hdr, 40, 1, left)) != 1)
      fprintf(stderr, "Cannot read header data from pipe.\n");
   pclose(left);
   index = strrchr(hdr, '[');
   sscanf(++index, "%d,%d", &width, &height);
   index = strrchr(hdr, 'x');
   sscanf(++index, "%d", &nchan);
   if (width > (XMAXSCREEN+1) || height/2 > (YMAXSTEREO+1)) {
      fprintf(stderr, "This image (%dx%d) is too large for stereo mode (%dx%d).\n", width, height, XMAXSCREEN+1, (YMAXSTEREO+1)*2);
      setmonitor(monitor);
      exit(-1);
      }
/*
 *  Get some memory and stuff.
 *  Each image must be 1280x492.
 *  The top image is located at Y=532 (YOFFSET).
 */
    bufsiz = width*height*nchan;
    xoff = ((XMAXSCREEN+1)-width)/2;
    yoff = ((YMAXSTEREO+1)-height/2)/2;
    if ((imgbuf = (unsigned char *)malloc(bufsiz)) == NULL) {
       fprintf(stderr, "Cannot malloc %d bytes for image buffer.\n", bufsiz);
       exit(-1);
       }
    if ((sgibuf = (unsigned long *)malloc(width*height*2)) == NULL) {
       fprintf(stderr, "Cannot malloc %d bytes for image buffer.\n", width*height*2);
       exit(-1);
       }
/*
 *  Left eye (top)
 */
   sprintf(cmd,"rletoraw -s %s", leftname);
   if ((left = popen(cmd, "r")) == NULL)
      fprintf(stderr, "Cannot open pipe to URT rletoraw utility.\n");
   if ((fread(imgbuf, bufsiz, 1, left)) != 1)
      fprintf(stderr, "Cannot read image data from pipe.\n");
   pclose(left);
   for (y=0; y<height/2; y++)
      for (x=0; x<width; x++)
         sgibuf[x+y*width] = imgbuf[x+((y+y)*nchan)*width]
                          | (imgbuf[x+((y+y)*nchan+1)*width] << 8)
                          | (imgbuf[x+((y+y)*nchan+2)*width] << 16);
   viewport(0, XMAXSCREEN, YOFFSET, YOFFSET+YMAXSTEREO);
   lrectwrite(xoff, yoff+YOFFSET, xoff+width-1, YOFFSET+yoff+height/2-1, sgibuf);
/*
 *  Right eye (bottom)
 */
   sprintf(cmd,"rletoraw -s %s", rightname);
   if ((right = popen(cmd, "r")) == NULL)
      fprintf(stderr, "Cannot open pipe to URT rletoraw utility.\n");
   if ((fread(imgbuf, bufsiz, 1, right)) != 1)
      fprintf(stderr, "Cannot read image data from pipe.\n");
   pclose(right);
   for (y=0; y<height/2; y++)
      for (x=0; x<width; x++)
         sgibuf[x+y*width] = imgbuf[x+((1+y+y)*nchan)*width]
                          | (imgbuf[x+((1+y+y)*nchan+1)*width] << 8)
                          | (imgbuf[x+((1+y+y)*nchan+2)*width] << 16);
   viewport(0, XMAXSCREEN, 0, YMAXSTEREO);
   lrectwrite(xoff, yoff, xoff+width-1, yoff+height/2-1, sgibuf);
    free(imgbuf);
    free(sgibuf);
    swapbuffers();
}


main(argc, argv)
int	argc;
char	**argv;
{
    int dev;
    short val;

    if (argc != 3) {
       fprintf(stderr, "Usage: image leftname rightname\n");
       exit(-1);
       }
    leftname = argv[1];
    rightname = argv[2];
    initialize();
    draw_scene();

    while (dev != WINQUIT) {	/* <- this doesn't work */
	switch(dev=qread(&val)) {
	    case ESCKEY:
		if(val) break;
            case WINQUIT:
		/*setmonitor(monitor);*/
		setmonitor(HZ60);
                /*switch (monitor) {
                   case HZ30:
                      fprintf(stderr, "Set monitor back to HZ30.\n");
                      break;
                   case HZ30_SG:
                      fprintf(stderr, "Set monitor back to HZ30_SG.\n");
                      break;
                   case HZ60:
                      fprintf(stderr, "Set monitor back to HZ60.\n");
                      break;
                   case NTSC:
                      fprintf(stderr, "Set monitor back to NTSC.\n");
                      break;
                   case PAL:
                      fprintf(stderr, "Set monitor back to PAL.\n");
                      break;
                   case STR_RECT:
                      fprintf(stderr, "Set monitor back to STR_RECT.\n");
                      break;
                   default:
                      fprintf(stderr, "Unknown monitor.\n");
                   }*/
                exit(0);
		break;
            case REDRAW:
		draw_scene();
		break;
        }
    }
    exit(0);
}
