 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kdbmedit
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kdbmedit.h"

clui_info_struct *clui_info = NULL;

gui_info_struct *gui_info;

/*-----------------------------------------------------------
|
|  Routine Name: main() - DBM database editor (ascii only)
|
|       Purpose: main program for kdbmedit
|
|         Input:
|		char *clui_info->dbm_string; {path to dbm file, including basename}
|		int   clui_info->dbm_flag; {TRUE if -dbm specified}
|
|		int clui_info->view_flag; {TRUE if -view specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *form;            /* form tree representing *.form file */
	char   *form_filestring; /* *.form file for kdbmedit    */ 
	char   *form_pathname;   /* location of kdbmedit.form   */
	char   *form_fullpath;   /* expanded kdbmedit.form path */
	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
   char	*dbmfile;
   char	*filename;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "SUPPORT");
	kexit_handler(kdbmedit_free_args, NULL);

/* -main_get_args_call */
   pane = kgen_initialize(PANEPATH, KGEN_XVROUTINE, "SUPPORT", "kdbmedit",
			  kdbmedit_usage_additions);

   kdbmedit_get_args(pane);
   kvf_destroy_form(pane);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

	/*
	 * Set location of kdbmedit.form
	 */
	if (clui_info->form_flag)
	{
	    form_filestring = kstrdup(clui_info->form_file);
	    form_pathname   = NULL;
	}
	else
	{
	    form_filestring = kstrdup("kdbmedit.form");
	    form_pathname   = kstrdup("$TOOLBOX/objects/xvroutine/kdbmedit/uis");
	}
	form_fullpath   = kfullpath(form_filestring, form_pathname, NULL);

	/*
	 * Allocate the GUI Info structure 
	 */
	gui_info = (gui_info_struct *)
				kcalloc (1, sizeof (gui_info_struct));
	/*
	 * Create the forms for kdbmedit 
	 */
	form = xvf_create_form(form_fullpath, NONE, run_form, gui_info,
				clui_info->x_int, clui_info->y_int,
				XVF_PARTIAL_EDIT);
	if (form == NULL)
	   kexit(KEXIT_FAILURE);

	/*
	 * Initialize the GUI Info structure 
	 */
	if (!(_xvf_init_form(form, gui_info)))
	    kexit(KEXIT_FAILURE);

/* -main_before_lib_call */
   create_interface(gui_info->kdbmedit->pane->workspace);

   filename = clui_info->dbm_string;
   if (!kstrcmp(filename + (kstrlen(filename) - 4),".dir") ||
       !kstrcmp(filename + (kstrlen(filename) - 4),".pag"))
      dbmfile = kstring_ncopy(filename,kstrlen(filename) - 4,NULL);
   else
      dbmfile = clui_info->dbm_string;

   initialize_dbm(dbmfile);

   if (clui_info->view_flag)
   {
      xvf_unmap_kformstruct(gui_info->kdbmedit->addpane->addkey_struct);
      xvf_unmap_kformstruct(gui_info->kdbmedit->edit_struct);
      xvf_unmap_kformstruct(gui_info->kdbmedit->delete_struct);
#if 0
      /*-----------------------------------------------------------------
      | we want to unmap the subform buttons, but there isn't a handle
      | generated for those
      -----------------------------------------------------------------*/
      xvf_unmap_kformstruct(gui_info->kdbmedit->pane_struct);
      xvf_unmap_kformstruct(gui_info->kdbmedit->addpane_struct);
#endif
      xvf_set_attribute(gui_info->kdbmedit_struct, XVF_HEIGHT, 8.0);
   }
/* -main_before_lib_call_end */

/* -main_library_call */
	xvf_run_form();
/* -main_library_call_end */

/* -main_after_lib_call */
	close_dbm();
/* -main_after_lib_call_end */

	kfree(form_filestring);
	kfree(form_pathname);
	kfree(form_fullpath);

	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kdbmedit_usage_additions
| 
|       Purpose: Prints usage additions in kdbmedit_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kdbmedit
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kdbmedit_usage_additions(void)
{
	kfprintf(kstderr, "\tDBM database editor (ascii only)\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kdbmedit_free_args
| 
|       Purpose: Frees CLUI struct allocated in kdbmedit_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kdbmedit
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kdbmedit_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->dbm_string);
		kfree(clui_info->form_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
