 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	GUI Drivers for 'kdbmedit'
   >>>> 
   >>>>  Private: 
   >>>> 	run_form
   >>>> 	run_kdbmedit
   >>>> 	run_addpane
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kdbmedit.h"

/*-----------------------------------------------------------
| 
|  Routine Name: run_form
| 
|       Purpose: Main GUI Driver for kdbmedit
| 
|         Input: None
| 
|        Output: Returns TRUE on success, FALSE on failure
|    Written By: conductor -oname kdbmedit -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void run_form(
     kform    *form,
     ksubform *subform,
     kaddr    client_data)
{
	/*
	 * GUI info structure passed in as client_data 
	 */
	gui_info_struct *master_info = (gui_info_struct *) client_data;

	/*
	 * Get information from the forms
	 */
	_xvf_get_form(master_info);

	if (form->quit)
	{
	    xvf_destroy_allforms();
	    _xvf_free_form(master_info);
	    return;
	}

	/*
	 * action came from the 'kdbmedit' subform
	 */
	if (master_info->kdbmedit_selected)
	    run_kdbmedit(master_info->kdbmedit);

	xvf_clear_selections(form);

}

/*-----------------------------------------------------------
| 
|  Routine Name: run_kdbmedit
| 
|       Purpose: GUI Driver for subform 'kdbmedit'
| 
|         Input: form      - pointer to the form tree
|                kdbmedit_info - pointer to form_kdbmedit struct
| 
|        Output: None
|    Written By: conductor -program_name kdbmedit -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_kdbmedit(
     form_kdbmedit *kdbmedit_info)
{

	/*
	 * user selected 'live' list selection 'keylist'
	 */
	if (kdbmedit_info->keylist_selected)
	{
	    kdbmedit_keylist(kdbmedit_info);
	    kdbmedit_info->keylist_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'edit'
	 */
	else if (kdbmedit_info->edit)
	{
	    kdbmedit_edit(kdbmedit_info);
	    kdbmedit_info->edit = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'delete'
	 */
	else if (kdbmedit_info->delete)
	{
	    kdbmedit_delete(kdbmedit_info);
	    kdbmedit_info->delete = FALSE;
	}
	/*
	 * action came from the 'addpane' pane
	 */
	else if (kdbmedit_info->addpane_selected)
	    run_addpane(kdbmedit_info->addpane);


}   /* end run_kdbmedit */



/*-----------------------------------------------------------
| 
|  Routine Name: run_addpane
| 
|       Purpose: GUI Driver for pane 'addpane'
| 
|         Input: form - pointer to the form tree
|                addpane_info - pointer to kdbmedit_addpane struct
| 
|        Output: None
|    Written By: conductor -program_name kdbmedit -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_addpane(
     kdbmedit_addpane *addpane_info)

{

	/*
	 * user selected 'live' list selection 'allkeys'
	 */
	if (addpane_info->allkeys_selected)
	{
	    addpane_allkeys(addpane_info);
	    addpane_info->allkeys_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'addkey'
	 */
	else if (addpane_info->addkey)
	{
	    addpane_addkey(addpane_info);
	    addpane_info->addkey = FALSE;
	}
	/*
	 * user selected 'live' string selection 'custom'
	 */
	else if (addpane_info->custom_selected)
	{
	    addpane_custom(addpane_info);
	    addpane_info->custom_selected = FALSE;
	}


}


