
eval 'exec perl -S $0 $*'
                if $runnning_under_some_shell;

#========================================================================
# Program Name: build-keyinfo.pl - build list of legal database keys
# Purposed:	This perl script is associated with the kdbmedit program,
#		and generates an include file which is part of the
#		kdbmedit source code -- keyinfo.h
#
# RCS ID:	Khoros: $Id$
# RCS Log:	$Log$
#========================================================================

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

chop($bootstrapPath = `kecho -tb "SUPPORT" -echo path`);
chop($kdbmeditPath = `kecho -tb "SUPPORT" -oname kdbmedit -fullpath -echo path`);

@legal_fields = ('Key', 'Description');
$validRE = join('|', @legal_fields);

$include = "$bootstrapPath/include/kcms/keys.h";
$keyinfo = "$kdbmeditPath/src/keyinfo.h";
&ParseIncludeFile($include);

open(INCLUDE, "> $keyinfo") || die "Can't write keyinfo.h ($keyinfo): $!\n";
print INCLUDE <<EndOfPreamble;
#ifndef __keyinfo_h_
#define __keyinfo_h_

static kstring kcmskeys[] =
{
EndOfPreamble

@symbols = (sort bykeystring keys %keyString);

foreach $symbol (@symbols)
{
   print INCLUDE "   \"",$keyString{$symbol},"\",\n";
}
print INCLUDE "};\n\n";

print INCLUDE "static kstring key_descriptions[] =\n{\n";
foreach $symbol (@symbols)
{
   ($description = $Description{$symbol}) =~ s/\n/ /g;
   print INCLUDE "   \"$description\",\n";
}
print INCLUDE "};\n\n";
print INCLUDE "#endif\n";
close INCLUDE;

sub bykeystring { $keyString{$a} cmp $keyString{$b} }

# ========================================================================
# ParseIncludeFile()
#	Parse the include file which contains key definitions
# ========================================================================
sub ParseIncludeFile
{
   local($filename) = @_;
   local(*INFILE);


   open(INFILE, "< $filename") || die "Can't read input file $filename: $!\n";
   $number = 0;
   $inblock = 0;
   while (<INFILE>)
   {
      /^\s*#\s*define\s+(\S+)\s+"([^"]+)"/ && do
      {
         $keyString{$1} = $2;
         next;
      };

      #-- start of a comment block? -------------------------------------
      if (m!^/\*-+\s*$! && $inblock == 0)
      {
	 $inblock       = 1;
	 $inattrblock   = 0;
	 $indescription = 0;
	 $description   = '';
	 next;
      }
      
      #-- end of a comment block? ---------------------------------------
      if (m!^-+\*/\s*$! && $inblock == 1)
      {
	 $inblock       = 0;
	 $indescription = 0;
	 $inattrblock   = 0;
	 next;
      }

      if (/^\|\s*([A-Za-z ]+):\s*(.*)\s*$/
	  && ($field = $1)
	  && ($value = "$2 ")
	  && $field =~ /($validRE)/i)
      {
	 $value =~ s/\\/\\\\/g;
	 $value =~ s/("|\$)/\\$1/g;
         $value =~ s/(.*)\s+$/$1/g;
	 if ($field eq 'Key' && $inblock)
	 {
	    $attribute = $value;
	    $inattrblock = 1;
	    push(@attributes, $attribute);
	 }
	 else
	 {
	    next unless $inattrblock;
	    die "Field \"$field\" seen on line $., but no Symbol: seen.\n"
	       unless defined $attribute;
	    ($assoc = $field) =~ s/\s+//g;
	    $ref = "\$$assoc"."{'$attribute'}";
	    eval "$ref = \"$value\\n\".\"\"";

	 }

	 next;
      }

      next unless $inattrblock;

      if (/^\|\t\t(.*)\s*$/)
      {
	 ($value = $1) =~ s/\\/\\\\/g;
	 $value =~ s/("|\$)/\\$1/g;
	 eval "$ref .= \"$value\\n\"";
	 next;
      }

      if (/^\| {15}(.*)\s*$/)
      {
	 ($value = $1) =~ s/\\/\\\\/g;
	 $value =~ s/("|\$)/\\$1/g;
	 eval "$ref .= \"$value\\n\"";
	 next;
      }
   }

   close INFILE;
}
