: # use perl
        eval 'exec perl -S $0 "$@"'
                if $runnning_under_some_shell;

#
# kwordfreq - generate word frequency table for documentation files
#
# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
#

$LOGFILE = "kwordfreq.log";		# where the list of frequencies go

opendir(DIR, '.') || die "can't open dot\n";
@secfiles = grep(/\.sec$/,readdir(DIR));
closedir(DIR);

die "kwordfreq: No .sec files found.\n" if @secfiles == 0;

print STDERR "kwordfreq: processing files ...\n";
foreach $secfile (@secfiles) {
	&ProcessSecfile($secfile);
}
&GenerateReport();

# ------------------------------------------------------------------------
# ProcessSecfile()
#	Work through a specified .sec file, a line at a time:
#		-	split line into constituent words
#		-	substitute out non-word bits (eg font escapes)
#		-	throw away things we can ignore
#		-	increment count for word (associated array)
#		-	add file name to associated array holding list of
#			of files where word was found.
# ------------------------------------------------------------------------
sub ProcessSecfile
{
	local($filename) = @_;

	print STDERR "\t$filename\n";
	open(SECFILE,"< $filename") || die "can't open $filename\n";
	while (<SECFILE>) {
		next if /^\.in/;
		chop;
		@words = split(/[ 	]/, $_);
		foreach $entry (@words) {
			next if $entry =~ /(^\.[^.]|)/;

			# get rid of font escapes
			$entry =~ s/\\+f(I|B|P|C|\(CW|R|H)//g;

			# get rid of point size change escapes
			$entry =~ s/\\+s[+-]\d+//g;

			# get rid of T{ and T} --- tbl
			$entry =~ s/T[{}]//;

			# strip leading non-alphanumerics
			$entry =~ s/^\W+//;

			# strip trailing non-alphanumerics
			$entry =~ s/\W+$//;

			# ignore anything comprised only of digits
			next if $entry =~ /^\d+$/;

			# ignore anything containing no alphanumerics
			next if $entry =~ /^\W+$/;

			# gotta have at least one character to be worth indexing
			next unless $entry =~ /[A-Za-z]/;

			# ignore single letters left at this point
			next if $entry =~ /^.$/;

			next if $entry =~ /^lp\d/;
			next if $entry =~ /w\(/;

			$word = "\L$entry";
			$maxlen = length($word) if length($word) > $maxlen;
			if (!defined($file{$word})) {
				$file{$word} = "$filename";
			} else {
				$file{$word} .= ":$filename" unless
						$file{$word} =~ /$filename/;
			}
			$count{$word}++;
		}
	}
}

# ------------------------------------------------------------------------
# GenerateReport()
#	Work through the associated arrays, printing a formatted table
#	of word frequencies and the files where the words were found.
# ------------------------------------------------------------------------
sub GenerateReport
{
	open(WORDCOUNT,"> $LOGFILE") || die "Can't write logfile $LOGFILE\n";
	foreach $word (sort bycount keys(%count)) {
		$frequency = $count{$word};
		@files = split(/:/,$file{$word});
		print WORDCOUNT "$word",' ' x ($maxlen - length($word));
		printf(WORDCOUNT " %4d ",$frequency);
		for ($i=0; $i<int(@files); ++$i) {
			print WORDCOUNT "$files[$i]\n";
			print WORDCOUNT ' ' x ($maxlen+6) if $i < $#files;
		}
	}
	print STDERR "kwordfreq: output is in $LOGFILE\n";
}

sub bycount { $count{$b} <=> $count{$a}; }
