: # use perl
        eval 'exec perl -S $0 "$@"'
                if $runnning_under_some_shell;

@khoros_toolbox = ('KHOROS_TOOLBOX');
if (! eval("\$toolboxes = \$ENV{\"KHOROS_TOOLBOX\"}"))
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
@toolbox_list = split(':', $toolboxes);
foreach $toolbox_file (sort(@toolbox_list))
{
   if ( ! open(TBS,"<$toolbox_file"))
   {
      warn "Can not open $toolbox_file.  Please check to make sure your\n";
      die  "KHOROS_TOOLBOX environment variable points to existing files.\n";
   }

   while(<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            print "The SUPPORT toolbox is defined twice.  Please check your\n";
            print "KHOROS_TOOLBOX environment variable and the file(s)\n";
            print "pointed to by it and make sure that all toolboxes are\n";
            die   "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}

@INC = ("$support_path/repos/perl", @INC);
require 'khoros.pl';
require 'kutils.pl';

#========================================================================
# Program Name: kobjtable - no short description specified
# Purposed:	long description goes here
#
# RCS ID:	Khoros: $Id$
# RCS Log:	$Log$
#========================================================================

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

$whatis	= 'generate table of information about objects in a toolbox';
@cli_args	=
(
 'tb',          'toolbox', 'the toolbox(es) we\'re interested in',
 'o',           'file-name', 'the file to write the table to',
 '[clui]',      '',          'generate CLUI-oriented table',
 '[gui]',       '',          'generate GUI-oriented table',
 '[title]',     'string',    'title string for the table',
 '[incantata]', '',      'only use objects installed in cantata',
 '[lang]',  'language', 'the language to generate (tbl [default], latex, html)'
);

# -- initialize Khoros perl lib -----------------------------------------
&khoros'initialize("SUPPORT", $whatis, @cli_args);

# -- parse the command-line arguments -----------------------------------
&khoros'parse_args(@ARGV);

if ($khoros'seenswitch{'clui'} && $khoros'seenswitch{'gui'})
{
   die "You can only use one of -gui and -clui.\n";
}

$tabletype = 'gui';
$tabletype = 'clui' if $khoros'seenswitch{'clui'};

@toolboxes = split(/,/,$khoros'argval{'tb'});

# -- title string for table ---------------------------------------------
if ($khoros'seenswitch{'title'})
{
   $title  = $khoros'argval{'title'};
}
else
{
   $title = "Toolbox GUI Operators: @toolboxes" if $tabletype eq 'gui';
   $title = "Toolbox CLUI Operators: @toolboxes" if $tabletype eq 'clui';
}

# -- -o switch specifies the file to write the generated table to -------
$output = $khoros'argval{'o'};

$language = $khoros'argval{'lang'} || 'tbl';
if ($language ne 'tbl' && $language ne 'latex' && $language ne 'html')
{
   die "Unknown table language.  Bozo!\n";
}

open(OUTFILE, "> $output") || die "Can't write output file $output: $!\n";
select(OUTFILE);

&GenerateTableHeader();
if ($tabletype eq 'gui')
{
   &GenerateGuiBody();
}
else
{
   &GenerateCluiBody();
}
&GenerateTableFooter();


# =======================================================================
# Function Name: GenerateTableBody()
#
# Purpose:       This function generates the body of the table, which
#                contains one line per object.
# =======================================================================
sub GenerateGuiBody
{
   foreach $toolbox (@toolboxes)
   {
      &suckin($toolbox, 'kroutine');
      &suckin($toolbox, 'xvroutine');
      &suckin($toolbox, 'pane');
      &suckin($toolbox, 'script');
   }

   @cats = sort keys %categories;
   foreach $cat (@cats)
   {
      @subcats = ();
      foreach $key (keys %catnsub)
      {
	 ($dummy,$sub) = split(/:/, $key);
	 @subcats = sort(@subcats, $sub) if $dummy eq $cat;
      }

      foreach $subcat (@subcats)
      {
	 @objects = sort byIconName split(/:/,$csObjects{"$cat:$subcat"});
	 $line = 0;
	 if (@objects == 1)
	 {
	    $object = $objects[0];
	    $icon_name = "$oIconName{$object}";
	    unless ($khoros'seenswitch{'incantata'}) # '
            {
	       $icon_name = "$oIconName{$object}" unless $oCantata{$object};
            }
	    print "T{\n.nf\n\\fB$cat\\fP\n.fi\nT}:::\n";
	    print "T{\n.nf\n$subcat\n.fi\nT}:$icon_name:T{\n";
            print ".nf\n$oDescription{$object}\n.fi\n";
            print "T}:$object\n";
	 }
	 else
	 {
	    foreach $object (@objects)
	    {
	       $icon_name = "$oIconName{$object}";
	       unless ($khoros'seenswitch{'incantata'}) # '
	       {
	          $icon_name = "$oIconName{$object}" unless $oCantata{$object};
	       }
	       $col1 = '';
	       $col1 = "T{\n.nf\n\\fB$cat\\fP\n.fi\nT}" if $line == 0;
	       $col1 = "T{\n.nf\n$subcat\n.fi\nT}" if $line == 1;
	       print "$col1:$icon_name:T{\n";
	       print ".nf\n";
               print "$oDescription{$object}\n";
	       print ".fi\n";
               print "T}:$object\n";
	       print ":_:_:_\n" unless $object eq $objects[$#objects];
	       ++$line;
	    }
	    print "$subcat\n" if $line < 2;
	 }
	 print "=\n" unless $subcat eq $subcats[$#subcats];
      }
      print "=\n" unless $cat eq $cats[$#cats];
   }
}

# =======================================================================
# Function Name: GenerateCluiBody()()
#
# Purpose:       This function generates the body of the table, which
#                contains one line per object.
# =======================================================================
sub GenerateCluiBody
{
   foreach $toolbox (@toolboxes)
   {
      &suckin($toolbox, 'kroutine');
      &suckin($toolbox, 'xvroutine');
      &suckin($toolbox, 'pane');
      &suckin($toolbox, 'script');
   }

   @objects = sort keys %oDescription;
   foreach $object (@objects)
   {
      print "$object:$oIconName{$object}:T{\n";
      print "$oDescription{$object}\n";
      print "T}\n";
      print "_\n" unless $object eq $objects[$#objects];
   }
}

# =======================================================================
# Function Name: suckin()
#
# Purpose:       This function takes a toolbox name and software object
#                type, and sucks in information for objects of the
#                given type.
# =======================================================================
sub suckin
{
   local($toolbox,$otype) = @_;
   local($objlist);
   local(@objects);
   local($object);
   local($category);
   local($subcategory);
   local($bname);
   local($icon);
   local($description);
   local($kecho);
   local(*INFILE);


   open(INFILE, "kecho -tb $toolbox -type $otype -echo object-info | ") || do
   {
      warn "Couldn't read information for $toolbox, $otype: $!\n";
      return;
   };
   while (<INFILE>)
   {
      $object = $1 if /^begin\s+[^::]+::(\S+)/;
      $oBinary{$object} = $1 if /^\s+binary-name=(.*)\s*$/;
      $oCategory{$object} = $1 if /^\s+category=(.*)\s*$/;
      $oSubcategory{$object} = $1 if /^\s+subcategory=(.*)\s*$/;
      $oDescription{$object} = $1 if /^\s+short-description=(.*)\s*$/;
      $oIconName{$object} = $1 if /^\s+icon-name=(.*)\s*$/;
      if (/^\s+in-cantata=(.*)\s*$/)
      {
	 $oCantata{$object} = 1 if $1 eq 'YES';
      }
      /^end\s+[^:]+::(\S+)/ && do
      {
	 next if $khoros'seenswitch{'incantata'} && $oCantata{$object} != 1;
	 $object = $1;
	 $categories{$oCategory{$object}} = 1;
	 $key = $oCategory{$object}.':'.$oSubcategory{$object};
	 $catnsub{"$key"} = 1;
	 if (defined $csObjects{"$key"})
	 {
	    $csObjects{"$key"} .= ":$object";
	 }
	 else
	 {
	    $csObjects{"$key"} = "$object";
	 }
      };
   }
}

# ========================================================================
# Function Name: GenerateTableHeader - generate the top of the tbl table
# Purpose:       This function generates the top of the table.
# ========================================================================
sub GenerateTableHeader
{
   if ($language eq 'tbl')
   {
      if ($tabletype eq 'gui')
      {
         print ".TS H\n";
         print "center box tab(:) ;\n";
         print "cfB s s s\n";
         print "cf(B)p10 | cf(B)p10 | cf(B)p10 | cf(B)p10\n";
         print "cf(B)p10 | cf(B)p10 | cf(B)p10 | cf(B)p10\n";
         print "lp8 | lp8 | lp8 | lp7f(CW) .\n";
         print ".sp .5\n";
         print "T{\n";
         print "$title\n";
         print "T}\n";
         print ".sp .5\n";
         print "_\n";
         print "Category:Operator:Description:Executable\n";
         print "Subcategory\n";
         print "=\n";
         print ".TH\n";
      }
      else
      {
         print ".TS H\n";
         print "center box tab(:) ;\n";
         print "cfB s s\n";
         print "cf(B)p10 | cf(B)p10 | cf(B)p10w(3.5i) \n";
         print "lp7f(CW) | lp8      | lp8 .\n";
         print ".sp .5\n";
         print "T{\n";
         print "$title\n";
         print "T}\n";
         print ".sp .5\n";
         print "_\n";
         print "Executable:Operator:Description\n";
         print "=\n";
         print ".TH\n";
      }
   }
   elsif ($language eq 'latex')
   {
      print "\\begin{tabular}{|c|c|c|c|}\n";
      print "\\hline\n";
      print "\\multicolumn{4}{|c|}{$title} \\\\ \n";
      print "\\hline\n";
      print "\\hline\n";
      print "Category    & Operator & Description & Executable \\\\ \n";
      print "Subcategory &          &             &        \\\\ \n";
      print "\\hline\n";
      print "% End of Table Header\n";
   }
   elsif ($language eq 'html')
   {
      print "<HR>\n";
      print "<H2>$title</H2>\n";
      print "<HR>\n";
      print "<P>\n";
      print "<DL>\n";
   }
}

# ========================================================================
# Function Name: GenerateTableFooter - generate the end of the tbl table
# Purpose:       This function generates the closing part of the table.
#                This function should eventually put a caption on the
#                table...
# ========================================================================
sub GenerateTableFooter
{
   if ($language eq 'tbl')
   {
      print ".TE\n";
   }
   elsif ($language eq 'latex')
   {
      print "% End of Table Body\n";
      print "\\hline\n";
      print "\\end{tabular}\n";
      print "% End of Table Footer\n";
   }
   elsif ($language eq 'html')
   {
      print "<!-- End of Table Body -->\n";
      print "</DL>\n";
   }
}

sub byIconName
{
   $oIconName{$a} cmp $oIconName{$b}
}
