
 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Image Display Utility Routines
   >>>>
   >>>>  Private:
   >>>>      whatis()
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "kgenwhatis.h"

#define LIB_NAME_PARSE_KEY ".TH \"[^\"]*\" \"[^\"]*\" \"[^\"]*\" \""
#define SD_PARSE_KEY ".SH.*\n%s[ \t]*\\\\*-*[ \t]*"
#define WHATIS_FILE "whatis"

/*-----------------------------------------------------------
|
|  Routine Name: whatis() - main routine for bldmanual
|
|       Purpose: This routine will open the toolbox object and the
|		 output file, then call the find_token routine
|		 to parse the input files.		 
|
|         Input: input_file - the input file to parse
|                output_file - the name of the resulting output file
|                toolbox - the name of the toolbox file
|
|        Output: None
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Tom Sauer
|          Date Apr 22, 1993 21:03
| Modifications:
|
------------------------------------------------------------*/

int
whatis(
	char		*tbname)
{
	kfile		*optr, *fptr;
	char		**man_pages, **sorted_manpages, *tbpath;
	char		*whatis_entry, *lib_name;
	char		*output_file;
	char		manpage[KLENGTH], parse_key[KLENGTH], paren[KLENGTH];
        int		status, num, i;
	kobject		toolbox;


      /*
       * open program object to get info about the program
       */

	if ((toolbox = kcms_open_toolbox(tbname)) == NULL)
	{
		kerror(NULL,"whatis()", "Cannot open toolbox object '%s'\n",
		       tbname);
		return(FALSE);
	}

	/*
	 * get the path to the toolbox
	 */

	kcms_get_attribute(toolbox, KCMS_TB_PATH, &tbpath);

        if (tbpath == NULL)
	{
		kerror(NULL, "whatis()", "Cannot find the path for toolbox \
object '%s'\n", tbname);
		kcms_close(toolbox);
		return(FALSE);
	}

	/*
	 * get a list of the manpages to parse
	 */

	tbpath = kstring_3cat(tbpath, "/", "man", NULL);
	man_pages = karray_dirlist(NULL, tbpath, "man.*", 
			KFILE | KPATH | KRECURSE, FALSE, &num);
	if (man_pages == NULL)
	{
		kinfo(KSTANDARD, 
			"Cannot find any man pages for toolbox object '%s'\n",
			tbname);
		kcms_close(toolbox);
		return(FALSE);
	}

	/*
	 * sort the man pages in alphabetical order
	 */

	sorted_manpages = karray_sort(man_pages, num, FALSE);
	if (sorted_manpages == NULL)
	{
		kerror(NULL, "whatis()",
			"Sorting %s for toolbox object '%s' failed\n",
			"list of man pages",tbname);
		kcms_close(toolbox);
		return(FALSE);
	}
	
	/*
	 * open the whatis file for output
	 */

	output_file = kstring_3cat(tbpath, "/", WHATIS_FILE, NULL);

	if ((optr = kfopen(output_file, "w")) == NULL)
	{
	   kerror(NULL, "whatis",
		    "Cannot open the output file '%s'\n", output_file);
	   return(FALSE);
	}
	kfree(output_file);

	/*
	 * for every manpage, open the man page , find the short
	 * description and write it out to the whatis file.
	 */

	for (i = 0; i < num; i++)
	{
	    if ((fptr = kfopen(sorted_manpages[i], "r" )) == NULL)
	    {
	       kerror(NULL, "whatis",
		        "Cannot open the input man file '%s'\n",
			 sorted_manpages[i]);
	       return(FALSE);
	    }

	    kbasename(sorted_manpages[i], manpage);
	    lib_name = kparse_file_scan(fptr, LIB_NAME_PARSE_KEY, "\"", 
				    KIGNORE_CASE, NULL, NULL, &status);
	    if (status == KPARSE_OK && kstrlen(lib_name) == 0)
	    {
		paren[0] = '\0';
		lib_name = kstring_copy("(1)", NULL);
	    }
	    else
	    {
		kstrcpy(paren, "()");
	    }

	    krewind(fptr);
	    ksprintf(parse_key, SD_PARSE_KEY, manpage);
	    whatis_entry = kparse_file_scan(fptr, parse_key, "\n", 
				    KIGNORE_CASE, NULL, NULL, &status);
	    if (status == KPARSE_OK) 
	    {
	        kfprintf(optr, "%s%s %s\t\t-  %s\n", 
				manpage, paren, lib_name, whatis_entry);
	    }

	    kfclose(fptr);
	    kfree(lib_name);
	    kfree(whatis_entry);
	}

	karray_free(sorted_manpages, num, NULL);
	kcms_close(toolbox);
	kfclose(optr);
	return(TRUE);
}
