 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kdbmcat.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kdbmcat_get_args
| 
|       Purpose: Gets command line args for kdbmcat
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kdbmcat
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kdbmcat_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kdbmcat is out of sync with arguments specified in kdbmcat's *.pane file; please rerun ghostwriter on kdbmcat.";


	/*
	 * allocate the kdbmcat structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_string(pane, "tb",
			  &(clui_info->tb_string),
			  &(clui_info->tb_flag))))
	{
	    kerror(NULL, "kdbmcat_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "oname",
			  &(clui_info->oname_string),
			  &(clui_info->oname_flag))))
	{
	    kerror(NULL, "kdbmcat_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "manpage",
			  &(clui_info->manpage_flag))))
	{
	    kerror(NULL, "kdbmcat_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "cms",
			  &(clui_info->cms_flag))))
	{
	    kerror(NULL, "kdbmcat_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "functions",
			  &(clui_info->functions_flag))))
	{
	    kerror(NULL, "kdbmcat_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "dbm",
			  &(clui_info->dbm_string),
			  &(clui_info->dbm_flag))))
	{
	    kerror(NULL, "kdbmcat_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



